/*
 * Decompiled with CFR 0.152.
 */
package awtext;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.EventListener;

public class SEventInterestListenerList
implements Serializable {
    private static final Object[] NULL_ARRAY = new Object[0];
    protected transient Object[] listenerList = NULL_ARRAY;
    private final boolean iAutoRemoveIfWindow;

    public SEventInterestListenerList() {
        this.iAutoRemoveIfWindow = false;
    }

    public SEventInterestListenerList(boolean autoRemoveIfWindow) {
        this.iAutoRemoveIfWindow = autoRemoveIfWindow;
    }

    public Object[] getListenerList() {
        return this.listenerList;
    }

    public <T extends EventListener> T[] getListeners(Class<T> t) {
        Object[] lList = this.listenerList;
        int n = this.getListenerCount(lList, t);
        EventListener[] result = (EventListener[])Array.newInstance(t, n);
        int j = 0;
        int i = lList.length - 3;
        while (i >= 0) {
            if (lList[i] == t) {
                result[j++] = (EventListener)lList[i + 2];
            }
            i -= 3;
        }
        return result;
    }

    public int getListenerCount() {
        return this.listenerList.length / 3;
    }

    public int getListenerCount(Class<?> t) {
        Object[] lList = this.listenerList;
        return this.getListenerCount(lList, t);
    }

    private int getListenerCount(Object[] list, Class t) {
        int count = 0;
        int i = 0;
        while (i < list.length) {
            if (t == (Class)list[i]) {
                ++count;
            }
            i += 3;
        }
        return count;
    }

    public synchronized <T extends EventListener> void add(Class<T> t, T l, Object interest) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        if (this.listenerList == NULL_ARRAY) {
            this.listenerList = new Object[]{t, interest, l};
        } else {
            int i = this.listenerList.length;
            Object[] tmp = new Object[i + 3];
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            tmp[i] = t;
            tmp[i + 1] = interest;
            tmp[i + 2] = l;
            this.listenerList = tmp;
        }
        if (this.iAutoRemoveIfWindow && l instanceof Window) {
            ((Window)((Object)l)).addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    SEventInterestListenerList.this.removeClosedWindow(e.getWindow());
                    super.windowClosed(e);
                }
            });
        }
    }

    public synchronized <T extends EventListener> void add(Class<T> t, T l) {
        this.add(t, l, null);
    }

    private synchronized <T extends EventListener> boolean internalRemove(Class<T> t, T l, Object interest) {
        int index = -1;
        int i = this.listenerList.length - 3;
        while (i >= 0) {
            if (this.listenerList[i] == t && this.listenerList[i + 1] == interest && this.listenerList[i + 2].equals(l)) {
                index = i;
                break;
            }
            i -= 3;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 3];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 3, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
            return true;
        }
        return false;
    }

    public synchronized <T extends EventListener> void remove(Class<T> t, T l, Object interest) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        this.internalRemove(t, l, interest);
    }

    public synchronized <T extends EventListener> void remove(Class<T> t, T l) {
        this.remove(t, l, null);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] lList = this.listenerList;
        s.defaultWriteObject();
        int i = 0;
        while (i < lList.length) {
            Class t = (Class)lList[i];
            EventListener l = (EventListener)lList[i + 2];
            if (l != null && l instanceof Serializable) {
                s.writeObject(t.getName());
                s.writeObject(l);
            }
            i += 3;
        }
        s.writeObject(null);
    }

    protected synchronized void removeClosedWindow(Window w) {
        while (this.removeWindow(w)) {
        }
    }

    protected synchronized boolean removeWindow(Window w) {
        int index = -1;
        int i = this.listenerList.length - 3;
        while (i >= 0) {
            if (this.listenerList[i + 2].equals(w)) {
                index = i;
                break;
            }
            i -= 3;
        }
        if (index != -1) {
            Object[] tmp = new Object[this.listenerList.length - 3];
            System.arraycopy(this.listenerList, 0, tmp, 0, index);
            if (index < tmp.length) {
                System.arraycopy(this.listenerList, index + 3, tmp, index, tmp.length - index);
            }
            this.listenerList = tmp.length == 0 ? NULL_ARRAY : tmp;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object listenerTypeOrNull;
        this.listenerList = NULL_ARRAY;
        s.defaultReadObject();
        while ((listenerTypeOrNull = s.readObject()) != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            EventListener l = (EventListener)s.readObject();
            this.add(Class.forName((String)listenerTypeOrNull, true, cl), l);
        }
    }

    public String toString() {
        Object[] lList = this.listenerList;
        String s = "EventListenerList: ";
        s = String.valueOf(s) + lList.length / 2 + " listeners: ";
        int i = 0;
        while (i <= lList.length - 3) {
            s = String.valueOf(s) + " type " + ((Class)lList[i]).getName();
            s = String.valueOf(s) + " listener " + lList[i + 1];
            i += 3;
        }
        return s;
    }
}

