/*
 * Decompiled with CFR 0.152.
 */
package awtext;

import java.awt.Dimension;
import java.awt.Point;

public final class SPair {
    private int iVal1;
    private int iVal2;
    static String iPrefix = "SPair[";
    static String iSuffix = "]";
    static String iDelimiter = ";";

    public SPair() {
        this.iVal1 = 0;
        this.iVal2 = 0;
    }

    public SPair(SPair p) {
        this.setPair(p);
    }

    public SPair(Point p) {
        this.setPoint(p);
    }

    public SPair(Dimension d) {
        this.setDimension(d);
    }

    public SPair(int v1, int v2) {
        this.setValue1(v1);
        this.setValue2(v2);
    }

    public int getValue1() {
        return this.iVal1;
    }

    public void setValue1(int value1) {
        this.iVal1 = value1;
    }

    public int getValue2() {
        return this.iVal2;
    }

    public void setValue2(int value2) {
        this.iVal2 = value2;
    }

    public void setPair(SPair p) {
        this.setValue1(p.getValue1());
        this.setValue2(p.getValue2());
    }

    public void setPoint(Point p) {
        this.setValue1(p.x);
        this.setValue2(p.y);
    }

    public void setDimension(Dimension d) {
        this.setValue1(d.width);
        this.setValue2(d.height);
    }

    public int getX() {
        return this.getValue1();
    }

    public void setX(int x) {
        this.setValue1(x);
    }

    public int getY() {
        return this.getValue2();
    }

    public void setY(int y) {
        this.setValue2(y);
    }

    public int getWidth() {
        return this.getValue1();
    }

    public void setWidth(int width) {
        this.setValue1(width);
    }

    public int getHeight() {
        return this.getValue2();
    }

    public void setHeight(int height) {
        this.setValue1(height);
    }

    public Dimension asDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Point asPoint() {
        return new Point(this.getX(), this.getY());
    }

    public String toString() {
        return String.valueOf(iPrefix) + new Integer(this.iVal1).toString() + iDelimiter + new Integer(this.iVal2).toString() + iSuffix;
    }

    public static SPair parsePair(String val) throws NumberFormatException {
        if (!val.substring(0, iPrefix.length()).equals(iPrefix)) {
            throw new NumberFormatException("");
        }
        SPair rc = new SPair();
        String x1 = val.substring(iPrefix.length(), val.indexOf(iDelimiter));
        val = val.substring(val.indexOf(iDelimiter) + 1);
        String x2 = val.substring(0, val.length() - 1);
        rc.setX(Integer.parseInt(x1));
        rc.setY(Integer.parseInt(x2));
        return rc;
    }
}

