/*
 * Decompiled with CFR 0.152.
 */
package awtext;

import java.util.EventObject;

public class SRefreshEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private int iMaxSteps = 100;
    private int iCurrentStep = 0;
    public static final int BEGIN_REFRESH = 0;
    public static final int END_REFRESH = 1;
    public static final int REFRESH_STEP = 2;
    public static final int EXEC_COMMAND = 3;
    public static final int USER_DEFINED_DATA = 4;
    private int iMode = 2;
    private Object iData1 = null;
    private Object iData2 = null;
    private EventCmd iCommand = null;

    public SRefreshEvent(Object source) {
        super(source);
    }

    public SRefreshEvent(Object source, int mode) {
        this(source);
        this.setMode(mode);
    }

    public SRefreshEvent(Object source, int mode, int currentStep) {
        this(source);
        this.setMode(mode);
        this.setCurrentStep(currentStep);
    }

    public SRefreshEvent(Object source, int mode, int currentStep, int maxSteps) {
        this(source);
        this.setMode(mode);
        this.setCurrentStep(currentStep);
        this.setMaxSteps(maxSteps);
    }

    public SRefreshEvent(Object source, EventCmd cmd) {
        this(source);
        this.setMode(3);
        this.setCommand(cmd);
    }

    public SRefreshEvent(Object source, EventCmd cmd, Object data1) {
        this(source);
        this.setMode(3);
        this.setCommand(cmd);
        this.setData1(data1);
    }

    public SRefreshEvent(Object source, EventCmd cmd, Object data1, Object data2) {
        this(source);
        this.setMode(3);
        this.setCommand(cmd);
        this.setData1(data1);
        this.setData2(data2);
    }

    public double getPercentReady() {
        if (this.getMaxSteps() <= 0) {
            return 0.0;
        }
        return (double)(this.getCurrentStep() * 100 * 100 / this.getMaxSteps()) / 100.0;
    }

    public int getMode() {
        return this.iMode;
    }

    public void setMode(int mode) {
        this.iMode = mode;
    }

    public int getMaxSteps() {
        return this.iMaxSteps;
    }

    private void setMaxSteps(int maxSteps) {
        this.iMaxSteps = maxSteps;
    }

    public int getCurrentStep() {
        return this.iCurrentStep;
    }

    private void setCurrentStep(int currentStep) {
        this.iCurrentStep = currentStep;
    }

    public Object getData1() {
        return this.iData1;
    }

    public void setData1(Object data1) {
        this.iData1 = data1;
    }

    public Object getData2() {
        return this.iData2;
    }

    public void setData2(Object data2) {
        this.iData2 = data2;
    }

    public EventCmd getCommand() {
        return this.iCommand;
    }

    public void setCommand(EventCmd command) {
        this.iCommand = command;
    }

    public static enum EventCmd {
        SET_SORTING_ENABLED,
        CLEAR_TABLE_MODEL,
        INVALIDATE_ROW_HEADER,
        SET_VALUE_AT,
        SET_ROW_VALUES,
        REVALIDATE,
        REPAINT;

    }
}

