/*
 * Decompiled with CFR 0.152.
 */
package awtext;

import awtext.SDefaultRefreshBroadcaster;
import awtext.SRefreshBroadcaster;
import awtext.SRefreshEvent;
import awtext.SRefreshListener;
import awtext.SRefreshable;
import awtext._SSwingWorker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SRefreshManager
implements PropertyChangeListener,
SRefreshBroadcaster {
    private SRefreshable iRefreshable = null;
    private Method iMethod;
    private Timer iTimer;
    private final PropertyChangeSupport iPropertyChangeSupport;
    private _SSwingWorker<SRefreshEvent, SRefreshEvent> iCurrentWorker = null;
    private Semaphore iRefreshing = new Semaphore(1);
    private SRefreshBroadcaster iBroadcaster = new SDefaultRefreshBroadcaster();

    public SRefreshManager(SRefreshable refreshable, Method method, int delay) {
        this.setMethod(method);
        this.iPropertyChangeSupport = new PropertyChangeSupport(this);
        this.iRefreshable = refreshable;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SRefreshManager.this.run(true);
            }
        };
        this.iTimer = new Timer(10000, al);
        this.iTimer.setInitialDelay(delay);
        this.iTimer.setCoalesce(true);
        this.iTimer.start();
    }

    public SRefreshManager(SRefreshable refreshable, Method method, int delay, int interval) {
        this.setMethod(method);
        this.iPropertyChangeSupport = new PropertyChangeSupport(this);
        this.iRefreshable = refreshable;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SRefreshManager.this.run(true);
            }
        };
        this.iTimer = new Timer(interval, al);
        this.iTimer.setInitialDelay(delay);
        this.iTimer.setCoalesce(true);
        this.iTimer.start();
    }

    public boolean isRefreshing() {
        return this.iRefreshing.availablePermits() < 1;
    }

    private void runRefreshable() {
        try {
            this.iRefreshable.refresh();
        }
        finally {
            this.iRefreshing.release();
        }
    }

    public void cancel() {
        if (this.iTimer != null) {
            this.iTimer.stop();
            this.iTimer = null;
        }
    }

    private void runRefreshMethod() {
        switch (this.iMethod) {
            case DIRECT: {
                this.runRefreshable();
                break;
            }
            case INVOKELATER: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SRefreshManager.this.runRefreshable();
                    }
                });
                break;
            }
            case THREADED: {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        SRefreshManager.this.runRefreshable();
                    }
                };
                t.start();
                break;
            }
            case SWINGWORKER: {
                this.iCurrentWorker = new _SSwingWorker<SRefreshEvent, SRefreshEvent>(){

                    @Override
                    public SRefreshEvent doInBackground() {
                        SRefreshManager.this.runRefreshable();
                        return new SRefreshEvent((Object)this, 1);
                    }

                    @Override
                    protected void done() {
                        SRefreshManager.this.forwardSwingWorkerDoneFn();
                    }

                    @Override
                    protected void process(List<SRefreshEvent> chunks) {
                        SRefreshManager.this.forwardSwingWorkerProcessFn(chunks);
                    }
                };
                this.iCurrentWorker.addPropertyChangeListener(this);
                this.iCurrentWorker.execute();
                break;
            }
            default: {
                this.iRefreshing.release();
            }
        }
    }

    private void forwardSwingWorkerProcessFn(List<SRefreshEvent> chunks) {
        Iterator<SRefreshEvent> i = chunks.iterator();
        while (i.hasNext()) {
            this.fireRefreshEvent(i.next());
        }
    }

    private void forwardSwingWorkerDoneFn() {
        this.fireRefreshEvent(new SRefreshEvent((Object)this, 1));
        this.iCurrentWorker.removePropertyChangeListener(this);
        this.iCurrentWorker = null;
    }

    private void run(boolean callIsCurrent) {
        if (this.iRefreshable == null) {
            return;
        }
        if (this.iRefreshing.tryAcquire()) {
            if (!callIsCurrent || !this.iRefreshable.isCurrent()) {
                this.runRefreshMethod();
            } else {
                this.iRefreshing.release();
            }
        }
    }

    public void forceExceution() {
        this.run(false);
    }

    public boolean isDelayedRefreshInvokation() {
        return this.iMethod == Method.INVOKELATER;
    }

    public boolean isThreadedRefreshInvokation() {
        return this.iMethod == Method.THREADED;
    }

    public boolean isSwingWorkerInvokation() {
        return this.iMethod == Method.SWINGWORKER;
    }

    public void setInvokationMethod(Method method) {
        this.iMethod = method;
    }

    public Method getInvokationMethod() {
        return this.iMethod;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.iPropertyChangeSupport;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getPropertyChangeSupport().firePropertyChange(evt);
    }

    @Override
    public void addRefreshListener(SRefreshListener l) {
        this.iBroadcaster.addRefreshListener(l);
    }

    @Override
    public void fireRefreshEvent(SRefreshEvent evt) {
        if (!SwingUtilities.isEventDispatchThread() && this.iCurrentWorker != null) {
            this.iCurrentWorker.doPublish((SRefreshEvent[])new SRefreshEvent[]{evt});
            return;
        }
        this.iBroadcaster.fireRefreshEvent(evt);
    }

    @Override
    public void removeRefreshListener(SRefreshListener l) {
        this.iBroadcaster.removeRefreshListener(l);
    }

    public Method getMethod() {
        return this.iMethod;
    }

    public void setMethod(Method method) {
        this.iMethod = method;
    }

    public static enum Method {
        DISABLED,
        DIRECT,
        INVOKELATER,
        THREADED,
        SWINGWORKER;

    }
}

