/*
 * Decompiled with CFR 0.152.
 */
package awtext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import sun.awt.AppContext;
import sun.swing.AccumulativeRunnable;

public abstract class SSwingWorker<T, V>
implements RunnableFuture<T> {
    private static final int MAX_WORKER_THREADS = 10;
    private volatile int progress;
    private volatile StateValue state;
    private FutureTask<T> future;
    private final PropertyChangeSupport propertyChangeSupport;
    private AccumulativeRunnable<V> doProcess;
    private AccumulativeRunnable<Integer> doNotifyProgressChange;
    private final AccumulativeRunnable<Runnable> doSubmit = SSwingWorker.getDoSubmit();
    private Callable<T> callable = new Callable<T>(){

        @Override
        public T call() throws Exception {
            SSwingWorker.this.setState(StateValue.STARTED);
            return SSwingWorker.this.doInBackground();
        }
    };
    private static final Object DO_SUBMIT_KEY = new StringBuilder("doSubmit");

    private void initNewFuture() {
        this.future = new FutureTask<T>(this.callable){

            @Override
            protected void done() {
                SSwingWorker.this.doneEDT();
                SSwingWorker.this.setState(StateValue.DONE);
            }
        };
    }

    public SSwingWorker() {
        this.initNewFuture();
        this.state = StateValue.PENDING;
        this.propertyChangeSupport = new SwingWorkerPropertyChangeSupport(this);
        this.doProcess = null;
        this.doNotifyProgressChange = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.future.run();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SSwingWorker.this.initNewFuture();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(V ... chunks) {
        SSwingWorker sSwingWorker = this;
        synchronized (sSwingWorker) {
            if (this.doProcess == null) {
                this.doProcess = new AccumulativeRunnable<V>(){

                    @Override
                    public void run(List<V> args) {
                        SSwingWorker.this.process(args);
                    }

                    @Override
                    protected void submit() {
                        SSwingWorker.this.doSubmit.add(this);
                    }
                };
            }
        }
        this.doProcess.add(chunks);
    }

    protected void process(List<V> chunks) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int progress) {
        if (progress < 0 || progress > 100) {
            throw new IllegalArgumentException("the value should be from 0 to 100");
        }
        if (this.progress == progress) {
            return;
        }
        int oldProgress = this.progress;
        this.progress = progress;
        if (!this.getPropertyChangeSupport().hasListeners("progress")) {
            return;
        }
        SSwingWorker sSwingWorker = this;
        synchronized (sSwingWorker) {
            if (this.doNotifyProgressChange == null) {
                this.doNotifyProgressChange = new AccumulativeRunnable<Integer>(){

                    @Override
                    public void run(List<Integer> args) {
                        SSwingWorker.this.firePropertyChange("progress", args.get(0), args.get(args.size() - 1));
                    }

                    @Override
                    protected void submit() {
                        SSwingWorker.this.doSubmit.add(this);
                    }
                };
            }
        }
        this.doNotifyProgressChange.add((Integer[])new Integer[]{oldProgress, progress});
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void execute() {
        SSwingWorker.getWorkersExecutorService().execute(this);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    public final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.getPropertyChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final StateValue getState() {
        if (this.isDone()) {
            return StateValue.DONE;
        }
        return this.state;
    }

    private void setState(StateValue state) {
        StateValue old = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)old, (Object)state);
    }

    private void doneEDT() {
        Runnable doDone = new Runnable(){

            @Override
            public void run() {
                SSwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            doDone.run();
        } else {
            this.doSubmit.add((Runnable[])new Runnable[]{doDone});
        }
    }

    private static synchronized ExecutorService getWorkersExecutorService() {
        AppContext appContext = AppContext.getAppContext();
        Object obj = appContext.get(SwingWorker.class);
        if (obj == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.defaultFactory.newThread(r);
                    thread.setName("SSwingWorker-" + thread.getName());
                    return thread;
                }
            };
            obj = new ThreadPoolExecutor(0, 10, 1L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory){
                private final ReentrantLock pauseLock = new ReentrantLock();
                private final Condition unpaused = this.pauseLock.newCondition();
                private boolean isPaused = false;
                private final ReentrantLock executeLock = new ReentrantLock();

                @Override
                public void execute(Runnable command) {
                    this.executeLock.lock();
                    try {
                        this.pauseLock.lock();
                        try {
                            this.isPaused = true;
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                        this.setCorePoolSize(10);
                        super.execute(command);
                        this.setCorePoolSize(0);
                        this.pauseLock.lock();
                        try {
                            this.isPaused = false;
                            this.unpaused.signalAll();
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                    }
                    finally {
                        this.executeLock.unlock();
                    }
                }

                @Override
                protected void afterExecute(Runnable r, Throwable t) {
                    super.afterExecute(r, t);
                    this.pauseLock.lock();
                    try {
                        try {
                            while (this.isPaused) {
                                this.unpaused.await();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            this.pauseLock.unlock();
                        }
                    }
                    finally {
                        this.pauseLock.unlock();
                    }
                }
            };
            appContext.put(SwingWorker.class, obj);
        }
        return (ExecutorService)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AccumulativeRunnable<Runnable> getDoSubmit() {
        Object object = DO_SUBMIT_KEY;
        synchronized (object) {
            AppContext appContext = AppContext.getAppContext();
            Object doSubmit = appContext.get(DO_SUBMIT_KEY);
            if (doSubmit == null) {
                doSubmit = new DoSubmitAccumulativeRunnable();
                appContext.put(DO_SUBMIT_KEY, doSubmit);
            }
            return (AccumulativeRunnable)doSubmit;
        }
    }

    private static class DoSubmitAccumulativeRunnable
    extends AccumulativeRunnable<Runnable>
    implements ActionListener {
        private static final int DELAY = 33;

        private DoSubmitAccumulativeRunnable() {
        }

        @Override
        protected void run(List<Runnable> args) {
            for (Runnable runnable : args) {
                runnable.run();
            }
        }

        @Override
        protected void submit() {
            Timer timer = new Timer(33, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.run();
        }
    }

    public static enum StateValue {
        PENDING,
        STARTED,
        DONE;

    }

    private class SwingWorkerPropertyChangeSupport
    extends PropertyChangeSupport {
        SwingWorkerPropertyChangeSupport(Object source) {
            super(source);
        }

        @Override
        public void firePropertyChange(final PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(evt);
            } else {
                SSwingWorker.this.doSubmit.add(new Runnable(){

                    @Override
                    public void run() {
                        SwingWorkerPropertyChangeSupport.this.firePropertyChange(evt);
                    }
                });
            }
        }
    }
}

