/*
 * Decompiled with CFR 0.152.
 */
package awtext;

import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SWindowList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Window[] NULL_ARRAY = new Window[0];
    protected transient Window[] iWindowList = NULL_ARRAY;

    public Window[] getWindowList() {
        return this.iWindowList;
    }

    public int getCount() {
        return this.iWindowList.length;
    }

    public synchronized boolean add(Window w) {
        if (w == null || this.contains(w)) {
            return false;
        }
        if (this.iWindowList == NULL_ARRAY) {
            this.iWindowList = new Window[]{w};
        } else {
            int i = this.iWindowList.length;
            Window[] tmp = new Window[i + 1];
            System.arraycopy(this.iWindowList, 0, tmp, 0, i);
            tmp[i] = w;
            this.iWindowList = tmp;
        }
        return true;
    }

    public synchronized boolean remove(Window w) {
        int index = this.findIndex(w);
        if (index != -1) {
            if (this.iWindowList.length == 1) {
                this.iWindowList = NULL_ARRAY;
            } else {
                Window[] tmp = new Window[this.iWindowList.length - 1];
                System.arraycopy(this.iWindowList, 0, tmp, 0, index);
                if (index < tmp.length) {
                    System.arraycopy(this.iWindowList, index + 1, tmp, index, tmp.length - index);
                }
                this.iWindowList = tmp;
            }
            return true;
        }
        return false;
    }

    public synchronized int findIndex(Window w) {
        int i = 0;
        while (i < this.iWindowList.length) {
            if (this.iWindowList[i].equals(w)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public synchronized Window findByName(String name) {
        Window[] windowArray = this.iWindowList;
        int n = this.iWindowList.length;
        int n2 = 0;
        while (n2 < n) {
            Window element = windowArray[n2];
            if (element.getName() != null && element.getName().equals(name)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public synchronized boolean contains(Window w) {
        return this.findIndex(w) != -1;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Window[] wlist = this.iWindowList;
        s.defaultWriteObject();
        Window[] windowArray = wlist;
        int n = wlist.length;
        int n2 = 0;
        while (n2 < n) {
            Window element = windowArray[n2];
            if (element != null) {
                s.writeObject(element);
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Window w;
        this.iWindowList = NULL_ARRAY;
        s.defaultReadObject();
        while ((w = (Window)s.readObject()) != null) {
            this.add(w);
        }
    }

    public String toString() {
        Window[] lList = this.iWindowList;
        String s = "SWindowList: ";
        s = String.valueOf(s) + lList.length + " windows: ";
        int i = 0;
        while (i <= lList.length) {
            s = String.valueOf(s) + "Window " + lList[i].toString();
            ++i;
        }
        return s;
    }
}

