/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.SFileLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;

public class SFile
extends File {
    private static final long serialVersionUID = 1L;
    private SFileLock iLock = null;

    public SFile(File parent, String child) {
        super(parent, child);
    }

    public SFile(String parent, String child) {
        super(parent, child);
    }

    public SFile(String pathname) {
        super(pathname);
    }

    public SFile(URI uri) {
        super(uri);
    }

    public boolean hasPath() {
        return SFile.hasPath(this);
    }

    public static boolean hasPath(String fileName) {
        return SFile.hasPath(new File(fileName));
    }

    public static boolean hasPath(File file) {
        return file.getPath().contains(File.separator);
    }

    public SFileLock sharedLock() {
        return this.sharedLock(0L, Long.MAX_VALUE);
    }

    public SFileLock sharedLock(long pos, long size) {
        SFileLock lck = null;
        try {
            lck = this.getLock();
            lck.sharedLock(pos, size);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lck;
    }

    public SFileLock exclusiveLock() {
        return this.exclusiveLock(0L, Long.MAX_VALUE);
    }

    public SFileLock exclusiveLock(long pos, long size) {
        SFileLock lck = null;
        try {
            lck = this.getLock();
            lck.exclusiveLock(pos, size);
            return lck;
        }
        catch (IOException e) {
            e.printStackTrace();
            return lck;
        }
    }

    public void releaseLock() {
        this.releaseLock(this.getLock());
    }

    public synchronized void releaseLock(SFileLock lck) {
        this.getLock().releaseLock();
        if (!this.getLock().isLocked()) {
            SFileLock.releaseLock(this.iLock);
            this.iLock = null;
        }
    }

    public boolean isLocked() {
        return this.getLock().isLocked();
    }

    public static final void copy(String srcName, String dstName) throws FileNotFoundException, IOException {
        FileChannel sCh = new FileInputStream(srcName).getChannel();
        FileChannel dCh = new FileOutputStream(dstName).getChannel();
        dCh.transferFrom(sCh, 0L, sCh.size());
        sCh.close();
        dCh.close();
        File sf = new File(srcName);
        File df = new File(dstName);
        df.setLastModified(sf.lastModified());
    }

    public final void copyTo(String dstName) throws FileNotFoundException, IOException {
        SFile.copy(this.getAbsolutePath(), dstName);
    }

    public final void copyFrom(String srcName) throws FileNotFoundException, IOException {
        SFile.copy(srcName, this.getAbsolutePath());
    }

    public SFileLock getLock() {
        if (this.iLock == null) {
            this.iLock = SFileLock.getNewFileLock(this.getAbsolutePath());
        }
        return this.iLock;
    }
}

