/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.ReentrantLock;

public class SFileLock
implements Comparable {
    private static ReentrantLock iAccessLock = new ReentrantLock(true);
    private String iFileName = "";
    private Thread iOwnerThread = null;
    private int iLockCount = 0;
    static final String LOCKEXT = ".lock";
    static final int ACQUIRE_LOCKFILE = 1;
    static final int ACQUIRE_FILELOCK = 2;
    static final int ACQUIRE_ALL = 3;
    static ConcurrentSkipListSet<SFileLock> iLocks = new ConcurrentSkipListSet();
    static Thread iShutdownThread = null;
    _SFileLockInfo iFileLockInfo = new _SFileLockInfo();
    private Thread[] iAllowedThreads = new Thread[0];

    public static SFileLock getNewFileLock(String fileName) {
        try {
            iAccessLock.lock();
            SFileLock lck = SFileLock.findFileLock(fileName);
            if (lck == null) {
                lck = new SFileLock();
                lck.setFileName(fileName);
                iLocks.add(lck);
            }
            SFileLock sFileLock = lck;
            return sFileLock;
        }
        finally {
            iAccessLock.unlock();
        }
    }

    public static void releaseLock(SFileLock lck) {
        if (lck != null) {
            try {
                iAccessLock.lock();
                iLocks.remove(lck);
            }
            finally {
                iAccessLock.unlock();
            }
        }
    }

    static void removeAll() {
        while (!iLocks.isEmpty()) {
            try {
                SFileLock lck = iLocks.first();
                while (lck.isLocked()) {
                    lck.releaseLock();
                    SFileLock.releaseLock(lck);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public static SFileLock findFileLock(String fileName) {
        try {
            iAccessLock.lock();
            Thread t = Thread.currentThread();
            for (SFileLock lck : iLocks) {
                if (!lck.getFileName().equals(fileName) || !lck.isThreadAllowed(t)) continue;
                SFileLock sFileLock = lck;
                return sFileLock;
            }
            return null;
        }
        finally {
            iAccessLock.unlock();
        }
    }

    private SFileLock() {
        this.setOwnerThread(Thread.currentThread());
    }

    private static String getLockFileName(String fileName) {
        return String.valueOf(fileName) + LOCKEXT;
    }

    private String getLockFileName() {
        return SFileLock.getLockFileName(this.getFileName());
    }

    private static boolean tryToCreateFile(String fileName, long timeout) {
        File f = new File(fileName);
        int minSleep = (int)(Math.random() * 50.0 + 50.0);
        long i = timeout;
        long m = f.lastModified();
        boolean done = false;
        int excount = 0;
        while (!done) {
            block8: {
                try {
                    done = f.createNewFile();
                    if (done) {
                        f.deleteOnExit();
                        break;
                    }
                }
                catch (IOException e) {
                    i = timeout;
                    if (++excount <= 50000) break block8;
                    return done;
                }
            }
            if (f.lastModified() != m) {
                i = timeout;
                m = f.lastModified();
            }
            if ((i -= (long)minSleep) <= 0L) {
                f.delete();
                i = timeout;
                continue;
            }
            try {
                Thread.sleep(minSleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return done;
    }

    private boolean tryToCreateLockFile(String fileName, boolean exclusive, long pos, long size) throws IOException {
        if (SFileLock.tryToCreateFile(fileName, 15000L)) {
            this.iFileLockInfo.tryToSetFileLock(fileName, false);
            if (this.iFileLockInfo.isLocked()) {
                OutputStreamWriter fw = new OutputStreamWriter(this.iFileLockInfo.iOutputStream);
                PrintWriter pw = new PrintWriter(fw);
                pw.println("// Lock file");
                pw.println("[LockInfo]");
                pw.println("LockTime=" + Calendar.getInstance().getTimeInMillis());
                pw.println("Shared=" + (exclusive ? "false" : "true"));
                pw.println("Position=" + pos);
                pw.println("Size=" + size);
                pw.println("Duration=Short");
                return true;
            }
        }
        return false;
    }

    public boolean sharedLock(long pos, long size) throws IOException {
        boolean rc = true;
        if (!this.isLocked()) {
            try {
                rc = this.tryToCreateLockFile(this.getLockFileName(), false, pos, size);
            }
            catch (IOException e) {
                return false;
            }
        }
        ++this.iLockCount;
        return rc;
    }

    public boolean exclusiveLock(long pos, long size) throws IOException {
        boolean rc = true;
        if (!this.isLocked()) {
            try {
                rc = this.tryToCreateLockFile(this.getLockFileName(), true, pos, size);
            }
            catch (IOException e) {
                return false;
            }
        }
        ++this.iLockCount;
        return rc;
    }

    public void releaseLock() {
        if (this.isLocked()) {
            --this.iLockCount;
            if (this.iLockCount == 0) {
                this.iFileLockInfo.tryToReleaseFileLock();
                new File(this.getLockFileName()).delete();
            }
        }
    }

    public synchronized boolean isThreadAllowed(Thread t) {
        Thread[] threadArray = this.iAllowedThreads;
        int n = this.iAllowedThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread allowedThread = threadArray[n2];
            if (allowedThread == t) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void addAllowedThread(Thread t) {
        if (!this.isThreadAllowed(t)) {
            int i = this.iAllowedThreads.length;
            Thread[] tmp = new Thread[i + 1];
            System.arraycopy(this.iAllowedThreads, 0, tmp, 0, i);
            tmp[i] = t;
            this.iAllowedThreads = tmp;
        }
    }

    public synchronized boolean removeAllowedThread(Thread t) {
        if (!this.isThreadAllowed(t)) {
            return false;
        }
        int index = 0;
        while (index < this.iAllowedThreads.length) {
            if (this.iAllowedThreads[index] == t) break;
            ++index;
        }
        if (index < this.iAllowedThreads.length) {
            if (this.iAllowedThreads.length > 1) {
                Thread[] tmp = new Thread[this.iAllowedThreads.length - 1];
                System.arraycopy(this.iAllowedThreads, 0, tmp, 0, index);
                if (index < tmp.length) {
                    System.arraycopy(this.iAllowedThreads, index + 1, tmp, index, tmp.length);
                }
                this.iAllowedThreads = tmp;
            } else {
                this.iAllowedThreads = new Thread[0];
            }
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.iFileName;
    }

    protected void setFileName(String fileName) {
        this.iFileName = fileName;
    }

    public Thread getOwnerThread() {
        return this.iOwnerThread;
    }

    protected void setOwnerThread(Thread thread) {
        this.iOwnerThread = thread;
    }

    public boolean isOwnerThread() {
        return this.iOwnerThread == Thread.currentThread();
    }

    public int getLockCount() {
        return this.iLockCount;
    }

    public boolean isLocked() {
        return this.iLockCount != 0;
    }

    public int compareTo(Object o) {
        if (o instanceof SFileLock) {
            SFileLock lck = (SFileLock)o;
            return this.getFileName().compareTo(lck.getFileName());
        }
        return -1;
    }

    class _SFileLockInfo {
        public FileLock iFileLock = null;
        public FileChannel iFileChannel = null;
        public FileInputStream iInputStream = null;
        public FileOutputStream iOutputStream = null;

        _SFileLockInfo() {
        }

        private boolean isLocked() {
            return this.iFileLock != null && this.iFileLock.isValid();
        }

        private boolean tryToSetFileLock(String fileName, boolean shared) {
            boolean rc = false;
            try {
                if (shared) {
                    this.iInputStream = new FileInputStream(fileName);
                    this.iFileChannel = this.iInputStream.getChannel();
                } else {
                    this.iOutputStream = new FileOutputStream(fileName);
                    this.iFileChannel = this.iOutputStream.getChannel();
                }
                if (this.iFileChannel != null) {
                    this.iFileLock = this.iFileChannel.tryLock(0L, Long.MAX_VALUE, shared);
                    rc = true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!rc) {
                this.tryToReleaseFileLock();
            }
            return rc;
        }

        private boolean tryToReleaseFileLock() {
            boolean rc = false;
            try {
                try {
                    if (this.iFileLock != null) {
                        this.iFileLock.release();
                        if (this.iFileChannel != null) {
                            this.iFileChannel.close();
                        }
                        if (this.iInputStream != null) {
                            this.iInputStream.close();
                        }
                        if (this.iOutputStream != null) {
                            this.iOutputStream.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    this.iFileLock = null;
                    this.iFileChannel = null;
                    this.iInputStream = null;
                    this.iOutputStream = null;
                }
            }
            finally {
                this.iFileLock = null;
                this.iFileChannel = null;
                this.iInputStream = null;
                this.iOutputStream = null;
            }
            return rc;
        }
    }
}

