/*
 * Decompiled with CFR 0.152.
 */
package prefs;

import awtext.SPair;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.event.EventListenerList;
import prefs.SPreferences;
import prefs.SPreferencesEvent;
import prefs.SPreferencesException;
import prefs.SPreferencesListener;

public abstract class SAbstractPreferences
implements SPreferences {
    static final String ABORTED = "Action Aborted ";
    private String iName = null;
    private String iDefaultSection = null;
    private boolean iUser = true;
    private long iLastModified = new Date().getTime();
    private long iLastDirtyTime = Calendar.getInstance().getTimeInMillis();
    private int iDirtyCount = 0;
    private boolean iDirty;
    private static Lock gLock = new ReentrantLock(true);
    private EventListenerList listenerList = new EventListenerList();
    private static ConcurrentSkipListSet<SAbstractPreferences> iPreferences;
    private static Thread iFlusherThread;
    private static Thread iShutdownThread;
    private static boolean iShutdownInProgress;
    static final String ERRMSG01 = "SAbstractPreferences.class: Unable to flush ini files in thread ";
    static final String ERRMSG02 = "SAbstractPreferences.class: Last Exception:";
    static final int MAX_DIRTY_MILLISECONDS = 50;
    static final int MAX_DIRTY_COUNT = 1000;

    static {
        SAbstractPreferences.initializeThreads();
        iPreferences = new ConcurrentSkipListSet();
    }

    public static void acquireLock() {
        gLock.lock();
    }

    public static void releaseLock() {
        gLock.unlock();
    }

    @Override
    public boolean isDirty() {
        return this.iDirty;
    }

    @Override
    public void setDirty() {
        this.setDirty(true);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.iDirty = dirty;
        if (this.iDirty) {
            SAbstractPreferences.acquireLock();
            try {
                SAbstractPreferences.addToFlush(this);
            }
            finally {
                SAbstractPreferences.releaseLock();
            }
        }
    }

    @Override
    public final String get(String key, String section) throws SPreferencesException {
        String rc = null;
        if (this.notifyListenersBefore(3, key, key)) {
            throw new SPreferencesException("Action Aborted during key request");
        }
        rc = this.doGet(key, section);
        this.notifyListenersAfter(3, key, key);
        return rc;
    }

    protected static final String objectToString(Object obj) {
        String rc;
        if (obj instanceof Integer) {
            rc = obj.toString();
        } else if (obj instanceof Boolean) {
            rc = (Boolean)obj != false ? "TRUE" : "FALSE";
        } else if (obj instanceof Float) {
            rc = obj.toString();
        } else if (obj instanceof Double) {
            rc = obj.toString();
        } else if (obj instanceof SPair) {
            rc = obj.toString();
        } else if (obj instanceof Point) {
            rc = new SPair((Point)obj).toString();
        } else if (obj instanceof Dimension) {
            rc = new SPair((Dimension)obj).toString();
        } else if (obj instanceof Rectangle) {
            Rectangle rec = (Rectangle)obj;
            rc = "SRectangle[" + new SPair(rec.getLocation()).toString() + ";" + new SPair(rec.getSize()).toString() + "]";
        } else {
            rc = obj.toString();
        }
        return rc;
    }

    @Override
    public final void put(String key, Object val, String section) throws SPreferencesException {
        block4: {
            SAbstractPreferences.acquireLock();
            try {
                if (!this.notifyListenersBefore(4, val.toString(), key)) {
                    this.doPut(key, SAbstractPreferences.objectToString(val), section);
                    this.notifyListenersAfter(4, val.toString(), key);
                    break block4;
                }
                throw new SPreferencesException("Action Aborted during value put");
            }
            finally {
                SAbstractPreferences.releaseLock();
            }
        }
    }

    @Override
    public void delKey(String key, String section) throws SPreferencesException {
        block4: {
            SAbstractPreferences.acquireLock();
            try {
                if (!this.notifyListenersBefore(7, key, key)) {
                    this.doDelKey(key, section);
                    this.notifyListenersAfter(7, key, key);
                    break block4;
                }
                throw new SPreferencesException("Action Aborted during delKey(" + key + ")");
            }
            finally {
                SAbstractPreferences.releaseLock();
            }
        }
    }

    @Override
    public void delKey(String key) throws SPreferencesException {
        this.delKey(key, this.getDefaultSection());
    }

    @Override
    public void delSection(String section) throws SPreferencesException {
        block4: {
            SAbstractPreferences.acquireLock();
            try {
                if (!this.notifyListenersBefore(8, section, section)) {
                    this.doDelSection(section);
                    this.notifyListenersAfter(8, section, section);
                    break block4;
                }
                throw new SPreferencesException("Action Aborted during delSection(" + section + ")");
            }
            finally {
                SAbstractPreferences.releaseLock();
            }
        }
    }

    @Override
    public void copySection(String sourceSection, String targetSection) throws SPreferencesException {
        List<String> keyList = this.keyList(sourceSection);
        for (String key : keyList) {
            this.put(key, this.get(key, sourceSection), targetSection);
        }
    }

    @Override
    public List<String> keyList() throws SPreferencesException {
        return this.keyList(this.getDefaultSection());
    }

    @Override
    public List<String> keyList(String section) throws SPreferencesException {
        List<String> lst = null;
        if (this.notifyListenersBefore(6, section, section)) {
            throw new SPreferencesException("Action Aborted during value key list request");
        }
        lst = this.doKeyList(section);
        this.notifyListenersAfter(6, section, section);
        return lst;
    }

    @Override
    public List<String> sectionList() throws SPreferencesException {
        List<String> lst = null;
        if (this.notifyListenersBefore(5, "", "")) {
            throw new SPreferencesException("Action Aborted during value key list request");
        }
        lst = this.doSectionList();
        this.notifyListenersAfter(5, "", "");
        return lst;
    }

    @Override
    public final String get(String key) throws SPreferencesException {
        return this.get(key, this.getDefaultSection());
    }

    @Override
    public final void put(String key, Object val) throws SPreferencesException {
        this.put(key, val, this.getDefaultSection());
    }

    @Override
    public final String tryGet(String key, String defval) {
        return this.tryGet(key, defval, this.getDefaultSection());
    }

    @Override
    public final String tryGet(String key, String defval, String section) {
        try {
            return this.get(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public final boolean tryPut(String key, Object val) {
        return this.tryPut(key, val, this.getDefaultSection());
    }

    @Override
    public final boolean tryPut(String key, Object val, String section) {
        try {
            this.put(key, val, section);
            return true;
        }
        catch (SPreferencesException sPreferencesException) {
            return false;
        }
    }

    @Override
    public boolean tryDelKey(String key, String section) {
        try {
            this.delKey(key, section);
            return true;
        }
        catch (SPreferencesException sPreferencesException) {
            return false;
        }
    }

    @Override
    public boolean tryDelKey(String key) {
        return this.tryDelKey(key, this.getDefaultSection());
    }

    @Override
    public boolean tryDelSection(String section) {
        try {
            this.delSection(section);
            return true;
        }
        catch (SPreferencesException sPreferencesException) {
            return false;
        }
    }

    @Override
    public boolean containsKey(String key, String section) throws SPreferencesException {
        List<String> lst = this.keyList(section);
        Iterator<String> i = lst.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(String key) throws SPreferencesException {
        return this.containsKey(key, this.getDefaultSection());
    }

    @Override
    public boolean containsSection() throws SPreferencesException {
        return this.containsSection(this.getDefaultSection());
    }

    @Override
    public boolean containsSection(String section) throws SPreferencesException {
        List<String> lst = this.sectionList();
        Iterator<String> i = lst.iterator();
        while (i.hasNext()) {
            if (!i.next().equals(section)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getName() {
        return this.iName;
    }

    @Override
    public final void setName(String name) throws SPreferencesException {
        block6: {
            SAbstractPreferences.acquireLock();
            try {
                try {
                    this.flush();
                }
                catch (SPreferencesException sPreferencesException) {
                    // empty catch block
                }
                if (!this.notifyListenersBefore(1, this.iName, name)) {
                    String oName = this.iName;
                    this.iName = name;
                    this.notifyListenersAfter(1, oName, name);
                    break block6;
                }
                throw new SPreferencesException("Action Aborted during name change");
            }
            finally {
                SAbstractPreferences.releaseLock();
            }
        }
    }

    public boolean isUser() {
        return this.iUser;
    }

    public void setUser(boolean user) {
        this.iUser = user;
    }

    @Override
    public final String getDefaultSection() {
        if (this.iDefaultSection == null || this.iDefaultSection.equals("")) {
            try {
                this.setDefaultSection("Default");
            }
            catch (SPreferencesException sPreferencesException) {
                // empty catch block
            }
        }
        return this.iDefaultSection;
    }

    @Override
    public final void setDefaultSection(String defaultSection) throws SPreferencesException {
        block4: {
            SAbstractPreferences.acquireLock();
            try {
                if (!this.notifyListenersBefore(2, this.iDefaultSection, defaultSection)) {
                    String oSection = this.iDefaultSection;
                    this.iDefaultSection = defaultSection;
                    this.notifyListenersAfter(2, oSection, defaultSection);
                    break block4;
                }
                throw new SPreferencesException("Action Aborted during section change");
            }
            finally {
                SAbstractPreferences.releaseLock();
            }
        }
    }

    public long getLastModified() {
        return this.iLastModified;
    }

    public void setLastModified(long lastModified) {
        this.iLastModified = lastModified;
    }

    public void addListener(SPreferencesListener l) {
        this.listenerList.add(SPreferencesListener.class, l);
    }

    public void removeListener(SPreferencesListener l) {
        this.listenerList.remove(SPreferencesListener.class, l);
    }

    private final boolean notifyListeners(int eventType, int action, String oldV, String newV) throws SPreferencesException {
        boolean rc = false;
        SPreferencesEvent evt = new SPreferencesEvent(this, eventType, action, oldV, newV);
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == SPreferencesListener.class) {
                ((SPreferencesListener)listeners[i + 1]).dispatchEvent(evt);
                rc = evt.isAbort();
                if (rc) break;
            }
            i -= 2;
        }
        return rc;
    }

    private final boolean notifyListenersBefore(int eventType, String oldV, String newV) throws SPreferencesException {
        return this.notifyListeners(eventType, 1, oldV, newV);
    }

    private final boolean notifyListenersAfter(int eventType, String oldV, String newV) throws SPreferencesException {
        return this.notifyListeners(eventType, 2, oldV, newV);
    }

    public static Thread getFlusherThread() {
        return iFlusherThread;
    }

    public static Thread getShutdownThread() {
        return iShutdownThread;
    }

    protected static void initializeThreads() {
        iShutdownInProgress = false;
        Thread t = new Thread("SPreferences.shutdownHook"){

            @Override
            public void run() {
                SAbstractPreferences.shutdownHook();
            }
        };
        Runtime.getRuntime().addShutdownHook(t);
        iShutdownThread = t;
        t = new Thread("SPreferences.flusherDaemon"){

            @Override
            public void run() {
                SAbstractPreferences.flushHook();
            }
        };
        t.setDaemon(true);
        t.start();
        iFlusherThread = t;
    }

    private static final void shutdownHook() {
        if (iFlusherThread != null && iFlusherThread.isAlive()) {
            try {
                iShutdownInProgress = true;
                iFlusherThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        iShutdownInProgress = true;
        int sz = iPreferences.size();
        while (sz > 0) {
            SAbstractPreferences p = iPreferences.pollFirst();
            SAbstractPreferences.checkFlush(p);
            --sz;
            sz = iPreferences.size();
        }
    }

    private static final void flushHook() {
        while (!iShutdownInProgress) {
            if (!iShutdownInProgress && !iPreferences.isEmpty()) {
                SAbstractPreferences.checkFlush(iPreferences.first());
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void addToFlush(SAbstractPreferences p) {
        if (iShutdownInProgress) {
            try {
                p.flush();
            }
            catch (SPreferencesException e) {
                System.err.println(ERRMSG01 + Thread.currentThread().getName());
                System.err.println(p.toString());
                System.err.println(ERRMSG02);
                e.printStackTrace();
            }
        } else {
            p.iLastDirtyTime = Calendar.getInstance().getTimeInMillis();
            ++p.iDirtyCount;
            iPreferences.add(p);
        }
    }

    private static void checkFlush(SAbstractPreferences p) {
        long n = Calendar.getInstance().getTimeInMillis();
        if (n - p.iLastDirtyTime > 50L || p.iDirtyCount > 1000 || iShutdownInProgress) {
            try {
                iPreferences.remove(p);
                p.flush();
                if (p.isDirty()) {
                    SAbstractPreferences.addToFlush(p);
                } else {
                    p.iDirtyCount = 0;
                }
            }
            catch (SPreferencesException e) {
                System.err.println(ERRMSG01 + Thread.currentThread().getName());
                System.err.println(p.toString());
                System.err.println(ERRMSG02);
                e.printStackTrace();
            }
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean getBoolean(String key, String section) throws SPreferencesException {
        String val = this.get(key, section);
        return val != null && ((val = val.toUpperCase()).equals("TRUE") || val.equals("YES") || val.equals("Y") || val.equals("1"));
    }

    @Override
    public boolean getBoolean(String key) throws SPreferencesException {
        return this.getBoolean(key, this.getDefaultSection());
    }

    @Override
    public Dimension getDimension(String key, String section) throws SPreferencesException {
        return this.getPair(key, section).asDimension();
    }

    @Override
    public Dimension getDimension(String key) throws SPreferencesException {
        return this.getDimension(key, this.getDefaultSection());
    }

    @Override
    public double getDouble(String key, String section) throws SPreferencesException {
        String val = this.get(key, section);
        if (val != null) {
            return Double.parseDouble(val);
        }
        return 0.0;
    }

    @Override
    public double getDouble(String key) throws SPreferencesException {
        return this.getDouble(key, this.getDefaultSection());
    }

    @Override
    public float getFloat(String key, String section) throws SPreferencesException {
        String val = this.get(key, section);
        if (val != null) {
            return Float.parseFloat(val);
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String key) throws SPreferencesException {
        return this.getFloat(key, this.getDefaultSection());
    }

    @Override
    public int getInt(String key, String section) throws SPreferencesException {
        String val = this.get(key, section);
        if (val != null) {
            return Integer.parseInt(val);
        }
        return 0;
    }

    @Override
    public int getInt(String key) throws SPreferencesException {
        return this.getInt(key, this.getDefaultSection());
    }

    @Override
    public SPair getPair(String key, String section) throws SPreferencesException {
        String val = this.get(key, section);
        if (val != null) {
            return SPair.parsePair(val);
        }
        return null;
    }

    @Override
    public SPair getPair(String key) throws SPreferencesException {
        return this.getPair(key, this.getDefaultSection());
    }

    @Override
    public Point getPoint(String key, String section) throws SPreferencesException {
        return this.getPair(key, section).asPoint();
    }

    @Override
    public Point getPoint(String key) throws SPreferencesException {
        return this.getPoint(key, this.getDefaultSection());
    }

    @Override
    public Rectangle getRectangle(String key, String section) throws SPreferencesException {
        String val = this.get(key, section);
        if (val == null || val.indexOf("SRectangle[") < 0 || val.indexOf("SPair[") < 0 || val.lastIndexOf("SPair[") == val.indexOf("SPair[")) {
            throw new SPreferencesException("Malformed rectangle string");
        }
        String s1 = val.substring(val.indexOf("SPair["), val.indexOf(";SPair["));
        String s2 = val.substring(val.indexOf(";SPair[") + 1);
        if (s2.indexOf("]]") >= 0) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return new Rectangle(SPair.parsePair(s1).asPoint(), SPair.parsePair(s2).asDimension());
    }

    @Override
    public Rectangle getRectangle(String key) throws SPreferencesException {
        return this.getRectangle(key, this.getDefaultSection());
    }

    @Override
    public boolean tryGetBoolean(String key, boolean defval, String section) {
        try {
            return this.getBoolean(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public boolean tryGetBoolean(String key, boolean defval) {
        return this.tryGetBoolean(key, defval, this.getDefaultSection());
    }

    @Override
    public Dimension tryGetDimension(String key, Dimension defval, String section) {
        try {
            return this.getDimension(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public Dimension tryGetDimension(String key, Dimension defval) {
        return this.tryGetDimension(key, defval, this.getDefaultSection());
    }

    @Override
    public double tryGetDouble(String key, double defval, String section) {
        try {
            return this.getDouble(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public double tryGetDouble(String key, double defval) {
        return this.tryGetDouble(key, defval, this.getDefaultSection());
    }

    @Override
    public float tryGetFloat(String key, float defval, String section) {
        try {
            return this.getFloat(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public float tryGetFloat(String key, float defval) {
        return this.tryGetFloat(key, defval, this.getDefaultSection());
    }

    @Override
    public int tryGetInt(String key, int defval, String section) {
        try {
            return this.getInt(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public int tryGetInt(String key, int defval) {
        return this.tryGetInt(key, defval, this.getDefaultSection());
    }

    @Override
    public SPair tryGetPair(String key, SPair defval, String section) {
        try {
            return this.getPair(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public SPair tryGetPair(String key, SPair defval) {
        return this.tryGetPair(key, defval, this.getDefaultSection());
    }

    @Override
    public Point tryGetPoint(String key, Point defval, String section) {
        try {
            return this.getPoint(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public Point tryGetPoint(String key, Point defval) {
        return this.tryGetPoint(key, defval, this.getDefaultSection());
    }

    @Override
    public Rectangle tryGetRectangle(String key, Rectangle defval, String section) {
        try {
            return this.getRectangle(key, section);
        }
        catch (SPreferencesException sPreferencesException) {
            return defval;
        }
    }

    @Override
    public Rectangle tryGetRectangle(String key, Rectangle defval) {
        return this.tryGetRectangle(key, defval, this.getDefaultSection());
    }
}

