/*
 * Decompiled with CFR 0.152.
 */
package prefs;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import prefs.SAbstractPreferences;
import prefs.SPreferencesEvent;
import prefs.SPreferencesException;
import prefs.SPreferencesListener;

public abstract class SAbstractTreeMapPreferences
extends SAbstractPreferences
implements SPreferencesListener,
Comparable<SPreferencesListener> {
    protected AbstractMap<String, AbstractMap<String, String>> iContent = null;

    @Override
    public List<String> doKeyList(String section) {
        ArrayList<String> lst = new ArrayList<String>();
        AbstractMap<String, String> keys = this.getSectionHashTable(section, false);
        if (keys != null) {
            lst.addAll(keys.keySet());
        }
        return lst;
    }

    @Override
    public List<String> doSectionList() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.iContent != null) {
            lst.addAll(this.iContent.keySet());
        }
        return lst;
    }

    protected final AbstractMap<String, String> getSectionHashTable(String section, boolean bCreateIfNotExists, boolean setDirtyIfNew) {
        AbstractMap<String, String> sec;
        if (this.iContent == null) {
            this.iContent = new ConcurrentSkipListMap<String, AbstractMap<String, String>>();
        }
        if ((sec = this.iContent.get(section)) == null && bCreateIfNotExists) {
            sec = new ConcurrentSkipListMap<String, String>();
            this.iContent.put(section, sec);
            if (setDirtyIfNew) {
                this.setDirty(true);
            }
        }
        return sec;
    }

    protected final AbstractMap<String, String> getSectionHashTable(String section, boolean setDirtyIfNew) {
        return this.getSectionHashTable(section, true, setDirtyIfNew);
    }

    protected void internalPut(String key, String val, String section, boolean setDirtyIfNew) throws SPreferencesException {
        AbstractMap<String, String> sec = this.getSectionHashTable(section, setDirtyIfNew);
        if (sec == null) {
            throw new SPreferencesException("Unable to set section");
        }
        sec.put(key, val);
    }

    void nameAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyAboutToDelete(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionAboutToDelete(SPreferencesEvent evt) throws SPreferencesException {
    }

    void nameChanged(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionChanged(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyRequested(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyChanged(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyDeleted(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionDeleted(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyListAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyListRequested(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionListAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionListRequested(SPreferencesEvent evt) throws SPreferencesException {
    }

    @Override
    public void dispatchEvent(SPreferencesEvent evt) throws SPreferencesException {
        if (evt.getMode() == 1) {
            switch (evt.getAction()) {
                case 1: {
                    this.nameAboutToChange(evt);
                    break;
                }
                case 2: {
                    this.sectionAboutToChange(evt);
                    break;
                }
                case 3: {
                    this.keyAboutToRequest(evt);
                    break;
                }
                case 4: {
                    this.keyAboutToChange(evt);
                    break;
                }
                case 7: {
                    this.keyAboutToDelete(evt);
                    break;
                }
                case 8: {
                    this.sectionAboutToDelete(evt);
                    break;
                }
                case 6: {
                    this.keyListAboutToRequest(evt);
                    break;
                }
                case 5: {
                    this.sectionListAboutToRequest(evt);
                }
            }
        } else if (evt.getMode() == 2) {
            switch (evt.getAction()) {
                case 1: {
                    this.nameChanged(evt);
                    break;
                }
                case 2: {
                    this.sectionChanged(evt);
                    break;
                }
                case 3: {
                    this.keyRequested(evt);
                    break;
                }
                case 4: {
                    this.keyChanged(evt);
                    break;
                }
                case 7: {
                    this.keyDeleted(evt);
                    break;
                }
                case 8: {
                    this.sectionDeleted(evt);
                    break;
                }
                case 6: {
                    this.keyListRequested(evt);
                    break;
                }
                case 5: {
                    this.sectionListRequested(evt);
                }
            }
        }
    }

    abstract void doFlush() throws SPreferencesException;

    @Override
    public void flush() throws SPreferencesException {
        if (this.isDirty()) {
            try {
                SAbstractTreeMapPreferences.acquireLock();
                this.doFlush();
            }
            finally {
                SAbstractTreeMapPreferences.releaseLock();
            }
        }
    }

    @Override
    public int compareTo(SPreferencesListener o) {
        return this == o ? 0 : 1;
    }
}

