/*
 * Decompiled with CFR 0.152.
 */
package prefs;

import application.SApplication;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import prefs.SAbstractPreferences;
import prefs.SPreferences;
import prefs.SPreferencesEvent;
import prefs.SPreferencesException;
import prefs.SPreferencesListener;
import sql.SConnection;
import sql.SSQLTable;
import sql.SStatement;

public class SDBBasedPreferences
extends SAbstractPreferences
implements SPreferencesListener,
Comparable<SPreferencesListener> {
    private SConnection iConnection = null;
    private String iTableName = "PREFERENCES";
    private String iNodeName = "";
    private static final String DEFAULTTABLENAME = "PREFERENCES";
    private static final String TABLEVERSION = "V1.0.0";

    private final String getWhere(String key, String section) {
        String nodeName = this.getNodeName();
        String rc = " WHERE Node='" + nodeName + "'";
        if (section != null && section.length() > 0) {
            rc = String.valueOf(rc) + " AND Section='" + section + "' ";
        }
        if (key != null && key.length() > 0) {
            rc = String.valueOf(rc) + " AND Entry='" + key + "' ";
        }
        return rc;
    }

    public static SPreferences tryToGetPreferences(String name) {
        return SDBBasedPreferences.tryToGetPreferences(name, true);
    }

    public static SPreferences tryToGetPreferences(String name, boolean userpref) {
        return SDBBasedPreferences.tryToGetPreferences(null, name, userpref);
    }

    public static SPreferences tryToGetPreferences(SConnection con) {
        return SDBBasedPreferences.tryToGetPreferences(con, true);
    }

    public static SPreferences tryToGetPreferences(SConnection con, boolean userpref) {
        return SDBBasedPreferences.tryToGetPreferences(con, DEFAULTTABLENAME, userpref);
    }

    public static SPreferences tryToGetPreferences(SConnection con, String name, boolean userpref) {
        if (con == null && SApplication.getDefaultConnection() == null) {
            return null;
        }
        SDBBasedPreferences p = new SDBBasedPreferences();
        try {
            p.addListener(p);
            if (con == null) {
                p.setConnection(SApplication.getDefaultConnection());
            } else {
                p.setConnection(con);
            }
            p.setUser(userpref);
            p.setName(name);
        }
        catch (SPreferencesException e) {
            p = null;
        }
        return p;
    }

    void nameAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
        this.flush();
        String tableName = evt.getNewValue();
        String[] tableDefinition = new String[]{tableName, TABLEVERSION, "Node", "CHAR", "250", "0", "FALSE", "", "", "", "Section", "CHAR", "250", "0", "FALSE", "", "", "", "Entry", "CHAR", "250", "0", "FALSE", "", "", "", "Value", "CHAR", "250", "0", "TRUE", "", "", ""};
        String[] indexDefinition = new String[]{"XAK_PREFERENCES", "UNIQUE", "Section ASC,Entry ASC"};
        String[] sql = null;
        String c = "";
        try {
            c = SSQLTable.readCommentFromConnection(tableName, this.getConnection());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (!c.startsWith(TABLEVERSION)) {
            try {
                SSQLTable t = new SSQLTable(tableDefinition, indexDefinition);
                String[] stringArray = sql = t.getSqlCreate();
                int n = sql.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    this.getConnection().executeSqlNoEx(element);
                    ++n2;
                }
                this.iTableName = tableName;
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new SPreferencesException(e);
            }
        } else {
            this.iTableName = tableName;
        }
    }

    void sectionAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyAboutToDelete(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionAboutToDelete(SPreferencesEvent evt) throws SPreferencesException {
    }

    void nameChanged(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionChanged(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyRequested(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyChanged(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyDeleted(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionDeleted(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyListAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
    }

    void keyListRequested(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionListAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
    }

    void sectionListRequested(SPreferencesEvent evt) throws SPreferencesException {
    }

    @Override
    public void dispatchEvent(SPreferencesEvent evt) throws SPreferencesException {
        if (evt.getMode() == 1) {
            switch (evt.getAction()) {
                case 1: {
                    this.nameAboutToChange(evt);
                    break;
                }
                case 2: {
                    this.sectionAboutToChange(evt);
                    break;
                }
                case 3: {
                    this.keyAboutToRequest(evt);
                    break;
                }
                case 4: {
                    this.keyAboutToChange(evt);
                    break;
                }
                case 7: {
                    this.keyAboutToDelete(evt);
                    break;
                }
                case 8: {
                    this.sectionAboutToDelete(evt);
                    break;
                }
                case 6: {
                    this.keyListAboutToRequest(evt);
                    break;
                }
                case 5: {
                    this.sectionListAboutToRequest(evt);
                }
            }
        } else if (evt.getMode() == 2) {
            switch (evt.getAction()) {
                case 1: {
                    this.nameChanged(evt);
                    break;
                }
                case 2: {
                    this.sectionChanged(evt);
                    break;
                }
                case 3: {
                    this.keyRequested(evt);
                    break;
                }
                case 4: {
                    this.keyChanged(evt);
                    break;
                }
                case 7: {
                    this.keyDeleted(evt);
                    break;
                }
                case 8: {
                    this.sectionDeleted(evt);
                    break;
                }
                case 6: {
                    this.keyListRequested(evt);
                    break;
                }
                case 5: {
                    this.sectionListRequested(evt);
                }
            }
        }
    }

    private void doDel(String sql) throws SPreferencesException {
        SStatement stmt = null;
        try {
            try {
                stmt = this.getConnection().getStatement();
                stmt.execute(sql);
            }
            catch (SQLException e) {
                throw new SPreferencesException(e);
            }
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
        }
    }

    @Override
    public void doDelKey(String key, String section) throws SPreferencesException {
        String sql = "DELETE FROM " + this.iTableName + this.getWhere(key, section);
        this.doDel(sql);
    }

    @Override
    public void doDelSection(String section) throws SPreferencesException {
        String sql = "DELETE FROM " + this.iTableName + this.getWhere(null, section);
        this.doDel(sql);
    }

    @Override
    public String doGet(String key, String section) throws SPreferencesException {
        String rc = null;
        String sql = "SELECT Value FROM " + this.iTableName + this.getWhere(key, section);
        SStatement stmt = null;
        try {
            try {
                stmt = this.getConnection().getStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    rc = rs.getString(1);
                }
            }
            catch (SQLException e) {
                throw new SPreferencesException(e);
            }
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
            if (rc == null) {
                throw new SPreferencesException("Key does not exist");
            }
        }
        return rc;
    }

    @Override
    public List<String> doKeyList(String section) {
        String sql = "SELECT Entry FROM " + this.iTableName + this.getWhere(null, section);
        ArrayList<String> lst = new ArrayList<String>();
        SStatement stmt = null;
        try {
            try {
                stmt = this.getConnection().getStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    lst.add(rs.getString(1));
                }
            }
            catch (SQLException sQLException) {
                if (stmt != null) {
                    this.getConnection().releaseStatement(stmt);
                }
            }
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
        }
        return lst;
    }

    @Override
    public void doPut(String key, String value, String section) throws SPreferencesException {
        String sql = "INSERT INTO " + this.iTableName + " VALUES ('" + this.getNodeName() + "','" + section + "','" + key + "','" + value + "')";
        SStatement stmt = null;
        try {
            try {
                stmt = this.getConnection().getStatement();
                stmt.execute(sql);
            }
            catch (SQLException e) {
                try {
                    sql = "UPDATE " + this.iTableName + " SET Value='" + value + "'" + this.getWhere(key, section);
                    stmt.execute(sql);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (stmt != null) {
                    this.getConnection().releaseStatement(stmt);
                }
            }
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
        }
    }

    @Override
    public List<String> doSectionList() {
        String sql = "SELECT DISTINCT Section FROM " + this.iTableName + this.getWhere(null, null);
        ArrayList<String> lst = new ArrayList<String>();
        SStatement stmt = null;
        try {
            try {
                stmt = this.getConnection().getStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    lst.add(rs.getString(1));
                }
            }
            catch (SQLException sQLException) {
                if (stmt != null) {
                    this.getConnection().releaseStatement(stmt);
                }
            }
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
        }
        return lst;
    }

    @Override
    public void flush() throws SPreferencesException {
    }

    public SConnection getConnection() {
        return this.iConnection;
    }

    public void setConnection(SConnection connection) {
        this.iConnection = connection;
    }

    public String getNodeName() {
        return this.iNodeName;
    }

    public void setNodeName(String nodeName) {
        this.iNodeName = nodeName;
    }

    @Override
    public void setUser(boolean user) {
        super.setUser(user);
        String nodeName = "";
        if (user) {
            String un = System.getenv("USERNAME");
            if (un != null) {
                nodeName = String.valueOf(nodeName) + un;
            } else if (this.getConnection() != null) {
                nodeName = this.getConnection().getUsername();
            }
        } else {
            String domain = System.getenv("USERDOMAIN");
            String dnsdomain = System.getenv("USERDNSDOMAIN");
            String cn = System.getenv("COMPUTERNAME");
            if (cn != null) {
                nodeName = cn;
            }
            if (dnsdomain != null) {
                nodeName = String.valueOf(nodeName) + "." + dnsdomain;
            } else if (domain != null) {
                nodeName = String.valueOf(nodeName) + "." + domain;
            }
        }
        this.setNodeName(nodeName);
    }

    @Override
    public int compareTo(SPreferencesListener o) {
        return this == o ? 0 : 1;
    }
}

