/*
 * Decompiled with CFR 0.152.
 */
package prefs;

import io.SFile;
import io.SFileLock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Iterator;
import prefs.SAbstractTreeMapPreferences;
import prefs.SPreferences;
import prefs.SPreferencesEvent;
import prefs.SPreferencesException;

public class SFileBasedPreferences
extends SAbstractTreeMapPreferences {
    static final String TMPEXTENSION = ".$ini$";
    static final String DEFAULT_PREFERENCES_FILENAME = "StF Applications.ini";
    private String iFileName = null;
    private SFile iFile = null;
    static final String IFBSTRING = "SFileBasedPreferences.location=";
    static final String FLATMARKER = "SFileBasedPreferences.class.useFlatStructure=true";
    private String iLocationSpecified = "";
    boolean iUseFlatStructure;
    private static String gFSep = System.getProperty("file.separator");

    protected void setLockAndRefill() throws SPreferencesException {
        if (!this.isDirty()) {
            this.setDirty();
            this.iFile.exclusiveLock();
            SFileLock lck = this.iFile.getLock();
            lck.addAllowedThread(SFileBasedPreferences.getFlusherThread());
            lck.addAllowedThread(SFileBasedPreferences.getShutdownThread());
            this.setDirty();
            while (this.isFileChanged(this.iFileName)) {
                this.checkRefill();
            }
        }
    }

    @Override
    void keyAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
        this.setLockAndRefill();
        super.keyAboutToChange(evt);
    }

    @Override
    void keyAboutToDelete(SPreferencesEvent evt) throws SPreferencesException {
        this.setLockAndRefill();
        super.keyAboutToChange(evt);
    }

    private final boolean isFileChanged(String fileName) {
        File f;
        block4: {
            f = new File(fileName);
            if (f.exists()) break block4;
            return false;
        }
        try {
            if (f.lastModified() != this.getLastModified()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private final void fillFromBufferedReader(BufferedReader br, String fileName) throws SPreferencesException {
        this.iUseFlatStructure = false;
        try {
            String il;
            int lc = 0;
            String app = "";
            while ((il = br.readLine()) != null) {
                String val;
                String key;
                if (il.indexOf(IFBSTRING) == 0) {
                    String nn = il.substring(IFBSTRING.length());
                    if (nn.length() > 0 && !nn.equals(fileName)) {
                        br.close();
                        this.setName(nn);
                        return;
                    }
                    this.iLocationSpecified = nn;
                    il = br.readLine();
                    if (il == null) break;
                }
                ++lc;
                if (il.length() == 0 || il.indexOf("//") == 0) continue;
                if (lc < 5 && !this.iUseFlatStructure && il.compareTo(FLATMARKER) == 0) {
                    this.iUseFlatStructure = true;
                    continue;
                }
                if (this.iUseFlatStructure) {
                    if (il.indexOf("=") <= 0) continue;
                    int i = il.indexOf(".");
                    while (i > 0 && i == il.indexOf("..", i)) {
                        i = il.indexOf(".", i + 2);
                    }
                    if (i <= 0) continue;
                    app = il.substring(0, i).replace("..", ".");
                    key = il.substring(i + 1);
                    if (key.indexOf("=") <= 0) continue;
                    val = key.substring(key.indexOf("=") + 1);
                    key = key.substring(0, key.indexOf("=")).replace("..", ".");
                    if (app.length() <= 0) continue;
                    this.internalPut(key, val, app, false);
                    continue;
                }
                if (il.indexOf("[") == 0) {
                    app = il.substring(1, il.length() - 1);
                    if (app.length() <= 0) continue;
                    this.getSectionHashTable(app, false);
                    continue;
                }
                if (il.indexOf("=") <= 0 || il.indexOf("=") == -1) continue;
                val = il.substring(il.indexOf("=") + 1);
                key = il.substring(0, il.indexOf("="));
                if (app.length() <= 0) continue;
                this.internalPut(key, val, app, false);
            }
            this.setDirty(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void fillFromFile(String fileName) throws SPreferencesException {
        this.iFile.sharedLock();
        try {
            try {
                if (this.iContent != null) {
                    this.iContent.clear();
                }
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                this.fillFromBufferedReader(br, fileName);
                br.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.iFile.releaseLock();
                this.setLastModified(new File(fileName).lastModified());
            }
            catch (IOException iOException) {
                this.iFile.releaseLock();
                this.setLastModified(new File(fileName).lastModified());
            }
        }
        finally {
            this.iFile.releaseLock();
            this.setLastModified(new File(fileName).lastModified());
        }
    }

    private final void checkRefill() throws SPreferencesException {
        if (this.isFileChanged(this.iFileName)) {
            this.fillFromFile(this.iFileName);
        }
    }

    @Override
    protected final void keyAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
        this.checkRefill();
    }

    @Override
    protected final void nameAboutToChange(SPreferencesEvent evt) throws SPreferencesException {
        this.flush();
    }

    @Override
    protected final void keyListAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
        this.checkRefill();
    }

    @Override
    protected final void sectionListAboutToRequest(SPreferencesEvent evt) throws SPreferencesException {
        this.checkRefill();
    }

    @Override
    protected final void nameChanged(SPreferencesEvent evt) throws SPreferencesException {
        if (this.iContent != null) {
            this.iContent.clear();
            this.iContent = null;
        }
    }

    protected final void writeSection(String section, AbstractMap<String, String> map, PrintWriter pw) {
        if (map != null) {
            Iterator<String> ki = map.keySet().iterator();
            String outSec = this.iUseFlatStructure ? section.replace(".", "..") : "[" + section + "]";
            if (ki.hasNext()) {
                if (!this.iUseFlatStructure) {
                    pw.println(outSec);
                }
                while (ki.hasNext()) {
                    String key = ki.next();
                    String val = map.get(key);
                    if (!this.iUseFlatStructure) {
                        pw.println(String.valueOf(key) + "=" + val);
                        continue;
                    }
                    pw.println(String.valueOf(outSec) + "." + key.replace(".", "..") + "=" + val);
                }
                if (!this.iUseFlatStructure) {
                    pw.println();
                }
            }
        }
    }

    protected final void flushToFile(String fileName) throws SPreferencesException {
        if (this.isFileChanged(fileName)) {
            throw new SPreferencesException("Out of sync in thread \"" + Thread.currentThread().getName() + "\":" + fileName);
        }
        try {
            try {
                this.iFile.exclusiveLock();
                SFileLock lck = this.iFile.getLock();
                if (lck.isOwnerThread()) {
                    lck.addAllowedThread(SFileBasedPreferences.getFlusherThread());
                    lck.addAllowedThread(SFileBasedPreferences.getShutdownThread());
                }
                Date d = new Date();
                d.setTime(this.getLastModified());
                FileWriter fiw = new FileWriter(String.valueOf(fileName) + TMPEXTENSION);
                PrintWriter fw = new PrintWriter(fiw);
                fw.println("// File:" + fileName);
                fw.println("// Written by SFileBasedPreferences.class");
                fw.println("// " + d.toString());
                if (this.iLocationSpecified != null && this.iLocationSpecified.length() > 0) {
                    fw.println(IFBSTRING + this.iLocationSpecified);
                }
                if (this.iUseFlatStructure) {
                    fw.println(FLATMARKER);
                }
                fw.println();
                for (String section : this.sectionList()) {
                    this.writeSection(section, this.getSectionHashTable(section, false), fw);
                }
                fiw.close();
                fw.close();
                FileChannel ich = new FileInputStream(String.valueOf(fileName) + TMPEXTENSION).getChannel();
                FileChannel och = new FileOutputStream(fileName).getChannel();
                och.position(0L);
                och.transferFrom(ich, 0L, ich.size());
                och.truncate(ich.size());
                ich.close();
                och.close();
                new File(String.valueOf(fileName) + TMPEXTENSION).delete();
                this.iFile.releaseLock();
                this.setLastModified(new File(fileName).lastModified());
                this.setDirty(false);
            }
            catch (IOException e) {
                if (this.iFile != null) {
                    this.iFile.releaseLock();
                }
                this.iFile.releaseLock();
            }
            catch (Exception e) {
                if (this.iFile != null) {
                    this.iFile.releaseLock();
                }
                this.iFile.releaseLock();
            }
        }
        finally {
            this.iFile.releaseLock();
        }
    }

    public String getFileName() {
        return this.iFileName;
    }

    public void setFileName(String fileName) {
        if (this.iFile != null) {
            this.iFile.releaseLock();
        }
        this.iFileName = fileName;
        this.iFile = new SFile(fileName);
    }

    @Override
    void doFlush() throws SPreferencesException {
        this.flushToFile(this.getFileName());
    }

    @Override
    public final String doGet(String key, String section) throws SPreferencesException {
        String rc = null;
        AbstractMap<String, String> sec = this.getSectionHashTable(section, false);
        if (sec != null) {
            rc = sec.get(key);
        }
        if (rc == null) {
            throw new SPreferencesException("Key not found:" + key);
        }
        return rc;
    }

    @Override
    public final void doPut(String key, String value, String section) throws SPreferencesException {
        AbstractMap<String, String> sec = this.getSectionHashTable(section, true);
        if (sec == null) {
            throw new SPreferencesException("Unable to set value for key " + key);
        }
        sec.put(key, value);
        this.setDirty(true);
    }

    @Override
    public void doDelKey(String key, String section) throws SPreferencesException {
        AbstractMap<String, String> sec = this.getSectionHashTable(section, false);
        if (sec != null) {
            if (sec.remove(key) != null) {
                this.setDirty(true);
            }
        } else {
            throw new SPreferencesException("Unable to delete key " + key);
        }
    }

    @Override
    public void doDelSection(String section) throws SPreferencesException {
        AbstractMap<String, String> sec = this.getSectionHashTable(section, false);
        if (sec != null) {
            if (this.iContent.remove(section) != null) {
                this.setDirty(true);
            }
        } else {
            throw new SPreferencesException("Unable to delete section " + section);
        }
    }

    private static final boolean checkDirectory(String dirName) {
        boolean rc = false;
        File f = new File(dirName);
        f.mkdirs();
        if (f.canWrite()) {
            rc = true;
        }
        return rc;
    }

    private static final String getPreferredName(String name, boolean user) {
        if (SFile.hasPath(name)) {
            return name;
        }
        String loc = "";
        try {
            if (user) {
                loc = System.getenv("APPDATA");
                if (loc == null || loc.length() == 0) {
                    loc = System.getProperty("user.home");
                }
            } else {
                loc = System.getenv("ALLUSERSPROFILE");
                if (loc == null || loc.length() == 0) {
                    loc = String.valueOf(System.getenv("HOMEDRIVE")) + System.getenv("HOMEPATH");
                }
            }
            if (loc != null && loc.length() > 0) {
                if (loc.lastIndexOf(gFSep) != loc.length() - 1) {
                    loc = String.valueOf(loc) + gFSep;
                }
                loc = String.valueOf(loc) + "StF";
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!SFileBasedPreferences.checkDirectory(loc)) {
            return null;
        }
        loc = loc.length() > 0 ? String.valueOf(loc) + gFSep + name : name;
        return loc;
    }

    public static SPreferences tryToGetPreferences(String name, boolean userpref) {
        if (name == null || name.length() == 0) {
            name = DEFAULT_PREFERENCES_FILENAME;
        }
        String fName = SFileBasedPreferences.getPreferredName(name, userpref);
        SFileBasedPreferences p = null;
        try {
            p = new SFileBasedPreferences();
            p.setUser(userpref);
            p.addListener(p);
            p.setName(name);
            p.setFileName(fName);
        }
        catch (SPreferencesException sPreferencesException) {
            // empty catch block
        }
        return p;
    }

    private SFileBasedPreferences() {
    }
}

