/*
 * Decompiled with CFR 0.152.
 */
package prefs;

import prefs.SDBBasedPreferences;
import prefs.SFileBasedPreferences;
import prefs.SPreferences;
import prefs.SPreferencesException;

public final class SPrefs {
    public static final int TRY_FILE = 1;
    public static final int TRY_WINREG = 2;
    public static final int TRY_DB = 3;
    public static final int USR_PREF = 0;
    public static final int SYS_PREF = 1;
    public static final int BITS = 4;
    public static final int MASK = (int)Math.pow(2.0, 4.0) - 1;
    public static final int TYPE_SHIFT = 0;
    public static final int TRY_FIRST_SHIFT = 4;
    public static final int TRY_SECOND_SHIFT = 8;
    public static final int TRY_THIRD_SHIFT = 12;
    public static final int TRY_FOURTH_SHIFT = 16;
    public static final int TRY_FILE_FIRST = 16;
    public static final int TRY_WINREG_FIRST = 32;
    public static final int TRY_DB_FIRST = 48;
    public static final int TRY_FILE_SECOND = 256;
    public static final int TRY_WINREG_SECOND = 512;
    public static final int TRY_DB_SECOND = 768;
    public static final int TRY_FILE_THIRD = 4096;
    public static final int TRY_WINREG_THIRD = 8192;
    public static final int TRY_DB_THIRD = 12288;
    public static final int TYPE_MASK = MASK << 0;
    public static final int TRY_FIRST_MASK = MASK << 4;
    public static final int TRY_SECOND_MASK = MASK << 8;
    public static final int TRY_THIRD_MASK = MASK << 12;
    public static final int TRY_FOURTH_MASK = MASK << 16;
    public static final int TRY_MASK_ALL = TRY_FIRST_MASK | TRY_SECOND_MASK | TRY_THIRD_MASK | TRY_FOURTH_MASK;
    public static final int TRY_DEFAULT_SYS = 17;
    public static final int TRY_DEFAULT_USR = 16;
    private static SPreferences gDefaultUserPreferences = null;
    private static SPreferences gDefaultSystemPreferences = null;

    private SPrefs() {
    }

    public static final void initSysAndUsrPrefsWithName(String name, int flag) throws SPreferencesException {
        SPreferences p = SPrefs.getPreferencesInstance(name, flag);
        SPrefs.setDefaultSystemPreferences(p);
        SPrefs.setDefaultUserPreferences(p);
    }

    public static final SPreferences tryToCreate(String name, int flag) {
        boolean user = (flag & TYPE_MASK) == 0;
        switch ((flag & TRY_FIRST_MASK) >> 4) {
            case 1: {
                return SFileBasedPreferences.tryToGetPreferences(name, user);
            }
            case 2: {
                return null;
            }
            case 3: {
                return SDBBasedPreferences.tryToGetPreferences(name, user);
            }
        }
        return null;
    }

    public static final SPreferences getPreferencesInstance(String name, int flag) throws SPreferencesException {
        SPreferences p = null;
        int type = flag & TYPE_MASK;
        p = SPrefs.tryToCreate(name, flag & TRY_FIRST_MASK | type);
        if (p == null && (p = SPrefs.tryToCreate(name, flag >> 4 & TRY_FIRST_MASK | type)) == null) {
            p = SPrefs.tryToCreate(name, flag >> 8 & TRY_FIRST_MASK | type);
        }
        if (p == null) {
            throw new SPreferencesException("Unable to create a preferences instance");
        }
        return p;
    }

    public static SPreferences getDefaultUserPreferences() {
        if (gDefaultUserPreferences == null) {
            gDefaultUserPreferences = SPrefs.tryToCreate("StF Applications.ini", 528);
        }
        return gDefaultUserPreferences;
    }

    public static void setDefaultUserPreferences(SPreferences defaultUserPreferences) {
        if (gDefaultUserPreferences != null) {
            try {
                gDefaultUserPreferences.flush();
            }
            catch (SPreferencesException sPreferencesException) {
                // empty catch block
            }
        }
        gDefaultUserPreferences = defaultUserPreferences;
    }

    public static SPreferences getDefaultSystemPreferences() {
        if (gDefaultSystemPreferences == null) {
            gDefaultSystemPreferences = SPrefs.tryToCreate("StF Applications.ini", 529);
        }
        return gDefaultSystemPreferences;
    }

    public static void setDefaultSystemPreferences(SPreferences defaultSystemPreferences) {
        if (gDefaultSystemPreferences != null) {
            try {
                gDefaultSystemPreferences.flush();
            }
            catch (SPreferencesException sPreferencesException) {
                // empty catch block
            }
        }
        gDefaultSystemPreferences = defaultSystemPreferences;
    }
}

