/*
 * Decompiled with CFR 0.152.
 */
package reg;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import reflect.SMethod;
import reg.SRegistryException;

public final class SWinRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int HKEY_DYN_DATA = -2147483642;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FILE_NOT_FOUND = 2;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int SUBKEYS_NUMBER = 0;
    public static final int VALUES_NUMBER = 2;
    public static final int MAX_KEY_LENGTH = 3;
    public static final int MAX_VALUE_NAME_LENGTH = 4;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    private Method regOpenKey = null;
    private Method regCloseKey = null;
    private Method regDelKey = null;
    private Method regCreateKey = null;
    private Method regFlushKey = null;
    private Method regQueryValue = null;
    private Method regSetValue = null;
    private Method regDelValue = null;
    private Method regQueryInfoKey = null;
    private Method regEnumKey = null;
    private Method regEnumValue = null;

    public SWinRegistry() throws SRegistryException {
        String str = System.getProperty("os.name");
        if (str == null || str.toLowerCase().indexOf("windows") == -1) {
            throw new SRegistryException("Operating system: " + str + " is not supported!");
        }
        this.initMethods();
    }

    public final int openKey(int key, String subkey, int security_mask) throws SRegistryException {
        int[] result;
        block3: {
            try {
                result = (int[])this.regOpenKey.invoke(null, new Integer(key), this.getString(subkey), new Integer(security_mask));
                if (result != null && result[1] == 0) break block3;
                return -1;
            }
            catch (Exception e) {
                throw new SRegistryException(e.getMessage());
            }
        }
        return result[0];
    }

    public final int openKey(int key, String subkey) throws SRegistryException {
        return this.openKey(key, subkey, 983103);
    }

    public final byte[] enumValueName(int key, int valueNameIndex, int maxValueNameLength) throws SRegistryException {
        try {
            return (byte[])this.regEnumValue.invoke(null, new Integer(key), new Integer(valueNameIndex), new Integer(maxValueNameLength));
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final List<String> listValueNames(int key, String subkey) throws SRegistryException {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                int x = 0;
                while (x != info[2]) {
                    String tmp = SWinRegistry.parseValue(this.enumValueName(handle, x, info[4] + 1));
                    if (tmp != null) {
                        ret.add(tmp);
                    }
                    ++x;
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public final List<String> listValueNames(int key) throws SRegistryException {
        return this.listValueNames(key, null);
    }

    public final byte[] enumKeys(int key, int subkeyIndex, int maxKeyNameLength) throws SRegistryException {
        try {
            return (byte[])this.regEnumKey.invoke(null, new Integer(key), new Integer(subkeyIndex), new Integer(maxKeyNameLength));
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final List<String> listKeys(int key, String subkey) throws SRegistryException {
        int handle = -1;
        try {
            int[] info;
            handle = this.openKey(key, subkey, 131097);
            if (handle != -1 && (info = this.getChildInformation(handle)) != null && info[0] != -1) {
                ArrayList<String> ret = new ArrayList<String>();
                int x = 0;
                while (x != info[0]) {
                    String tmp = SWinRegistry.parseValue(this.enumKeys(handle, x, info[3] + 1));
                    if (tmp != null) {
                        ret.add(tmp);
                    }
                    ++x;
                }
                ArrayList<String> arrayList = ret.isEmpty() ? null : ret;
                return arrayList;
            }
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
        finally {
            this.closeKey(handle);
        }
        return null;
    }

    public final List<String> listKeys(int key) throws SRegistryException {
        return this.listKeys(key, null);
    }

    public final int[] getChildInformation(int key) throws SRegistryException {
        try {
            return (int[])this.regQueryInfoKey.invoke(null, new Integer(key));
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final int delValue(int key, String valueName) throws SRegistryException {
        try {
            Integer ret = (Integer)this.regDelValue.invoke(null, new Integer(key), this.getString(valueName));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final int setValue(int key, String valueName, String value) throws SRegistryException {
        try {
            Integer ret = (Integer)this.regSetValue.invoke(null, new Integer(key), this.getString(valueName), this.getString(value));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final byte[] readValue(int key, String valueName) throws SRegistryException {
        try {
            byte[] ret = (byte[])this.regQueryValue.invoke(null, new Integer(key), this.getString(valueName));
            return ret;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final String getValue(int key, String valueName) throws SRegistryException {
        byte[] ret = this.readValue(key, valueName);
        if (ret != null) {
            return SWinRegistry.parseValue(ret);
        }
        throw new SRegistryException("No such value " + valueName);
    }

    public final int flushKey(int key) throws SRegistryException {
        try {
            Integer ret = (Integer)this.regFlushKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final int delKey(int key, String subkey) throws SRegistryException {
        if (subkey == null || subkey.length() == 0) {
            throw new SRegistryException("subkey cannot be null");
        }
        try {
            Integer ret = (Integer)this.regDelKey.invoke(null, new Integer(key), this.getString(subkey));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final int createKey(int key, String subkey) throws SRegistryException {
        try {
            int[] result = (int[])this.regCreateKey.invoke(null, new Integer(key), this.getString(subkey));
            if (result[1] == 0) {
                return result[0];
            }
            return -1;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public final int closeKey(int key) throws SRegistryException {
        try {
            Integer ret = (Integer)this.regCloseKey.invoke(null, new Integer(key));
            if (ret != null) {
                return ret;
            }
            return -1;
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    private final byte[] getString(String str) {
        if (str == null) {
            str = "";
        }
        str = String.valueOf(str) + "\u0000";
        return str.getBytes();
    }

    public static final String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private final void initMethods() throws SRegistryException {
        try {
            String cls = "java.util.prefs.WindowsPreferences";
            this.regOpenKey = SMethod.getMethod("WindowsRegOpenKey", cls, true);
            this.regCloseKey = SMethod.getMethod("WindowsRegCloseKey", cls, true);
            this.regCreateKey = SMethod.getMethod("WindowsRegCreateKeyEx", cls, true);
            this.regDelKey = SMethod.getMethod("WindowsRegDeleteKey", cls, true);
            this.regFlushKey = SMethod.getMethod("WindowsRegFlushKey", cls, true);
            this.regQueryValue = SMethod.getMethod("WindowsRegQueryValueEx", cls, true);
            this.regSetValue = SMethod.getMethod("WindowsRegSetValueEx", cls, true);
            this.regDelValue = SMethod.getMethod("WindowsRegDeleteValue", cls, true);
            this.regQueryInfoKey = SMethod.getMethod("WindowsRegQueryInfoKey", cls, true);
            this.regEnumKey = SMethod.getMethod("WindowsRegEnumKeyEx", cls, true);
            this.regEnumValue = SMethod.getMethod("WindowsRegEnumValue", cls, true);
        }
        catch (Exception e) {
            throw new SRegistryException(e.getMessage());
        }
    }

    public static final void main(String[] args) throws Exception {
        SWinRegistry reg = new SWinRegistry();
        int key = reg.openKey(-2147483646, "Software\\Microsoft");
        int key2 = -1;
        List<String> l = reg.listKeys(key);
        System.out.println("SOME KEYS....");
        int x = 0;
        while (l != null && x != l.size()) {
            System.out.println(String.valueOf(x) + " == " + l.get(x));
            ++x;
        }
        if (l.size() > 0) {
            key2 = reg.openKey(key, l.get(0));
        }
        l = reg.listValueNames(key2);
        System.out.println("SOME VALUENAMES.....");
        x = 0;
        while (l != null && x != l.size()) {
            System.out.println(String.valueOf(x) + " == " + l.get(x));
            ++x;
        }
        System.out.println("SOME STRING VALUES....");
        x = 0;
        while (l != null && x != l.size()) {
            byte[] buf = reg.readValue(key2, l.get(x));
            System.out.println(String.valueOf(x) + ": " + l.get(x) + " == " + SWinRegistry.parseValue(buf));
            ++x;
        }
        System.out.println("default entry == " + SWinRegistry.parseValue(reg.readValue(key, null)));
        l = reg.listKeys(-2147483646);
        System.out.println("KEYS FROM LOCAL_MACHINE....");
        x = 0;
        while (l != null && x != l.size()) {
            System.out.println(String.valueOf(x) + " == " + l.get(x));
            ++x;
        }
        reg.closeKey(key2);
        reg.closeKey(key);
    }
}

