/*
 * Decompiled with CFR 0.152.
 */
package sql;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListSet;
import prefs.SPreferences;
import prefs.SPreferencesException;
import prefs.SPrefs;
import sql.SDSServer;
import sql.SStatement;
import sql.lock.SDSLockManager;

public class SConnection {
    private static SConnection iApplicationDefault = null;
    private Connection iConnection = null;
    SDSServer iServer = null;
    SDSLockManager iDSLockManager = null;
    private ConcurrentSkipListSet<SStatement> iStatements = new ConcurrentSkipListSet();
    private String iDriver;
    private String iDatabase;
    private String iUrl;
    private String iUsername;
    private String iPassword;

    public SConnection(String driver, String database, String url, String username, String password) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        this.setDriver(driver);
        this.setDatabase(database);
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
        this.setConnection(SConnection.generateConnection(this.getDriver(), this.getDatabase(), this.getUrl(), this.getUsername(), this.getPassword()));
        if (iApplicationDefault == null) {
            SConnection.setApplicationDefault(this);
        }
        this.setServer(new SDSServer(this));
    }

    public static final void executeSql(String sql, SConnection con) throws SQLException {
        SStatement stmt = null;
        try {
            stmt = con.getStatement();
            stmt.execute(SDSServer.translateSql(sql, con));
            con.releaseStatement(stmt);
        }
        finally {
            if (stmt != null) {
                con.releaseStatement(stmt);
            }
        }
    }

    public final void executeSql(String sql) throws SQLException {
        SConnection.executeSql(sql, this);
    }

    public static final boolean executeSqlNoEx(String sql, SConnection con) {
        boolean rc = false;
        try {
            SConnection.executeSql(sql, con);
            rc = true;
        }
        catch (SQLException e) {
            rc = false;
        }
        return rc;
    }

    public final boolean executeSqlNoEx(String sql) {
        return SConnection.executeSqlNoEx(sql, this);
    }

    public final void executeSqlScript(URL script) throws IOException, SQLException {
        SConnection.executeSqlScript(script, this);
    }

    public static final void executeSqlScript(String fileName, SConnection con) throws FileNotFoundException, IOException, SQLException {
        SConnection.executeSqlScript(new FileReader(fileName), con);
    }

    public final void executeSqlScript(String fileName) throws FileNotFoundException, IOException, SQLException {
        SConnection.executeSqlScript(fileName, this);
    }

    public static final void executeSqlScript(URL script, SConnection con) throws IOException, SQLException {
        SConnection.executeSqlScript(new InputStreamReader(script.openStream()), con);
    }

    public final void executeSqlScript(Reader reader) throws IOException, SQLException {
        SConnection.executeSqlScript(reader, this);
    }

    public static final void executeSqlScript(Reader reader, SConnection con) throws IOException, SQLException {
        String il;
        BufferedReader breader = new BufferedReader(reader);
        String sql = "";
        while ((il = breader.readLine()) != null) {
            if (il.length() <= 0) continue;
            if (il.lastIndexOf(";") == il.length() - 1) {
                sql = String.valueOf(sql) + il.substring(0, il.length() - 1);
                con.executeSql(sql);
                sql = "";
                continue;
            }
            sql = String.valueOf(sql) + il;
        }
        if (sql.length() > 0) {
            con.executeSql(sql);
        }
        breader.close();
    }

    public final SStatement getStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SStatement stmt2 = null;
        for (SStatement stmt2 : this.iStatements) {
            Statement s;
            if (!stmt2.isStmtTypeAndConcurrency() || !stmt2.iStmtTypeAndConcurrency || (s = stmt2.getStmt()).getResultSetType() != resultSetType || s.getResultSetConcurrency() != resultSetConcurrency || s.getResultSetHoldability() != resultSetHoldability) continue;
            this.iStatements.remove(stmt2);
            return stmt2;
        }
        return this.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public final SStatement getStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        SStatement stmt2 = null;
        for (SStatement stmt2 : this.iStatements) {
            Statement s;
            if (!stmt2.isStmtTypeAndConcurrency() || stmt2.isStmtHoldability() || (s = stmt2.getStmt()).getResultSetType() != resultSetType || s.getResultSetConcurrency() != resultSetConcurrency) continue;
            this.iStatements.remove(stmt2);
            return stmt2;
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public final SStatement getStatement() throws SQLException {
        SStatement stmt2 = null;
        for (SStatement stmt2 : this.iStatements) {
            if (stmt2.isStmtTypeAndConcurrency() || stmt2.isStmtHoldability()) continue;
            this.iStatements.remove(stmt2);
            return stmt2;
        }
        return this.createStatement();
    }

    public final void releaseStatement(SStatement stmt) {
        try {
            if (stmt != null && stmt.getConnection() == this.iConnection) {
                this.iStatements.add(stmt);
            }
        }
        catch (Exception e) {
            this.iStatements.add(stmt);
        }
    }

    protected final SStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SStatement stmt = new SStatement();
        stmt.setStmtTypeAndConcurrency(true);
        stmt.setStmtHoldability(true);
        stmt.setConnection(this.getConnection());
        stmt.setStmt(this.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
        return stmt;
    }

    protected final SStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        SStatement stmt = new SStatement();
        stmt.setStmtTypeAndConcurrency(true);
        stmt.setStmtHoldability(false);
        stmt.setConnection(this.getConnection());
        stmt.setStmt(this.getConnection().createStatement(resultSetType, resultSetConcurrency));
        return stmt;
    }

    protected final SStatement createStatement() throws SQLException {
        SStatement stmt = new SStatement();
        stmt.setStmtTypeAndConcurrency(false);
        stmt.setStmtHoldability(false);
        stmt.setConnection(this.getConnection());
        stmt.setStmt(this.getConnection().createStatement());
        return stmt;
    }

    public static final Connection generateConnection(String driver, String database, String url, String username, String password) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        Connection con = null;
        SPreferences p = null;
        String jarFile = "";
        try {
            p = SPrefs.getPreferencesInstance(null, 17);
            jarFile = p.tryGet(String.valueOf(driver) + ".jar", "", "jdbc.driver.jars");
        }
        catch (SPreferencesException e) {
            jarFile = "";
        }
        if (jarFile.length() > 0) {
            File file = new File(jarFile);
            try {
                URLClassLoader ucl = new URLClassLoader(new URL[]{file.toURI().toURL()});
                Class<?> driverclass = null;
                driverclass = ucl.loadClass(driver);
                Class.forName(driver, true, ucl);
                Driver thedriver = (Driver)driverclass.newInstance();
                Properties info = new Properties();
                if (username != null) {
                    info.put("user", username);
                }
                if (password != null) {
                    info.put("password", password);
                }
                con = thedriver.connect(database == null ? url : String.valueOf(url) + database, info);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (con == null) {
            Class.forName(driver).newInstance();
            con = database != null && database.length() > 0 ? DriverManager.getConnection(String.valueOf(url) + database, username, password) : DriverManager.getConnection(url, username, password);
        }
        return con;
    }

    public static final String[] getDatabaseNames(Connection con) throws SQLException {
        String[] dbNames = new String[]{};
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = dbmd.getCatalogs();
        while (rs.next()) {
            String db = rs.getString(1);
            if (db == null) continue;
            dbNames = Arrays.copyOf(dbNames, dbNames.length + 1);
            dbNames[dbNames.length - 1] = db;
        }
        return dbNames;
    }

    public final String[] getDatabaseNames() throws SQLException {
        String[] tmp = SConnection.getDatabaseNames(this.getConnection());
        return tmp;
    }

    public static final String[] getDatabaseNames(String driver, String url, String username, String password) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        String[] rc = null;
        Connection con = SConnection.generateConnection(driver, "", url, username, password);
        rc = SConnection.getDatabaseNames(con);
        con.close();
        return rc;
    }

    public final void clearWarnings() throws SQLException {
        this.iConnection.clearWarnings();
    }

    public final void close() throws SQLException {
        this.iConnection.close();
    }

    public final void commit() throws SQLException {
        this.iConnection.commit();
    }

    public final Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.iConnection.createArrayOf(typeName, elements);
    }

    public final Blob createBlob() throws SQLException {
        return this.iConnection.createBlob();
    }

    public final Clob createClob() throws SQLException {
        return this.iConnection.createClob();
    }

    public final NClob createNClob() throws SQLException {
        return this.iConnection.createNClob();
    }

    public final SQLXML createSQLXML() throws SQLException {
        return this.iConnection.createSQLXML();
    }

    public final Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.iConnection.createStruct(typeName, attributes);
    }

    public final boolean getAutoCommit() throws SQLException {
        return this.iConnection.getAutoCommit();
    }

    public final String getCatalog() throws SQLException {
        return this.iConnection.getCatalog();
    }

    public final Properties getClientInfo() throws SQLException {
        return this.iConnection.getClientInfo();
    }

    public final String getClientInfo(String name) throws SQLException {
        return this.iConnection.getClientInfo(name);
    }

    public final int getHoldability() throws SQLException {
        return this.iConnection.getHoldability();
    }

    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.iConnection.getMetaData();
    }

    public final int getTransactionIsolation() throws SQLException {
        return this.iConnection.getTransactionIsolation();
    }

    public final Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.iConnection.getTypeMap();
    }

    public final SQLWarning getWarnings() throws SQLException {
        return this.iConnection.getWarnings();
    }

    public final boolean isClosed() throws SQLException {
        return this.iConnection.isClosed();
    }

    public final boolean isReadOnly() throws SQLException {
        return this.iConnection.isReadOnly();
    }

    public final boolean isValid(int timeout) throws SQLException {
        return this.iConnection.isValid(timeout);
    }

    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.iConnection.isWrapperFor(iface);
    }

    public final String nativeSQL(String sql) throws SQLException {
        return this.iConnection.nativeSQL(sql);
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.iConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.iConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.iConnection.prepareCall(sql);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.iConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.iConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.iConnection.prepareStatement(sql, autoGeneratedKeys);
    }

    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.iConnection.prepareStatement(sql, columnIndexes);
    }

    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.iConnection.prepareStatement(sql, columnNames);
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.iConnection.prepareStatement(sql);
    }

    public final void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.iConnection.releaseSavepoint(savepoint);
    }

    public final void rollback() throws SQLException {
        this.iConnection.rollback();
    }

    public final void rollback(Savepoint savepoint) throws SQLException {
        this.iConnection.rollback(savepoint);
    }

    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.iConnection.setAutoCommit(autoCommit);
    }

    public final void setCatalog(String catalog) throws SQLException {
        this.iConnection.setCatalog(catalog);
    }

    public final void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.iConnection.setClientInfo(properties);
    }

    public final void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.iConnection.setClientInfo(name, value);
    }

    public final void setHoldability(int holdability) throws SQLException {
        this.iConnection.setHoldability(holdability);
    }

    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.iConnection.setReadOnly(readOnly);
    }

    public final Savepoint setSavepoint() throws SQLException {
        return this.iConnection.setSavepoint();
    }

    public final Savepoint setSavepoint(String name) throws SQLException {
        return this.iConnection.setSavepoint(name);
    }

    public final void setTransactionIsolation(int level) throws SQLException {
        this.iConnection.setTransactionIsolation(level);
    }

    public final void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.iConnection.setTypeMap(map);
    }

    public final <T> T unwrap(Class<T> iface) throws SQLException {
        return this.iConnection.unwrap(iface);
    }

    public final Connection getConnection() {
        return this.iConnection;
    }

    public final void setConnection(Connection connection) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.iConnection = connection;
    }

    public final String getDriver() {
        return this.iDriver;
    }

    public final void setDriver(String driver) {
        this.iDriver = driver;
    }

    public final String getDatabase() {
        return this.iDatabase;
    }

    public final void setDatabase(String database) {
        this.iDatabase = database == null ? "" : database;
    }

    public final String getUrl() {
        return this.iUrl;
    }

    public final void setUrl(String url) {
        this.iUrl = url == null ? "" : url;
    }

    public final String getUsername() {
        return this.iUsername;
    }

    public final void setUsername(String username) {
        this.iUsername = username == null ? "" : username;
    }

    public final String getPassword() {
        return this.iPassword;
    }

    public final void setPassword(String password) {
        this.iPassword = password == null ? "" : password;
    }

    protected final void finalize() throws Throwable {
        while (!this.iStatements.isEmpty()) {
            SStatement stmt = this.iStatements.first();
            this.iStatements.remove(stmt);
            stmt.close();
        }
        super.finalize();
    }

    public static final SConnection getApplicationDefault() {
        return iApplicationDefault;
    }

    public static final void setApplicationDefault(SConnection applicationDefault) {
        iApplicationDefault = applicationDefault;
    }

    public final SDSServer getServer() {
        return this.iServer;
    }

    public final void setServer(SDSServer server) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        this.iServer = server;
        this.setDSLockManager(server.getDSLockManager());
    }

    public final SDSLockManager getDSLockManager() {
        return this.iDSLockManager;
    }

    public final void setDSLockManager(SDSLockManager lockManager) {
        this.iDSLockManager = lockManager;
    }
}

