/*
 * Decompiled with CFR 0.152.
 */
package sql;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import sql.SConnection;
import sql.lock.SDSLockManager;
import sun.jdbc.odbc.JdbcOdbcConnection;

public class SDSServer {
    private SConnection iConnection = null;
    private long iUID = 0L;
    private SDSLockManager iDSLockManager = null;

    public SDSServer(SConnection con) throws SQLException {
        this.setConnection(con);
    }

    public static final String translateSql(String sql, SConnection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        String vendor = dbmd.getDatabaseProductName();
        if (vendor.equalsIgnoreCase("SQLBase")) {
            int poe;
            int poa = sql.indexOf("ALTER TABLE");
            int poc = sql.indexOf("COMMENT");
            if (poa >= 0 && poc > poa && (poe = sql.indexOf("=", poc)) > poc) {
                String tn = sql.substring(poa + 11, poc);
                String co = sql.substring(poe + 1);
                sql = "COMMENT ON TABLE " + tn + " IS " + co;
            }
            sql = sql.replace("NOW()", "@NOW()");
        }
        return sql;
    }

    public static final long getConnectionId(Connection con) throws SQLException {
        long id = 0L;
        DatabaseMetaData meta = con.getMetaData();
        String dbProduct = meta.getDatabaseProductName();
        String dbVersion = meta.getDatabaseProductVersion();
        if (con instanceof JdbcOdbcConnection) {
            Statement stmt = con.createStatement();
            stmt.execute("SELECT * FROM SYSTABLES");
        } else if (dbProduct.equalsIgnoreCase("MYSQL")) {
            try {
                Field f = con.getClass().getSuperclass().getDeclaredField("connectionId");
                f.setAccessible(true);
                id = f.getLong(con);
                f.setAccessible(false);
                return id;
            }
            catch (Exception stmt) {}
        } else if (dbProduct.equalsIgnoreCase("SQLBASE")) {
            try {
                Field f = con.getClass().getDeclaredField("Session");
                f.setAccessible(true);
                Object o = f.get(con);
                f.setAccessible(false);
                f = o.getClass().getDeclaredField("processNumber");
                f.setAccessible(true);
                id = f.getLong(o);
                f.setAccessible(false);
                return id;
            }
            catch (Exception e) {
                String string = e.getMessage();
            }
        }
        return 0L;
    }

    public static final long getConnectionId(SConnection con) throws SQLException {
        return SDSServer.getConnectionId(con.getConnection());
    }

    public final long getUID() {
        return this.iUID;
    }

    public final void setUID(long uid) {
        this.iUID = uid;
    }

    public final SConnection getConnection() {
        return this.iConnection;
    }

    public final void setConnection(SConnection connection) throws SQLException {
        this.setUID(SDSServer.getConnectionId(connection));
        this.iConnection = connection;
    }

    public final SDSLockManager getDSLockManager() throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        if (this.iDSLockManager == null) {
            this.setDSLockManager(new SDSLockManager());
        }
        return this.iDSLockManager;
    }

    public final void setDSLockManager(SDSLockManager lockManager) {
        this.iDSLockManager = lockManager;
    }
}

