/*
 * Decompiled with CFR 0.152.
 */
package sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import sql.SConnection;
import sql.SSQLColumn;
import sql.SStatement;

public class SSQLTable {
    private String iName = null;
    private int iColumnCount = 0;
    private String iRemarks = null;
    private SSQLColumn[] iColumns = new SSQLColumn[0];
    private String iPrimaryKey = null;
    private String[] iIndexes = new String[0];

    private static final void fillFromResultSet(SSQLTable t, ResultSet rs) {
        t.setColumnCount(0);
        try {
            t.setName(rs.getString(3));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            t.setRemarks(rs.getString(5));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static final String[] getSqlCreate(SSQLTable table) {
        String[] rc = new String[2 + table.iIndexes.length];
        String sql = "CREATE TABLE " + table.getName() + " (";
        int i = 0;
        while (i < table.getColumnCount()) {
            SSQLColumn c = table.iColumns[i];
            sql = String.valueOf(sql) + c.getName() + " ";
            String t = c.getType();
            sql = String.valueOf(sql) + t;
            if (t.equalsIgnoreCase("CHAR") || t.equalsIgnoreCase("VARCHAR")) {
                sql = String.valueOf(sql) + "(" + c.getLength() + ")";
            }
            if (c.getNulls().equalsIgnoreCase("N")) {
                sql = String.valueOf(sql) + " NOT NULL";
            }
            if (c.getDefault().length() > 0) {
                sql = String.valueOf(sql) + " DEFAULT " + c.getDefault();
            }
            if (i < table.getColumnCount() - 1) {
                sql = String.valueOf(sql) + ",";
            }
            ++i;
        }
        if (table.getPrimaryKey() != null && table.getPrimaryKey().length() > 0) {
            sql = String.valueOf(sql) + ",PRIMARY KEY(" + table.getPrimaryKey() + ")";
        }
        rc[0] = sql = String.valueOf(sql) + ")";
        rc[1] = sql = "ALTER TABLE " + table.getName() + " COMMENT = '" + table.getRemarks() + "'";
        i = 0;
        while (i < table.iIndexes.length) {
            rc[2 + i] = sql = "CREATE " + table.iIndexes[i];
            ++i;
        }
        return rc;
    }

    public final String[] getSqlCreate() {
        return SSQLTable.getSqlCreate(this);
    }

    public static final void buildFromStringArray(SSQLTable table, String[] definition, String[] indexes) throws SQLException {
        int coldl = 8;
        if (definition == null || definition.length < 2 || (definition.length - 2) % 8 > 0) {
            throw new SQLException("Invalid table definition string (table definition)");
        }
        table.setName(definition[0]);
        table.setRemarks(definition[1]);
        table.setColumnCount((definition.length - 2) / 8);
        int i = 2;
        int o = 1;
        while (i < definition.length) {
            String cname = definition[i + 0];
            String ctype = definition[i + 1];
            String length = definition[i + 2];
            String scale = definition[i + 3];
            String nullable = definition[i + 4];
            String label = definition[i + 5];
            String remark = definition[i + 6];
            String def = definition[i + 7];
            if (cname.equalsIgnoreCase("PRIMARY KEY")) {
                table.setPrimaryKey(ctype);
                table.setColumnCount(table.getColumnCount() - 1);
                break;
            }
            SSQLColumn c = new SSQLColumn();
            table.iColumns = Arrays.copyOf(table.iColumns, o);
            table.iColumns[o - 1] = c;
            c.setName(cname);
            c.setType(ctype);
            c.setLength(Integer.decode(length));
            c.setScale(Integer.decode(scale));
            if (nullable.equalsIgnoreCase("TRUE")) {
                c.setNulls("Y");
            } else {
                c.setNulls("N");
            }
            c.setLabel(label);
            c.setRemarks(remark);
            c.setDefault(def);
            ++o;
            i += 8;
        }
        if (indexes != null && indexes.length > 0) {
            if (indexes.length % 3 > 0) {
                throw new SQLException("Invalid table definition string (index)");
            }
            table.iIndexes = new String[indexes.length / 3];
            i = 0;
            while (i < indexes.length) {
                String idx = "";
                table.iIndexes[i] = idx = String.valueOf(indexes[i + 1]) + " INDEX " + indexes[i + 0] + " ON " + table.getName() + " (" + indexes[i + 2] + ")";
                i += 3;
            }
        }
    }

    public final void buildFromStringArray(String[] definition, String[] indexes) throws SQLException {
        SSQLTable.buildFromStringArray(this, definition, indexes);
    }

    public static final void readColumnDefinitionsFromConnection(SSQLTable table, SConnection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = dbmd.getColumns(null, null, table.getName(), null);
        while (rs.next()) {
            table.setColumnCount(table.getColumnCount() + 1);
            SSQLColumn c = new SSQLColumn(con, table, rs.getString(4));
            table.iColumns = Arrays.copyOf(table.iColumns, table.getColumnCount());
            table.iColumns[table.getColumnCount() - 1] = c;
            rs = dbmd.getColumns(null, null, table.getName(), null);
            int i = 0;
            while (i < table.getColumnCount()) {
                rs.next();
                ++i;
            }
        }
        if (table.iColumns != null) {
            int i = 0;
            while (i < table.iColumns.length - 1) {
                int j = i + 1;
                while (j < table.iColumns.length) {
                    if (table.iColumns[i].getOrdinal() > table.iColumns[j].getOrdinal()) {
                        SSQLColumn tmp = table.iColumns[i];
                        table.iColumns[i] = table.iColumns[j];
                        table.iColumns[j] = tmp;
                        i = 0;
                        j = 1;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static final String readCommentFromConnection(String tableName, SConnection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        String sql = "";
        String dbVendor = dbmd.getDatabaseProductName();
        if (dbVendor.equalsIgnoreCase("MYSQL")) {
            sql = "SHOW TABLE STATUS FROM " + con.getDatabase() + " LIKE '" + tableName + "'";
        } else if (dbVendor.equalsIgnoreCase("SQLBASE")) {
            sql = "SELECT Remarks FROM SYSTABLES WHERE Name='" + tableName + "'";
        }
        if (sql.length() > 0) {
            SStatement stmt = con.getStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    if (dbVendor.equalsIgnoreCase("MYSQL")) {
                        String string = rs.getString("Comment");
                        return string;
                    }
                    String string = rs.getString(1);
                    return string;
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                con.releaseStatement(stmt);
            }
        }
        return "";
    }

    public static final void readCommentFromConnection(SSQLTable table, SConnection con) throws SQLException {
        try {
            table.setRemarks(SSQLTable.readCommentFromConnection(table.getName(), con));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static final void readPKConstraintsFromConnection(SSQLTable table, SConnection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        String sql = "";
        String dbVendor = dbmd.getDatabaseProductName();
        if (dbVendor.equalsIgnoreCase("MYSQL")) {
            sql = "SELECT DISTINCT Column_Name FROM information_schema.Key_Column_Usage WHERE Table_Name='" + table.getName() + "' AND Table_Schema='" + con.getDatabase() + "' ORDER BY Ordinal_Position";
        } else if (dbVendor.equalsIgnoreCase("SQLBASE")) {
            sql = "SELECT DISTINCT Colname FROM SYSPKCONSTRAINTS WHERE Name='" + table.getName() + "' ORDER BY PKColSeqNum";
        }
        if (sql.length() > 0) {
            SStatement stmt = con.getStatement();
            try {
                String idx = "";
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    idx = String.valueOf(idx) + rs.getString(1) + ",";
                }
                if (idx.length() > 0) {
                    idx = idx.substring(0, idx.length() - 1);
                    table.setPrimaryKey(idx);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            con.releaseStatement(stmt);
        }
    }

    public static final void readIndexesFromConnection(SSQLTable table, SConnection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        String sql = "";
        String dbVendor = dbmd.getDatabaseProductName();
        if (dbVendor.equalsIgnoreCase("MYSQL")) {
            sql = "";
        } else if (dbVendor.equalsIgnoreCase("SQLBASE")) {
            sql = "SELECT A.UniqueRule,B.ColName,B.Ordering,B.IXName FROM SysIndexes A,SysKeys B WHERE A.TBName='" + table.getName() + "' AND A.Name=B.IXName ORDER BY B.ColSeq";
        }
        if (sql.length() > 0) {
            SStatement stmt = con.getStatement();
            try {
                String idx = "";
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String URule = rs.getString(1);
                    String ColName = rs.getString(2);
                    String Ordering = rs.getString(3);
                    String ixname = rs.getString(4);
                    if (idx.length() == 0) {
                        idx = URule.equalsIgnoreCase("U") ? String.valueOf(idx) + "UNIQUE INDEX " + ixname + " (" : String.valueOf(idx) + "INDEX " + ixname + " (";
                    }
                    idx = String.valueOf(idx) + ColName;
                    idx = Ordering.equalsIgnoreCase("A") ? String.valueOf(idx) + " ASC," : String.valueOf(idx) + " DESC,";
                }
                if (idx.length() > 0) {
                    idx = String.valueOf(idx.substring(0, idx.length() - 1)) + ")";
                    table.iIndexes = Arrays.copyOf(table.iIndexes, table.iIndexes.length + 1);
                    table.iIndexes[table.iIndexes.length - 1] = idx;
                }
            }
            catch (Exception e) {
                sql = "";
            }
            con.releaseStatement(stmt);
        }
    }

    public static final void readFromConnection(SSQLTable table, SConnection con) throws SQLException {
        DatabaseMetaData dbmd = con.getMetaData();
        ResultSet rs = dbmd.getTables(null, null, table.getName(), null);
        while (rs.next()) {
            if (!rs.getString(3).equalsIgnoreCase(table.getName())) continue;
            SSQLTable.fillFromResultSet(table, rs);
            break;
        }
        SSQLTable.readColumnDefinitionsFromConnection(table, con);
        SSQLTable.readCommentFromConnection(table, con);
        SSQLTable.readPKConstraintsFromConnection(table, con);
        SSQLTable.readIndexesFromConnection(table, con);
    }

    public final void readFromConnection(SConnection con) throws SQLException {
        SSQLTable.readFromConnection(this, con);
    }

    public SSQLTable() {
    }

    public SSQLTable(String[] tableDefinition, String[] indexDefinition) throws SQLException {
        SSQLTable.buildFromStringArray(this, tableDefinition, indexDefinition);
    }

    public SSQLTable(SConnection con, String tableName) throws SQLException {
        this.setName(tableName);
        this.readFromConnection(con);
    }

    public final String getName() {
        return this.iName;
    }

    public final void setName(String name) {
        this.iName = name;
    }

    public final int getColumnCount() {
        return this.iColumnCount;
    }

    public final void setColumnCount(int columnCount) {
        this.iColumnCount = columnCount;
    }

    public final String getRemarks() {
        return this.iRemarks;
    }

    public final void setRemarks(String remarks) {
        this.iRemarks = remarks;
    }

    public final String getPrimaryKey() {
        return this.iPrimaryKey;
    }

    public final void setPrimaryKey(String primaryKey) {
        this.iPrimaryKey = primaryKey;
    }
}

