/*
 * Decompiled with CFR 0.152.
 */
package sql.lock;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import sql.SConnection;
import sql.SStatement;
import sql.lock.SDSLockEvent;
import sql.lock.SDSLockManager;
import sql.lock.SDSLockParameter;
import sql.lock.SDSLockSettings;

public class SDSLock {
    private Timestamp iTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
    private final SDSLockManager iLockManager;
    private final SDSLockParameter iLockParameter;
    protected Mode iMode;
    private final int iId;
    private final int iUserId;

    protected SDSLock(SDSLockManager manager, SDSLockParameter lp, Mode mode, int id, int userId) {
        this.iLockManager = manager;
        this.iLockParameter = lp;
        this.iMode = mode;
        this.iId = id;
        this.iUserId = userId;
    }

    public SConnection getConnection() {
        return this.iLockParameter.getConnection();
    }

    public String getDatabase() {
        return this.iLockParameter.getDatabase();
    }

    public String getTable() {
        return this.iLockParameter.getTable();
    }

    public String getKey() {
        return this.iLockParameter.getKey();
    }

    public String getProgram() {
        return this.iLockParameter.getProgram();
    }

    public SDSLockParameter.Type getType() {
        return this.iLockParameter.getType();
    }

    public int getId() {
        return this.iId;
    }

    public int getUserId() {
        return this.iUserId;
    }

    public Mode getMode() {
        return this.iMode;
    }

    public static SDSLockParameter.Type intToLockType(int i) {
        return SDSLockParameter.intToLockType(i);
    }

    public static int lockTypeToInt(SDSLockParameter.Type type) {
        return SDSLockParameter.lockTypeToInt(type);
    }

    public Timestamp getTimestamp() {
        return this.iTimestamp;
    }

    public static SDSLock getLockFromDB(SDSLockManager manager, int lockId, int ourUserId, SDSLockParameter lparam) throws SQLException {
        String sql = "SELECT UserID,DB,TB,KY,PRG,LockType,TS FROM " + SDSLockSettings.getResourceTableName() + " WHERE ID=" + lockId;
        SStatement stmt = null;
        try {
            stmt = lparam.getConnection().getStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int userId = rs.getInt(1);
                String database = rs.getString(2);
                String table = rs.getString(3);
                String key = rs.getString(4);
                String program = rs.getString(5);
                SDSLockParameter.Type type = SDSLock.intToLockType(rs.getInt(6));
                if (!(lparam.getDatabase().equals(database) && lparam.getTable().equals(table) && lparam.getKey().equals(key) && lparam.getProgram().equals(program) && lparam.getType() == type)) {
                    throw new SQLException("Lock param mismatch");
                }
                Timestamp ts = rs.getTimestamp(7);
                Mode mode = userId == ourUserId ? Mode.OUR : Mode.OTHER;
                SDSLock lck = new SDSLock(manager, lparam, mode, lockId, userId);
                lck.iTimestamp = ts;
                SDSLock sDSLock = lck;
                return sDSLock;
            }
            throw new SQLException("No Lock found for id " + lockId);
        }
        finally {
            lparam.getConnection().releaseStatement(stmt);
        }
    }

    public static SDSLockParameter getLockParameterFromDB(SDSLockManager manager, int lockId) throws SQLException {
        SDSLockParameter lparam = null;
        String sql = "SELECT UserID,DB,TB,KY,PRG,LockType,TS FROM " + SDSLockSettings.getResourceTableName() + " WHERE ID=" + lockId;
        SStatement stmt = null;
        try {
            stmt = manager.getConnection().getStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                String database = rs.getString(2);
                String table = rs.getString(3);
                String key = rs.getString(4);
                String program = rs.getString(5);
                SDSLockParameter.Type type = SDSLock.intToLockType(rs.getInt(6));
                lparam = new SDSLockParameter(manager.getConnection(), type, database, table, key, program);
            }
        }
        finally {
            manager.getConnection().releaseStatement(stmt);
        }
        return lparam;
    }

    public static SDSLock tryLock(SDSLockManager manager, int userId, SDSLockParameter lparam) throws SQLException {
        SStatement stmt = null;
        try {
            stmt = lparam.getConnection().getStatement();
            String sql = "INSERT INTO " + SDSLockSettings.getResourceTableName() + " (UserID,DB,TB,KY,PRG,TS,LockType) VALUES (" + userId + ",'" + lparam.getDatabase() + "','" + lparam.getTable() + "','" + lparam.getKey() + "','" + lparam.getProgram() + "',SYSDATE()," + SDSLock.lockTypeToInt(SDSLockParameter.getDefaultType()) + ")";
            stmt.executeUpdate(sql, 1);
            ResultSet rs = stmt.getGeneratedKeys();
            if (rs.next()) {
                SDSLock lck;
                int id = rs.getInt(1);
                SDSLock sDSLock = lck = SDSLock.getLockFromDB(manager, id, userId, lparam);
                return sDSLock;
            }
            throw new SQLException("No auto generated columns");
        }
        finally {
            lparam.getConnection().releaseStatement(stmt);
        }
    }

    public void unlock() throws SQLException {
        SStatement stmt = null;
        int oid = this.iLockManager.getLockedUserId(this.getId());
        if (oid != this.iUserId) {
            throw new SQLException("Trying to releaye a lock which is not ours");
        }
        try {
            stmt = this.getConnection().getStatement();
            String sql = "DELETE FROM " + SDSLockSettings.getResourceTableName() + " WHERE ID='" + this.getId() + "'";
            this.getConnection().executeSqlNoEx(sql);
            SDSLockEvent evt = new SDSLockEvent(this.getConnection(), this, SDSLockEvent.Mode.RELEASED);
            this.iLockManager.fireSDSEvent(evt);
        }
        finally {
            this.getConnection().releaseStatement(stmt);
        }
    }

    public void unlockNoEx() {
        try {
            this.unlock();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public SDSLockParameter getLockParameter() {
        return this.iLockParameter;
    }

    public SDSLockManager getLockManager() {
        return this.iLockManager;
    }

    public static enum Mode {
        OUR,
        OTHER,
        OUR_RELEASED;

    }
}

