/*
 * Decompiled with CFR 0.152.
 */
package sql.lock;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import sql.lock.SDSLock;
import sql.lock.SDSLockEvent;
import sql.lock.SDSLockEventListener;
import sql.lock.SDSLockParameter;
import swiext.SAnimatedComponent;
import swiext.SDialog;

public class SDSLockDialog
extends SDialog
implements SDSLockEventListener {
    private JScrollPane scpneMain = null;
    private JPanel pnlContent = null;
    private JPanel pnlClientArea = null;
    private JPanel pnlButtonArea = null;
    private JButton btnCancel = null;
    private JLabel lbl1 = null;
    private JLabel lbl2 = null;
    private JLabel lbl3 = null;
    private JLabel lbl4 = null;
    private JLabel lblUser = null;
    private JLabel lblSince = null;
    private JLabel lblKey = null;
    private JLabel lblEmpty1 = null;
    private JLabel lblEmpty2 = null;
    private JLabel lblEmpty3 = null;
    private JLabel lblWaitMessage1 = null;
    private JLabel lblWaitMessage2 = null;
    private JLabel lblWaitMessage3 = null;
    private SAnimatedComponent iAnimatedPanel = null;
    private SDSLock iLock = null;
    private SDSLockParameter iLockParam = null;
    private SDSLock iAppliedLock = null;

    public SDSLockDialog() {
        this.initialize();
    }

    public SDSLockDialog(Window owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(408, 264));
        this.setContentPane(this.getScpneMain());
        this.setTitle("Lock Information");
    }

    private JScrollPane getScpneMain() {
        if (this.scpneMain == null) {
            this.scpneMain = new JScrollPane();
            this.scpneMain.setViewportView(this.getPnlContent());
        }
        return this.scpneMain;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gbcClientArea = new GridBagConstraints();
            gbcClientArea.fill = 1;
            gbcClientArea.weighty = 1.0;
            gbcClientArea.weightx = 1.0;
            GridBagConstraints gbcButtonArea = new GridBagConstraints();
            gbcButtonArea.fill = 0;
            gbcButtonArea.gridy = 1;
            gbcButtonArea.gridx = 0;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getPnlClientArea(), gbcClientArea);
            this.pnlContent.add((Component)this.getPnlButtonArea(), gbcButtonArea);
        }
        return this.pnlContent;
    }

    private JPanel getPnlClientArea() {
        if (this.pnlClientArea == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 1;
            this.lblEmpty1 = new JLabel();
            this.lblEmpty1.setText(" ");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.gridy = 9;
            this.lblEmpty3 = new JLabel();
            this.lblEmpty3.setText(" ");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 11;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridy = 8;
            this.lblWaitMessage3 = new JLabel();
            this.lblWaitMessage3.setText("Or you can push the \"Don't wait\" button below.");
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.gridwidth = 2;
            gridBagConstraints41.anchor = 17;
            gridBagConstraints41.gridy = 7;
            this.lblWaitMessage2 = new JLabel();
            this.lblWaitMessage2.setText("will be closed automatically.");
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.gridy = 6;
            this.lblWaitMessage1 = new JLabel();
            this.lblWaitMessage1.setText("You can wait until the lock has been removed. Then this dialog");
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 1;
            gridBagConstraints21.gridy = 5;
            this.lblEmpty2 = new JLabel();
            this.lblEmpty2.setText(" ");
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridwidth = 2;
            gridBagConstraints12.anchor = 17;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 4;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 4;
            this.lbl4 = new JLabel();
            this.lbl4.setText("Lock Key:    ");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 3;
            this.lbl3 = new JLabel();
            this.lbl3.setText("Since:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            this.lbl2 = new JLabel();
            this.lbl2.setText("User:");
            this.lbl1 = new JLabel();
            this.lbl1.setText("The database, table or row has been locked by an other user");
            this.pnlClientArea = new JPanel();
            this.pnlClientArea.setLayout(new GridBagLayout());
            this.pnlClientArea.add((Component)this.lbl1, gridBagConstraints12);
            this.pnlClientArea.add((Component)this.lbl2, gridBagConstraints);
            this.pnlClientArea.add((Component)this.lbl3, gridBagConstraints1);
            this.pnlClientArea.add((Component)this.lbl4, gridBagConstraints11);
            GridBagConstraints gbcAnimation = new GridBagConstraints();
            gbcAnimation.gridx = 0;
            gbcAnimation.gridy = 10;
            gbcAnimation.gridwidth = 2;
            this.pnlClientArea.add((Component)this.getLblUser(), gridBagConstraints2);
            this.pnlClientArea.add((Component)this.getLblSince(), gridBagConstraints3);
            this.pnlClientArea.add((Component)this.getLblKey(), gridBagConstraints4);
            this.pnlClientArea.add((Component)this.lblEmpty2, gridBagConstraints21);
            this.pnlClientArea.add((Component)this.lblWaitMessage1, gridBagConstraints31);
            this.pnlClientArea.add((Component)this.lblWaitMessage2, gridBagConstraints41);
            this.pnlClientArea.add((Component)this.lblWaitMessage3, gridBagConstraints5);
            this.pnlClientArea.add((Component)this.getAnimatedPanel(), gbcAnimation);
            this.pnlClientArea.add((Component)this.lblEmpty3, gridBagConstraints7);
            this.pnlClientArea.add((Component)this.lblEmpty1, gridBagConstraints8);
        }
        return this.pnlClientArea;
    }

    private JPanel getPnlButtonArea() {
        if (this.pnlButtonArea == null) {
            this.pnlButtonArea = new JPanel();
            this.pnlButtonArea.setLayout(new GridBagLayout());
            this.pnlButtonArea.add((Component)this.getBtnCancel(), new GridBagConstraints());
        }
        return this.pnlButtonArea;
    }

    private void dontWaitPressed() {
        this.getAnimatedPanel().stopAnimation();
        this.dispose();
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Don't wait");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SDSLockDialog.this.dontWaitPressed();
                }
            });
        }
        return this.btnCancel;
    }

    public JLabel getLblUser() {
        if (this.lblUser == null) {
            this.lblUser = new JLabel();
            this.lblUser.setText("<user>");
            this.lblUser.setForeground(SystemColor.activeCaption);
            this.lblUser.setBackground(SystemColor.desktop);
        }
        return this.lblUser;
    }

    public JLabel getLblSince() {
        if (this.lblSince == null) {
            this.lblSince = new JLabel();
            this.lblSince.setText("<since>");
            this.lblSince.setForeground(SystemColor.activeCaption);
            this.lblSince.setBackground(SystemColor.desktop);
        }
        return this.lblSince;
    }

    public JLabel getLblKey() {
        if (this.lblKey == null) {
            this.lblKey = new JLabel();
            this.lblKey.setText("<key>");
            this.lblKey.setForeground(SystemColor.activeCaption);
            this.lblKey.setBackground(SystemColor.desktop);
        }
        return this.lblKey;
    }

    private SAnimatedComponent getAnimatedPanel() {
        if (this.iAnimatedPanel == null) {
            this.iAnimatedPanel = new SAnimatedComponent();
            this.iAnimatedPanel.setPreferredSize(new Dimension(40, 40));
        }
        return this.iAnimatedPanel;
    }

    public SDSLock getAppliedLock() {
        return this.iAppliedLock;
    }

    private void fillLabelsFromLock(SDSLock lock) {
        this.getLblUser().setText(lock.getLockManager().getUserNameFromId(lock.getUserId()));
        String key = String.valueOf(lock.getDatabase()) + "." + lock.getTable() + "." + lock.getKey();
        this.getLblKey().setText(key);
        this.getLblSince().setText(lock.getTimestamp().toString());
    }

    public void setLock(SDSLock lock) {
        if (this.iLock != null) {
            this.iLock.getLockManager().removeEventListener(this);
        }
        if (lock != null) {
            this.iLock = lock;
            this.iLockParam = lock.getLockParameter();
            this.fillLabelsFromLock(this.iLock);
            this.iAnimatedPanel.startAnimation();
            lock.getLockManager().addEventListener(this, lock.getLockParameter());
            lock.getLockManager().tryThreadedLock(this.iLockParam, -1L, 1000);
        }
    }

    private void reTryLock(SDSLockEvent evt) {
        evt.getLock().getLockManager().tryThreadedLock(this.iLockParam, -1L, 1000);
    }

    @Override
    public void lockEventDispatched(SDSLockEvent evt) {
        if (evt.getMode() == SDSLockEvent.Mode.APPLIED) {
            this.iAppliedLock = evt.getLock();
            evt.getLock().getLockManager().removeEventListener(this);
            this.dispose();
        } else if (evt.getMode() == SDSLockEvent.Mode.ALREADY_LOCKED) {
            final SDSLockEvent fevt = evt;
            final Runnable r = new Runnable(){

                @Override
                public void run() {
                    SDSLockDialog.this.reTryLock(fevt);
                }
            };
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(r);
                }
            };
            t.start();
        }
    }
}

