/*
 * Decompiled with CFR 0.152.
 */
package sql.lock;

import awtext.SEventInterestListenerList;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import sql.SConnection;
import sql.SDSServer;
import sql.SStatement;
import sql.lock.SDSLock;
import sql.lock.SDSLockDialog;
import sql.lock.SDSLockEvent;
import sql.lock.SDSLockEventListener;
import sql.lock.SDSLockParameter;
import sql.lock.SDSLockSettings;
import sql.lock.SDSMessageSnooper;

public class SDSLockManager {
    private SConnection iConnection = null;
    private static SDSMessageSnooper iMsgSnooper = null;
    private int iUserId;
    private SEventInterestListenerList iListeners = new SEventInterestListenerList(true);

    private final void initializeLocking() {
        SDSLockSettings.checkTables(this.getConnection());
        SDSLockSettings.cleanupTables(this.getConnection());
        SDSLockSettings.setMaxVtsDuration(SDSLockSettings.getMaxVtsDuration(), this.getConnection());
        SDSLockSettings.setMsgLoopDuration(SDSLockSettings.getMsgLoopDuration(), this.getConnection());
        long id = 0L;
        try {
            id = SDSServer.getConnectionId(this.getConnection());
        }
        catch (Exception e) {
            id = (long)(Math.random() * 10000.0);
        }
        this.iUserId = (int)id;
        String un = this.getConnection().getUsername();
        String ws = System.getenv("COMPUTERNAME");
        String sql = "INSERT INTO " + SDSLockSettings.getLoginTableName() + " (UserID,UserName,NodeName,TS,VTS) VALUES (" + ((Object)id).toString() + ",'" + un + "','" + ws + "'," + "SYSDATE()" + "," + "SYSDATE()" + ")";
        this.getConnection().executeSqlNoEx(sql);
        if (iMsgSnooper == null) {
            iMsgSnooper = new SDSMessageSnooper(this.getConnection(), id);
        }
    }

    public SDSLockManager() throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        this(SConnection.getApplicationDefault());
    }

    public SDSLockManager(SConnection con) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        this.setConnection(con);
        this.initializeLocking();
    }

    public SDSLockManager(String driver, String database, String url, String username, String password) throws ClassNotFoundException, SQLException, IllegalAccessException, InstantiationException {
        this.setConnection(new SConnection(driver, database, url, username, password));
        this.initializeLocking();
    }

    public final SConnection getConnection() {
        return this.iConnection;
    }

    public final void setConnection(SConnection connection) {
        this.iConnection = connection;
    }

    public final SDSLock tryLock(SDSLockParameter lp) throws SQLException {
        try {
            if (lp.getConnection() == null) {
                lp.setConnection(this.getConnection());
            }
            SDSLock lck = SDSLock.tryLock(this, this.iUserId, lp);
            SDSLockEvent evt = new SDSLockEvent(this.getConnection(), lck, SDSLockEvent.Mode.APPLIED);
            this.fireSDSEvent(evt);
            return lck;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Duplicate")) {
                int otherLockId = this.getLockedId(lp);
                SDSLock lck = SDSLock.getLockFromDB(this, otherLockId, this.iUserId, lp);
                SDSLockEvent evt = new SDSLockEvent(this.getConnection(), lck, SDSLockEvent.Mode.ALREADY_LOCKED);
                this.fireSDSEvent(evt);
                return null;
            }
            throw e;
        }
    }

    public String getUserNameFromId(int id) {
        String user;
        block8: {
            String sql = "SELECT UserName,NodeName FROM " + SDSLockSettings.getLoginTableName() + " WHERE UserID='" + id + "'";
            SStatement stmt = null;
            try {
                try {
                    stmt = this.getConnection().getStatement();
                    ResultSet rs = stmt.executeQuery(sql);
                    if (rs.next()) {
                        user = String.valueOf(rs.getString(1)) + "." + rs.getString(2);
                        break block8;
                    }
                    user = "<UNKNOWN>";
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    user = "<UNKNOWN>";
                    if (stmt != null) {
                        this.getConnection().releaseStatement(stmt);
                    }
                }
            }
            finally {
                if (stmt != null) {
                    this.getConnection().releaseStatement(stmt);
                }
            }
        }
        return user;
    }

    public SDSLock showStandardLockedDialog(Window parent, SDSLock lock) {
        SDSLockDialog lockDialog = new SDSLockDialog(parent);
        lockDialog.setLock(lock);
        lockDialog.setModal(true);
        lockDialog.setVisible(true);
        return lockDialog.getAppliedLock();
    }

    public SDSLock showStandardLockedDialog(Window parent, SDSLockParameter lp) throws SQLException {
        SDSLock lck = this.tryLock(lp);
        while (lck == null) {
            try {
                int otherLockId = this.getLockedId(lp);
                lck = SDSLock.getLockFromDB(this, otherLockId, this.iUserId, lp);
            }
            catch (SQLException e) {
                if (!e.getMessage().startsWith("No Lock found")) {
                    throw e;
                }
                lck = this.tryLock(lp);
            }
        }
        if (lck.getMode() == SDSLock.Mode.OTHER) {
            SDSLockDialog lockDialog = new SDSLockDialog(parent);
            lockDialog.setLock(lck);
            lockDialog.setModal(true);
            lockDialog.setVisible(true);
            lck = lockDialog.getAppliedLock();
        }
        return lck;
    }

    /*
     * Unable to fully structure code
     */
    public final SDSLock tryLock(SDSLockParameter lp, long timeout, int delay) throws SQLException {
        block11: {
            if (delay <= 0) {
                throw new AssertionError((Object)"Delay should not be less or equal 0");
            }
            if (timeout != -1L) ** GOTO lbl26
            lck = null;
            while (lck == null) {
                try {
                    return this.tryLock(lp);
                }
                catch (SQLException e) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException var7_8) {
                        // empty catch block
                    }
                }
            }
            break block11;
lbl-1000:
            // 1 sources

            {
                try {
                    return this.tryLock(lp);
                }
                catch (SQLException e) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException var6_7) {
                        // empty catch block
                    }
                    if ((timeout -= (long)delay) > 0L) continue;
                    throw e;
                }
lbl26:
                // 2 sources

                ** while (timeout > 0L)
            }
        }
        return null;
    }

    public final SDSLock tryLock(SDSLockParameter lp, long timeout) throws SQLException {
        if (timeout > 1000L || timeout == -1L) {
            return this.tryLock(lp, timeout, 1000);
        }
        if (timeout >= 2L) {
            return this.tryLock(lp, timeout, (int)(timeout / 2L));
        }
        return this.tryLock(lp, timeout, 1);
    }

    public final void tryThreadedLock(final SDSLockParameter lp, final long timeout, final int delay) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    SDSLockManager.this.tryLock(lp, timeout, delay);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    public final int getLockedId(String database, String table, String key, String program) {
        SStatement stmt = null;
        String sql = "SELECT ID FROM " + SDSLockSettings.getResourceTableName() + " WHERE DB='" + database + "'" + " AND TB='" + table + "'" + " AND KY='" + key + "'" + " AND PRG='" + program + "'";
        try {
            stmt = this.getConnection().getStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
        }
        return -1;
    }

    public final int getLockedId(SDSLockParameter parm) {
        return this.getLockedId(parm.getDatabase(), parm.getTable(), parm.getKey(), parm.getProgram());
    }

    public boolean isLocked(String database, String table, String key, String program) {
        return this.getLockedId(database, table, key, program) != -1;
    }

    public boolean isLocked(SDSLockParameter parm) {
        return this.isLocked(parm.getDatabase(), parm.getTable(), parm.getKey(), parm.getProgram());
    }

    public final int getLockedUserId(int lockId) {
        SStatement stmt = null;
        String sql = "SELECT UserID FROM " + SDSLockSettings.getResourceTableName() + " WHERE ID='" + lockId + "'";
        try {
            stmt = this.getConnection().getStatement();
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (stmt != null) {
                this.getConnection().releaseStatement(stmt);
            }
        }
        return -1;
    }

    public final void unlock(SDSLock lock) throws SQLException {
        lock.unlock();
    }

    public final void unlockNoEx(SDSLock lock) {
        lock.unlockNoEx();
    }

    public void addEventListener(SDSLockEventListener l, SDSLockParameter interest) {
        this.iListeners.add(SDSLockEventListener.class, l, interest);
    }

    public void addEventListener(SDSLockEventListener l) {
        this.iListeners.add(SDSLockEventListener.class, l);
    }

    public void removeEventListener(SDSLockEventListener l) {
        this.iListeners.remove(SDSLockEventListener.class, l);
    }

    public void removeEventListener(SDSLockEventListener l, SDSLockParameter interest) {
        this.iListeners.remove(SDSLockEventListener.class, l, interest);
    }

    public void fireSDSEvent(SDSLockEvent evt) {
        if (SwingUtilities.isEventDispatchThread()) {
            Object[] listeners = this.iListeners.getListenerList();
            int i = listeners.length - 3;
            while (i >= 0) {
                if (listeners[i] == SDSLockEventListener.class && (listeners[i + 1] == null || listeners[i + 1] == evt.getLock().getLockParameter())) {
                    ((SDSLockEventListener)listeners[i + 2]).lockEventDispatched(evt);
                }
                i -= 3;
            }
        } else {
            final SDSLockEvent fevt = evt;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SDSLockManager.this.fireSDSEvent(fevt);
                }
            });
        }
    }
}

