/*
 * Decompiled with CFR 0.152.
 */
package sql.lock;

import application.SApplication;
import sql.SConnection;

public class SDSLockParameter
implements Comparable<SDSLockParameter> {
    private SConnection iConnection;
    private final String iDatabase;
    private final String iTable;
    private final String iKey;
    private final String iProgram;
    private final Type iType;
    private static Type gDefaultType = Type.LONG_TIME;
    private static String gDefaultDatabase = null;

    public SDSLockParameter(SConnection connection, Type type, String database, String table, String key, String program) {
        this.iType = type;
        this.iConnection = connection != null ? connection : SApplication.getDefaultConnection();
        this.iDatabase = database;
        this.iTable = table;
        this.iKey = key;
        this.iProgram = program;
        if (this.iConnection == null) {
            throw new RuntimeException("Connection should not be null");
        }
    }

    private static SConnection getConnection(SConnection con) {
        if (con != null) {
            return con;
        }
        return SApplication.getDefaultConnection();
    }

    public SDSLockParameter(SConnection connection, Type type, String database, String table, String key) {
        this(SDSLockParameter.getConnection(connection), type, database, table, key, "");
    }

    public SDSLockParameter(SConnection connection, Type type, String table, String key) {
        this(SDSLockParameter.getConnection(connection), type, SDSLockParameter.getConnection(connection).getDatabase(), table, key, "");
    }

    public SDSLockParameter(SConnection connection, Type type, String key) {
        this(SDSLockParameter.getConnection(connection), type, SDSLockParameter.getConnection(connection).getDatabase(), "<GLOBAL>", key, "");
    }

    public SDSLockParameter(SConnection connection, String database, String table, String key) {
        this(SDSLockParameter.getConnection(connection), SDSLockParameter.getDefaultType(), database, table, key, "");
    }

    public SDSLockParameter(SConnection connection, String table, String key) {
        this(SDSLockParameter.getConnection(connection), SDSLockParameter.getDefaultType(), SDSLockParameter.getConnection(connection).getDatabase(), table, key, "");
    }

    public SDSLockParameter(SConnection connection, String key) {
        this(connection, SDSLockParameter.getDefaultType(), SDSLockParameter.getConnection(connection).getDatabase(), "<GLOBAL>", key, "");
    }

    public SDSLockParameter(SDSLockParameter parm, String key) {
        this(parm, parm.getConnection(), key);
    }

    public SDSLockParameter(SDSLockParameter parm, SConnection con, String key) {
        this(con, parm.getType(), parm.getDatabase(), parm.getTable(), key, parm.getProgram());
    }

    public SConnection getConnection() {
        if (this.iConnection == null) {
            return SApplication.getDefaultConnection();
        }
        return this.iConnection;
    }

    public void setConnection(SConnection connection) {
        this.iConnection = connection;
    }

    public String getDatabase() {
        return this.iDatabase;
    }

    public String getTable() {
        return this.iTable;
    }

    public String getKey() {
        return this.iKey;
    }

    public String getProgram() {
        return this.iProgram;
    }

    public Type getType() {
        return this.iType;
    }

    public static Type getDefaultType() {
        return gDefaultType;
    }

    public static void setDefaultType(Type defaultType) {
        gDefaultType = defaultType;
    }

    public String getDefaultDatabase() {
        if (gDefaultDatabase == null || gDefaultDatabase.length() == 0) {
            return this.getConnection().getDatabase();
        }
        return gDefaultDatabase;
    }

    public static void setDefaultDatabase(String defaultDatabase) {
        gDefaultDatabase = defaultDatabase;
    }

    public static Type intToLockType(int i) {
        if (i == Type.LONG_TIME.ordinal()) {
            return Type.LONG_TIME;
        }
        if (i == Type.SHORT_TIME.ordinal()) {
            return Type.SHORT_TIME;
        }
        return null;
    }

    public static int lockTypeToInt(Type type) {
        return type.ordinal();
    }

    @Override
    public int compareTo(SDSLockParameter o) {
        if (o == null) {
            return -1;
        }
        if (o instanceof SDSLockParameter) {
            SDSLockParameter op = o;
            int c = op.getDatabase().compareTo(this.getDatabase());
            if (c == 0) {
                c = op.getTable().compareTo(this.getTable());
            }
            if (c == 0) {
                c = op.getKey().compareTo(this.getKey());
            }
            return c;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof SDSLockParameter) {
            SDSLockParameter p = (SDSLockParameter)obj;
            return p.getDatabase().equals(this.getDatabase()) && p.getTable().equals(this.getTable()) && p.getKey().equals(this.getKey());
        }
        return super.equals(obj);
    }

    static enum Type {
        LONG_TIME,
        SHORT_TIME;

    }
}

