/*
 * Decompiled with CFR 0.152.
 */
package sql.lock;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import sql.SConnection;
import sql.SSQLTable;
import sql.SSQLUtils;

public final class SDSLockSettings {
    private static int gMsgLoopDuration = 30000;
    private static int gMaxVtsDuration = 120;
    private static String gLoginTableName = "LCK_LOGIN";
    private static String gMsgTableName = "LCK_MSG";
    private static String gResourceTableName = "LCK_RESOURCE";
    private static String gSettingsTableName = "LCK_SETTINGS";
    private static String gDbName = "LOCK";
    private static String gCurVersion = "V0.0.6";

    private static final boolean checkTable(SConnection con, String table, String fname) {
        URL url = SDSLockSettings.class.getResource(fname);
        String version = SSQLUtils.getTableVersionFromSqlScript(url, table);
        boolean rc = false;
        try {
            if (SSQLTable.readCommentFromConnection(table, con).startsWith(version)) {
                rc = true;
            }
        }
        catch (SQLException e) {
            rc = false;
        }
        if (!rc) {
            try {
                con.executeSqlScript(url);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return rc;
    }

    public static final void checkTables(SConnection con) {
        String sqlfile = "lock.sql";
        SDSLockSettings.checkTable(con, SDSLockSettings.getLoginTableName(), sqlfile);
        SDSLockSettings.checkTable(con, SDSLockSettings.getMsgTableName(), sqlfile);
        SDSLockSettings.checkTable(con, SDSLockSettings.getResourceTableName(), sqlfile);
        SDSLockSettings.checkTable(con, SDSLockSettings.getSettingsTableName(), sqlfile);
    }

    public static final void cleanupTables(SConnection con) {
        String sql = "DELETE FROM " + SDSLockSettings.getLoginTableName() + " WHERE SYSDATE()-VTS>" + ((Object)SDSLockSettings.getMaxVtsDuration()).toString();
        con.executeSqlNoEx(sql);
        sql = "DELETE FROM " + SDSLockSettings.getResourceTableName() + " WHERE UserID NOT IN " + "(SELECT UserID FROM " + SDSLockSettings.getLoginTableName() + ")";
        con.executeSqlNoEx(sql);
        sql = "DELETE FROM " + SDSLockSettings.getMsgTableName() + " WHERE UserID NOT IN " + "(SELECT UserID FROM " + SDSLockSettings.getLoginTableName() + ")";
        con.executeSqlNoEx(sql);
    }

    public static final void setSetting(SConnection con, String section, String entry, String value) {
        if (con != null) {
            try {
                String sql = "INSERT INTO " + SDSLockSettings.getSettingsTableName() + " (SECTION,ENTRY,VALUE) VALUES ('" + section + "','" + entry + "','" + value + "')";
                con.executeSql(sql);
            }
            catch (SQLException e) {
                String sql = "UPDATE " + SDSLockSettings.getSettingsTableName() + " SET VALUE='" + value + "' WHERE SECTION='" + section + "' AND ENTRY='" + entry + "'";
                try {
                    con.executeSql(sql);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public static final String getLoginTableName() {
        return gLoginTableName;
    }

    public static final void setLoginTableName(String loginTableName) {
        gLoginTableName = loginTableName;
    }

    public static final String getMsgTableName() {
        return gMsgTableName;
    }

    public static final void setMsgTableName(String msgTableName) {
        gMsgTableName = msgTableName;
    }

    public static final String getResourceTableName() {
        return gResourceTableName;
    }

    public static final void setResourceTableName(String resourceTableName) {
        gResourceTableName = resourceTableName;
    }

    public static String getSettingsTableName() {
        return gSettingsTableName;
    }

    public static void setSettingsTableName(String settingsTableName) {
        gSettingsTableName = settingsTableName;
    }

    public static final String getDbName() {
        return gDbName;
    }

    public static final void setDbName(String dbName) {
        gDbName = dbName;
    }

    public static final int getMsgLoopDuration() {
        return gMsgLoopDuration;
    }

    public static final void setMsgLoopDuration(int msgLoopDuration, SConnection con) {
        gMsgLoopDuration = msgLoopDuration;
        SDSLockSettings.setSetting(con, "Common", "MSG_LOOP_DURATION", Integer.toString(msgLoopDuration));
    }

    public static final int getMaxVtsDuration() {
        return gMaxVtsDuration;
    }

    public static final void setMaxVtsDuration(int maxVtsDuration, SConnection con) {
        gMaxVtsDuration = maxVtsDuration;
        SDSLockSettings.setSetting(con, "Common", "MAX_VTS_DURATION", Integer.toString(maxVtsDuration));
    }

    public static final String getCurVersion() {
        return gCurVersion;
    }

    public static final String getCurVersionQ() {
        return "'" + SDSLockSettings.getCurVersion() + "'";
    }
}

