/*
 * Decompiled with CFR 0.152.
 */
package sql.lock;

import awtext.SEventInterestListenerList;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import sql.SConnection;
import sql.SStatement;
import sql.lock.SDSLockSettings;
import sql.lock.SDSMessageEvent;
import sql.lock.SDSMessageEventListener;
import sql.lock.SDSMessageView;

public class SDSMessageSnooper
implements SDSMessageEventListener {
    private SConnection iConnection;
    private long iUserId = 0L;
    private int iRunFlag = 0;
    private Thread iSnooperThread;
    public static final int TEXTMESSAGE = 1;
    public static final int LIFECHECK = 2;
    public static final int DISCONNECT_DB = 3;
    public static final int UNLOCKREQUEST = 4;
    private SEventInterestListenerList iListeners = new SEventInterestListenerList(true);

    public SDSMessageSnooper(SConnection con, long userId) {
        this.setConnection(con);
        this.iUserId = userId;
        this.addEventListener(this);
        this.iSnooperThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SDSMessageSnooper.this.messageLoop();
            }
        });
        this.iSnooperThread.setDaemon(true);
        this.iSnooperThread.setName("SDSMessageSnooper");
        this.iSnooperThread.start();
    }

    private final void messageLoop() {
        while (this.iRunFlag == 0) {
            try {
                this.checkForNewMessages();
                Thread.sleep(SDSLockSettings.getMsgLoopDuration());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void updateMyVts() {
        String sql = "UPDATE " + SDSLockSettings.getLoginTableName() + " SET VTS=SYSDATE()" + " WHERE UserID=" + this.iUserId;
        this.getConnection().executeSqlNoEx(sql);
    }

    private final void checkForNewMessages() {
        SStatement stmt = null;
        this.updateMyVts();
        String sql = "SELECT ID FROM " + SDSLockSettings.getMsgTableName() + " " + "WHERE ID_UserTo=0 OR (ID_UserTo=" + this.iUserId + " AND ATS IS NULL)";
        try {
            try {
                stmt = this.getConnection().getStatement();
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int id = rs.getInt(1);
                    SDSMessageEvent evt = new SDSMessageEvent(this.getConnection(), id);
                    this.fireSDSEvent(evt);
                }
            }
            catch (SQLException e) {
                sql = e.getMessage();
                this.getConnection().releaseStatement(stmt);
            }
        }
        finally {
            this.getConnection().releaseStatement(stmt);
        }
    }

    public SConnection getConnection() {
        return this.iConnection;
    }

    public void setConnection(SConnection connection) {
        this.iConnection = connection;
    }

    public void addEventListener(SDSMessageEventListener l) {
        this.iListeners.add(SDSMessageEventListener.class, l);
    }

    public void removeEventListener(SDSMessageEventListener l) {
        this.iListeners.remove(SDSMessageEventListener.class, l);
    }

    public void fireSDSEvent(SDSMessageEvent evt) {
        if (SwingUtilities.isEventDispatchThread()) {
            Object[] listeners = this.iListeners.getListenerList();
            int i = listeners.length - 3;
            while (i >= 0) {
                if (listeners[i] == SDSMessageEventListener.class) {
                    ((SDSMessageEventListener)listeners[i + 1]).messageEventDispatched(evt);
                }
                i -= 3;
            }
        } else {
            final SDSMessageEvent fevt = evt;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SDSMessageSnooper.this.fireSDSEvent(fevt);
                }
            });
        }
    }

    private void showMessage(SDSMessageEvent evt) {
        SDSMessageView mw = new SDSMessageView();
        mw.getTaMessage().setText(evt.getParam2());
        mw.setVisible(true);
    }

    @Override
    public void messageEventDispatched(SDSMessageEvent evt) {
        switch (evt.getType()) {
            case 2: {
                this.updateMyVts();
                evt.setMessageAcknowledged(true);
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                this.showMessage(evt);
                evt.setMessageAcknowledged(true);
                break;
            }
            case 4: {
                break;
            }
        }
    }
}

