/*
 * Decompiled with CFR 0.152.
 */
package swiext;

import awtext.SRefreshEvent;
import awtext.SRefreshListener;
import images.SImagesAndIcons;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.Timer;

public class SAnimatedComponent
extends JComponent
implements SRefreshListener {
    private MediaTracker iMediaTracker = null;
    private Image[] iImages = new BufferedImage[0];
    private int iAnimationDelay = 50;
    private Timer iTimer;
    private int iImageNum = -1;
    private Image iBufferedImage = null;

    public Image[] getImages() {
        return this.iImages;
    }

    public void setImages(Image[] images) {
        this.iImages = images;
    }

    private void initialize() {
        this.iMediaTracker = new MediaTracker(this);
        if (this.iImages.length == 0) {
            this.iImages = SImagesAndIcons.getBusyAnimationImages(this.iMediaTracker);
        }
    }

    private void initialize(Image[] images) {
        this.iImages = images;
        this.initialize();
    }

    public SAnimatedComponent() {
        this.initialize();
    }

    public SAnimatedComponent(Image[] images) {
        this.initialize(images);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintNextImage() {
        SAnimatedComponent sAnimatedComponent = this;
        synchronized (sAnimatedComponent) {
            ++this.iImageNum;
            if (this.iImageNum >= this.iImages.length) {
                this.iImageNum = 0;
            }
            this.repaint();
        }
    }

    @Override
    public void dispatchRefreshEvent(SRefreshEvent e) {
        switch (e.getMode()) {
            case 0: {
                this.startAnimation();
                break;
            }
            case 1: {
                this.stopAnimation();
            }
        }
    }

    public void startAnimation() {
        if (this.iTimer == null) {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SAnimatedComponent.this.paintNextImage();
                }
            };
            this.iTimer = new Timer(this.getAnimationDelay(), al);
            this.iTimer.setCoalesce(true);
            this.iTimer.setRepeats(true);
            this.iTimer.start();
        }
    }

    public void stopAnimation() {
        if (this.iTimer != null) {
            this.iImageNum = -1;
            if (this.iTimer != null) {
                this.iTimer.stop();
            }
            this.iTimer = null;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.iBufferedImage == null) {
            this.iBufferedImage = this.createImage(this.getWidth(), this.getHeight());
        }
        if (this.iImageNum >= 0 && this.iImages[this.iImageNum] != null) {
            Graphics bg = this.iBufferedImage.getGraphics();
            bg.clearRect(0, 0, this.getWidth(), this.getHeight());
            bg.drawImage(this.iImages[this.iImageNum], 2, 2, this.getWidth() - 4, this.getHeight() - 4, this);
            g.drawImage(this.iBufferedImage, 0, 0, this);
        } else {
            super.paintComponent(g);
        }
    }

    public int getAnimationDelay() {
        return this.iAnimationDelay;
    }

    public void setAnimationDelay(int animationDelay) {
        if (this.iAnimationDelay != animationDelay) {
            this.iAnimationDelay = animationDelay;
            if (this.iTimer != null) {
                this.iTimer.setDelay(animationDelay);
            }
        }
    }
}

