/*
 * Decompiled with CFR 0.152.
 */
package swiext;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFormattedTextField;
import swiext.SConstants;
import swiext._SDefaultFormatterFactory;
import swiext._SFormattedDocument;

public class SFormattedTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 1L;
    private int iDataType = 0;

    public int getDataType() {
        return this.iDataType;
    }

    void initializeType(int type) {
        this.setFormatterFactory(_SDefaultFormatterFactory.getInstance(type));
    }

    @Override
    protected void setFormatter(JFormattedTextField.AbstractFormatter format) {
        super.setFormatter(format);
    }

    @Override
    public void setFormatterFactory(JFormattedTextField.AbstractFormatterFactory tf) {
        if (tf instanceof _SDefaultFormatterFactory) {
            super.setFormatterFactory(tf);
        }
    }

    public void setType(int type) {
        this.iDataType = type;
        this.initializeType(type);
    }

    void setValuedType(int type) {
        if (this.iDataType == 0) {
            this.setType(type);
        }
    }

    @Override
    public void setValue(Object value) {
        this.setValuedType(SConstants.classToTypeNumber(value));
        super.setValue(value);
    }

    @Override
    public Object getValue() {
        Object o = super.getValue();
        if (o instanceof Date) {
            switch (this.iDataType) {
                case 22: {
                    if (o instanceof Time) break;
                    o = new Time(((Date)o).getTime());
                    break;
                }
                case 23: {
                    if (o instanceof Timestamp) break;
                    o = new Timestamp(((Date)o).getTime());
                    break;
                }
                case 24: {
                    if (o instanceof Calendar) break;
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)o);
                    o = c;
                }
            }
        }
        return o;
    }

    protected void initialize() {
        this.setDocument(new _SFormattedDocument(this));
    }

    public SFormattedTextField(int dataType) {
        this.initialize();
        this.setType(dataType);
    }

    public SFormattedTextField(int dataType, Object value) {
        this.initialize();
        this.setType(dataType);
        this.setValue(value);
    }
}

