/*
 * Decompiled with CFR 0.152.
 */
package swiext;

import awtext.SAbstractWindowOCCHandler;
import awtext.SWindowEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import prefs.SPreferences;
import prefs.SPrefs;

public class SWindowPreferences
extends SAbstractWindowOCCHandler {
    private SPreferences iPrefs = null;
    private Window iWin = null;
    static Point iLastBestPosition = new Point(0, 0);
    private boolean iPositionSet = false;

    public SPreferences getPreferences() {
        return this.iPrefs;
    }

    @Override
    public void mainWindowClosing(SWindowEvent evt) {
        this.saveWindowBoundsToPrefs();
    }

    @Override
    public void mainWindowClosed(SWindowEvent evt) {
        this.saveWindowBoundsToPrefs();
    }

    @Override
    public void mainWindowOpened(SWindowEvent evt) {
        this.setWindowBoundsFromPrefs();
    }

    public boolean isPositionSet() {
        return this.iPositionSet;
    }

    private final void _initialize(Window win) {
        this.iPrefs = SPrefs.getDefaultUserPreferences();
        this.iWin = win;
        this.setWindowBoundsFromPrefs();
    }

    public SWindowPreferences(Window win) {
        super(win);
        this._initialize(win);
        this.iPositionSet = false;
    }

    public static final Point getBestNextWindowPosition(Window win) {
        Window[] wl = Window.getWindows();
        if (wl == null || wl.length < 1) {
            return iLastBestPosition;
        }
        Rectangle wr = win != null ? win.getBounds() : wl[0].getBounds();
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        SWindowPreferences.iLastBestPosition.x += 15;
        SWindowPreferences.iLastBestPosition.y += 15;
        if (SWindowPreferences.iLastBestPosition.x + wr.width > sd.width) {
            SWindowPreferences.iLastBestPosition.x = 0;
        }
        if (SWindowPreferences.iLastBestPosition.y + wr.height > sd.height) {
            SWindowPreferences.iLastBestPosition.y = 0;
        }
        return iLastBestPosition;
    }

    public static final Point getCenteredWindowPosition(Window win) {
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wd = win.getSize();
        return new Point((sd.width - wd.width) / 2, (sd.height - wd.height) / 2);
    }

    private static final String getAppNameForPrefs(Component w) {
        String n = w.getClass().getCanonicalName();
        if (w.getName() != null) {
            n = String.valueOf(n) + "." + w.getName();
        }
        return n;
    }

    public static final String suggestSectionNameForComponent(Component w) {
        return SWindowPreferences.getAppNameForPrefs(w);
    }

    public static final Rectangle getWindowBoundsFromPrefs(Window win, SPreferences prefs) {
        Rectangle rec = prefs.tryGetRectangle("WindowRectangle", null, SWindowPreferences.getAppNameForPrefs(win));
        if (rec != null) {
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            if (rec.x < 0) {
                rec.x = 0;
            }
            if (rec.y < 0) {
                rec.y = 0;
            }
            if (rec.x + rec.width > sd.width) {
                rec.x = sd.width - rec.width;
            }
            if (rec.y + rec.height > sd.height) {
                rec.y = sd.height - rec.height;
            }
        }
        return rec;
    }

    public final Rectangle getWindowBoundsFromPrefs(Window win) {
        return SWindowPreferences.getWindowBoundsFromPrefs(win, this.iPrefs);
    }

    public final Rectangle getWindowBoundsFromPrefs() {
        return this.getWindowBoundsFromPrefs(this.iWin);
    }

    public static final void saveWindowBoundsToPrefs(Window win, SPreferences prefs) {
        if (win instanceof Frame && ((Frame)win).getExtendedState() != 0) {
            return;
        }
        prefs.tryPut("WindowRectangle", win.getBounds(), SWindowPreferences.getAppNameForPrefs(win));
    }

    public final void saveWindowBoundsToPrefs(Window win) {
        SWindowPreferences.saveWindowBoundsToPrefs(win, this.iPrefs);
    }

    public final void saveWindowBoundsToPrefs() {
        this.saveWindowBoundsToPrefs(this.iWin);
    }

    public static final void setWindowBoundsFromPrefs(Window win, SPreferences prefs) {
        Rectangle r = SWindowPreferences.getWindowBoundsFromPrefs(win, prefs);
        if (r != null) {
            win.setBounds(win.getGraphicsConfiguration().getBounds().intersection(r));
        } else {
            Point p = SWindowPreferences.getBestNextWindowPosition(win);
            if (p != null) {
                win.setLocation(p);
            }
        }
    }

    public final void setWindowBoundsFromPrefs(Window win) {
        SWindowPreferences.setWindowBoundsFromPrefs(win, this.iPrefs);
        this.iPositionSet = true;
    }

    public final void setWindowBoundsFromPrefs() {
        this.setWindowBoundsFromPrefs(this.iWin);
    }
}

