/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import awtext.SRefreshEvent;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.DefaultRowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sql.SConnection;
import sql.SStatement;
import swiext.table.SDefaultTableModel;
import swiext.table.SHashTableModel;
import swiext.table.SScrollPaneTable;

public class SDSTable
extends SScrollPaneTable {
    private static final long serialVersionUID = 1L;
    private String iSQLSelect = "";
    private String iSQLFrom = "";
    private String iSQLWhere = "";
    private String iSQLAdditions = "";
    private String iSQLResultCountSelect = "";
    private String iSQLUpdateCheck = "";
    private SConnection iConnection = null;
    private AbstractMap<String, String> iHeaderTitles = new ConcurrentSkipListMap<String, String>();
    private int iLastResultCount = -1;

    public void setHeaderTitleWhenNull(TableColumn aCol, String aTitle) {
        if (this.getHeaderTitle(aCol) == null) {
            this.setHeaderTitle(aCol, aTitle);
        }
    }

    public void setHeaderTitle(TableColumn aCol, String aTitle) {
        this.iHeaderTitles.put(aCol.toString(), aTitle);
        aCol.setHeaderValue(aTitle);
    }

    public String getHeaderTitle(TableColumn aCol) {
        return this.iHeaderTitles.get(aCol.toString());
    }

    public String getHeaderTitle(TableColumn aCol, String defVal) {
        String ht = this.getHeaderTitle(aCol);
        if (ht != null) {
            return ht;
        }
        return defVal;
    }

    @Override
    public boolean isCurrent() {
        boolean rc;
        block6: {
            rc = true;
            SConnection con = this.getConnection();
            SStatement stmt = null;
            try {
                try {
                    int lastResult;
                    stmt = con.getStatement(1004, 1007);
                    ResultSet rs = stmt.executeQuery(this.getSQLUpdateCheck());
                    if (rs.next() && (lastResult = rs.getInt(1)) != this.iLastResultCount) {
                        rc = false;
                        this.iLastResultCount = lastResult;
                    }
                }
                catch (SQLException sQLException) {
                    con.releaseStatement(stmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                con.releaseStatement(stmt);
                throw throwable;
            }
            con.releaseStatement(stmt);
        }
        return rc;
    }

    private void refreshColumnHeaders() {
        this.refreshColumnHeaders(this.getSQLNullResult());
    }

    private void refreshColumnHeaders(String sql) {
        Connection con = this.getConnection().getConnection();
        PreparedStatement stmt = null;
        ResultSetMetaData rsm = null;
        try {
            stmt = con.prepareStatement(sql, 1004, 1007);
            rsm = stmt.getMetaData();
            this.refreshColumnHeaders(rsm);
        }
        catch (SQLException e) {
            System.out.println("Unable to fetch column headers with statement " + sql);
            e.printStackTrace();
        }
    }

    private void refreshColumnHeaders(ResultSetMetaData rsm) {
        try {
            this.getModel().setColumnCount(rsm.getColumnCount());
            TableColumnModel tcm = this.getColumnModel();
            ((SDefaultTableModel)((DefaultRowSorter)this.getRowSorter()).getModel()).setColumnCount(rsm.getColumnCount());
            int i = 0;
            while (i < rsm.getColumnCount()) {
                Class cls = null;
                try {
                    cls = Class.forName(rsm.getColumnClassName(i + 1));
                }
                catch (ClassNotFoundException e) {
                    cls = String.class;
                }
                TableColumn tc = tcm.getColumn(i);
                this.setHeaderTitleWhenNull(tc, rsm.getColumnLabel(i + 1));
                this.getModel().setColumnClass(i, cls);
                ++i;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private String readStringFromRs(ResultSet rs, int col) {
        String s = "";
        try {
            InputStream is = rs.getAsciiStream(col);
            try {
                int ch = is.read();
                while (ch >= 0) {
                    s = String.valueOf(s) + (char)ch;
                    ch = is.read();
                }
            }
            catch (IOException iOException) {}
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return s;
    }

    private void refreshTableFromSql(String sql, String getResultCountSql) {
        SRefreshEvent evt;
        SStatement stmt;
        SConnection con;
        block26: {
            ResultSet rs;
            con = this.getConnection();
            stmt = null;
            evt = null;
            boolean soe = this.isSortingEnabled();
            evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.SET_SORTING_ENABLED, false, null);
            this.fireRefreshEvent(evt);
            evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.CLEAR_TABLE_MODEL);
            this.fireRefreshEvent(evt);
            evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.INVALIDATE_ROW_HEADER);
            this.fireRefreshEvent(evt);
            int mc = 0;
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                stmt = con.getStatement(1004, 1007);
                rs = stmt.executeQuery(getResultCountSql);
                if (rs.next()) {
                    mc = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                mc = Integer.MAX_VALUE;
            }
            try {
                try {
                    int r = 0;
                    this.fireRefreshEvent(new SRefreshEvent((Object)this, 2, r, mc));
                    if (stmt == null) {
                        stmt = con.getStatement(1004, 1007);
                    }
                    rs = stmt.executeQuery(sql);
                    ResultSetMetaData rsm = rs.getMetaData();
                    int rc = 0;
                    while (rs.next()) {
                        ArrayList<Object> lst = new ArrayList<Object>();
                        int c = 0;
                        while (c < rsm.getColumnCount()) {
                            try {
                                lst.add(rs.getObject(c + 1));
                            }
                            catch (SQLException e) {
                                try {
                                    int ct = rsm.getColumnType(c + 1);
                                    if (ct == 93) {
                                        String s = this.readStringFromRs(rs, c + 1);
                                        if (s.equals("0000-00-00 00:00:00")) {
                                            lst.add(null);
                                        } else {
                                            lst.add(s);
                                        }
                                    } else {
                                        lst.add(rs.getString(c + 1));
                                    }
                                }
                                catch (SQLException ei) {
                                    lst.add(null);
                                }
                            }
                            ++c;
                        }
                        evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.SET_ROW_VALUES, (Object)r, lst);
                        this.fireRefreshEvent(evt);
                        if (++rc > 1) {
                            try {
                                this.fireRefreshEvent(new SRefreshEvent((Object)this, 2, r, mc));
                                if (!SwingUtilities.isEventDispatchThread()) {
                                    Thread.sleep(1L);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            rc = 0;
                        }
                        ++r;
                    }
                    this.iLastResultCount = r;
                    evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.INVALIDATE_ROW_HEADER);
                    this.fireRefreshEvent(evt);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.SET_SORTING_ENABLED, soe);
                    this.fireRefreshEvent(evt);
                    break block26;
                }
            }
            catch (Throwable throwable) {
                evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.SET_SORTING_ENABLED, soe);
                this.fireRefreshEvent(evt);
                throw throwable;
            }
            evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.SET_SORTING_ENABLED, soe);
            this.fireRefreshEvent(evt);
        }
        con.releaseStatement(stmt);
        evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.REVALIDATE);
        this.fireRefreshEvent(evt);
        evt = new SRefreshEvent((Object)this, SRefreshEvent.EventCmd.REPAINT);
        this.fireRefreshEvent(evt);
    }

    private static String toNotNullString(String str) {
        return str == null ? "" : str;
    }

    public void setSQLUpdateCheck(String updateCheck) {
        this.iSQLUpdateCheck = updateCheck;
    }

    public void setSQL(String select, String from, String where, String additions) {
        this.iSQLSelect = select == null || select.length() == 0 ? "SELECT *" : select;
        this.iSQLFrom = SDSTable.toNotNullString(from);
        this.iSQLWhere = SDSTable.toNotNullString(where);
        this.iSQLAdditions = SDSTable.toNotNullString(additions);
        this.iSQLResultCountSelect = "";
        this.iSQLResultCountSelect = this.getSQLResultCountSelect();
        this.refreshColumnHeaders();
    }

    public void setSQL(String select, String from, String where) {
        this.setSQL(select, from, where, "");
    }

    public void setSQL(String select, String from) {
        this.setSQL(select, from, "", "");
    }

    public void setSQL(String from) {
        this.setSQL("", from, "", "");
    }

    public String getSQLUpdate() {
        return String.valueOf(this.getSQLSelect()) + " " + this.getSQLFrom() + " " + this.getSQLWhere() + " " + this.getSQLAdditions();
    }

    public String getSQLUpdateCheck() {
        if (this.iSQLUpdateCheck.length() <= 0) {
            return "SELECT COUNT(*) " + this.getSQLFrom() + " " + this.getSQLWhere() + " " + this.getSQLAdditions();
        }
        return this.iSQLUpdateCheck;
    }

    public String getSQLNullResult() {
        String where = this.getSQLWhere();
        where = where.length() == 0 ? " WHERE 1=2" : String.valueOf(where) + " AND 1=2";
        return String.valueOf(this.getSQLSelect()) + " " + this.getSQLFrom() + " " + where + " " + this.getSQLAdditions();
    }

    public String getSQLSelect() {
        return this.iSQLSelect;
    }

    public String getSQLFrom() {
        return this.iSQLFrom;
    }

    public String getSQLWhere() {
        return this.iSQLWhere;
    }

    public String getSQLAdditions() {
        return this.iSQLAdditions;
    }

    public String getSQLResultCountSelect() {
        if (this.iSQLResultCountSelect == null || "".equals(this.iSQLResultCountSelect)) {
            String sql = "SELECT COUNT(*) " + this.getSQLFrom() + " " + this.getSQLWhere() + " " + this.getSQLAdditions();
            this.setSQLResultCountSelect(sql);
        }
        return this.iSQLResultCountSelect;
    }

    public void setSQLResultCountSelect(String resultCountSelect) {
        this.iSQLResultCountSelect = resultCountSelect;
    }

    public SDSTable() {
        this.initialize();
    }

    private void initialize() {
        this.setEditable(false);
        this.setAutoResizeMode(0);
        this.setModel(new SHashTableModel());
        this.setColumnModel(new DefaultTableColumnModel());
    }

    public SConnection getConnection() {
        if (this.iConnection == null) {
            return SConnection.getApplicationDefault();
        }
        return this.iConnection;
    }

    public void setConnection(SConnection connection) {
        this.iConnection = connection;
    }

    @Override
    public void refresh() {
        this.fireRefreshEvent(new SRefreshEvent((Object)this, 0));
        this.refreshTableFromSql(this.getSQLUpdate(), this.getSQLResultCountSelect());
        this.fireRefreshEvent(new SRefreshEvent((Object)this, 1));
    }
}

