/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import lang.SString;
import swiext.table.SDefaultTableModelFilterEvent;
import swiext.table.SDefaultTableModelListener;
import swiext.table.__SDefaultTableModelColumnData;

public class SDefaultTableModel
extends DefaultTableModel {
    private __SDefaultTableModelColumnData[] iColumnData = new __SDefaultTableModelColumnData[0];
    private static final long serialVersionUID = 1L;
    public static final long AUTO_APPEND_ROWS = 1L;
    private long iFlags = 1L;

    public SDefaultTableModel() {
    }

    public SDefaultTableModel(int rowCount, int columnCount) {
        super(rowCount, columnCount);
    }

    public SDefaultTableModel(Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
    }

    public SDefaultTableModel(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    public SDefaultTableModel(Vector columnNames, int rowCount) {
        super(columnNames, rowCount);
    }

    public SDefaultTableModel(Vector data, Vector columnNames) {
        super(data, columnNames);
    }

    public SDefaultTableModel(long flags) {
        this.iFlags = flags;
    }

    public SDefaultTableModel(long flags, int rowCount, int columnCount) {
        super(rowCount, columnCount);
        this.iFlags = flags;
    }

    public SDefaultTableModel(long flags, Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
        this.iFlags = flags;
    }

    public SDefaultTableModel(long flags, Object[][] data, Object[] columnNames) {
        super(data, columnNames);
        this.iFlags = flags;
    }

    public SDefaultTableModel(long flags, Vector columnNames, int rowCount) {
        super(columnNames, rowCount);
        this.iFlags = flags;
    }

    public SDefaultTableModel(long flags, Vector data, Vector columnNames) {
        super(data, columnNames);
        this.iFlags = flags;
    }

    public void addNeededColumns(int column) {
        if ((this.iFlags & 1L) == 1L && column >= this.getColumnCount()) {
            this.setColumnCount(column + 1);
        }
        if (this.iColumnData.length < column + 1) {
            this.initColumnAttributes();
        }
    }

    public void addNeededRows(int row) {
        if ((this.iFlags & 1L) == 1L && row >= this.getRowCount()) {
            this.setRowCount(row + 1);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if ((this.iFlags & 1L) == 1L) {
            this.addNeededColumns(column);
            this.addNeededRows(row);
        }
        if ((this.iFlags & 1L) == 1L) {
            try {
                super.setValueAt(value, row, column);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.addNeededColumns(column);
                this.addNeededRows(row);
                super.setValueAt(value, row, column);
            }
        } else {
            super.setValueAt(value, row, column);
        }
        if (value != null) {
            Class<?> cls = value.getClass();
            if (value instanceof Number) {
                this.setColumnClass(column, value.getClass());
            } else if (value instanceof Boolean) {
                this.setColumnClass(column, Boolean.class);
            } else if (cls == Time.class || cls == Timestamp.class || cls == Date.class || cls == java.util.Date.class) {
                this.setColumnClass(column, cls);
            } else {
                this.setColumnClass(column, String.class);
            }
        }
    }

    @Override
    public void setColumnCount(int columnCount) {
        while (columnCount >= this.getColumnCount()) {
            this.addColumn("" + this.getColumnCount());
        }
        super.setColumnCount(columnCount);
        this.initColumnAttributes();
    }

    @Override
    public void addColumn(Object columnName, Object[] columnData) {
        super.addColumn(columnName, columnData);
        this.initColumnAttributes();
    }

    public void addColumn(Object columnName, Vector columnData) {
        super.addColumn(columnName, columnData);
        this.initColumnAttributes();
    }

    @Override
    public void addColumn(Object columnName) {
        super.addColumn(columnName);
        this.initColumnAttributes();
    }

    @Override
    public void removeRow(int row) {
        this.fireTableDataChanged();
        this.fireTableRowsDeleted(row, row);
        super.removeRow(row);
    }

    public void removeRows(int startRow, int endRow) {
        int maxRow;
        int minRow = Math.min(startRow, endRow);
        int r = maxRow = Math.max(startRow, endRow);
        while (r >= minRow) {
            this.removeRow(r);
            --r;
        }
    }

    public void removeAllRows() {
        this.setRowCount(0);
    }

    @Override
    public void setRowCount(int rowCount) {
        if ((this.iFlags & 1L) == 1L) {
            if (rowCount > this.getRowCount()) {
                while (rowCount > this.getRowCount()) {
                    Vector<String> v = new Vector<String>();
                    int c = 0;
                    while (c < this.getColumnCount()) {
                        v.add("");
                        ++c;
                    }
                    this.addRow(v);
                }
            }
            while (rowCount < this.getRowCount()) {
                this.removeRow(this.getRowCount() - 1);
            }
        }
        super.setRowCount(rowCount);
    }

    private void initColumnAttributes() {
        int cc = this.getColumnCount();
        if (this.iColumnData.length == cc) {
            return;
        }
        int c = this.iColumnData.length;
        this.iColumnData = Arrays.copyOf(this.iColumnData, cc);
        while (c < this.getColumnCount()) {
            this.iColumnData[c] = new __SDefaultTableModelColumnData();
            ++c;
        }
    }

    public void setColumnClass(int columnIndex, Class<?> cls) {
        if (columnIndex >= this.getColumnCount()) {
            return;
        }
        if (this.iColumnData[columnIndex].cls == cls) {
            return;
        }
        this.iColumnData[columnIndex].cls = cls;
        if (cls == Number.class) {
            this.setHorizontalAlignment(columnIndex, 4);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.iColumnData.length > columnIndex) {
            return this.iColumnData[columnIndex].cls;
        }
        return super.getColumnClass(columnIndex);
    }

    public void setColumnFilters(int columnIndex, String filterFrom, String filterTo) {
        this.setColumnFilter(columnIndex, filterFrom, true);
        this.setColumnFilter(columnIndex, filterTo, false);
    }

    private static Object compileFilter(String filter, Class cls) {
        Comparable<java.util.Date> o = null;
        if (filter != null && filter.length() > 0) {
            if (cls == Time.class) {
                o = SString.convertToTime(filter);
            } else if (cls == Date.class) {
                o = SString.convertToSqlDate(filter);
            } else if (cls == java.util.Date.class) {
                o = SString.convertToDate(filter);
            } else if (cls == Timestamp.class) {
                o = SString.convertToTimestamp(filter);
            } else if (cls == Boolean.class) {
                o = SString.convertToBoolean(filter);
            }
        }
        return o;
    }

    private void recompileFilter(int columnIndex, String filter, boolean isFrom) {
        Object o = SDefaultTableModel.compileFilter(filter, this.iColumnData[columnIndex].cls);
        if (isFrom) {
            this.iColumnData[columnIndex].compiledFilterFrom = o;
        } else {
            this.iColumnData[columnIndex].compiledFilterTo = o;
        }
    }

    public Object getColumnCompiledFilter(int columnIndex, boolean isFrom) {
        if (isFrom) {
            return this.iColumnData[columnIndex].compiledFilterFrom;
        }
        return this.iColumnData[columnIndex].compiledFilterTo;
    }

    public void setColumnFilter(int columnIndex, String filter, boolean isFrom) {
        boolean changed = false;
        this.addNeededColumns(columnIndex);
        if (isFrom) {
            if (!this.iColumnData[columnIndex].filterFrom.equals(filter)) {
                this.iColumnData[columnIndex].filterFrom = filter;
                changed = true;
            }
        } else if (!this.iColumnData[columnIndex].filterTo.equals(filter)) {
            this.iColumnData[columnIndex].filterTo = filter;
            changed = true;
        }
        this.recompileFilter(columnIndex, filter, isFrom);
        if (changed) {
            this.fireTableFilterChanged(columnIndex, isFrom);
        }
    }

    public String getColumnFilter(int columnIndex, boolean isFrom) {
        this.addNeededColumns(columnIndex);
        if (isFrom) {
            return this.iColumnData[columnIndex].filterFrom;
        }
        return this.iColumnData[columnIndex].filterTo;
    }

    public boolean hasColumnFilter(int columnIndex, boolean isFrom) {
        this.addNeededColumns(columnIndex);
        if (isFrom) {
            return this.iColumnData[columnIndex].filterFrom.length() > 0;
        }
        return this.iColumnData[columnIndex].filterTo.length() > 0;
    }

    public boolean hasColumnFilter(int columnIndex) {
        this.addNeededColumns(columnIndex);
        return this.iColumnData[columnIndex].filterFrom.length() > 0 || this.iColumnData[columnIndex].filterTo.length() > 0;
    }

    public void setColumnDisplayFormat(int columnIndex, Format format) {
        this.addNeededColumns(columnIndex);
        this.iColumnData[columnIndex].displayFormat = format;
    }

    public void setColumnDisplayFormat(int columnIndex, String format) {
        this.addNeededColumns(columnIndex);
        if (this.iColumnData[columnIndex].displayFormatPattern != null && this.iColumnData[columnIndex].displayFormatPattern.equals(format)) {
            return;
        }
        this.iColumnData[columnIndex].displayFormatPattern = format;
        this.iColumnData[columnIndex].displayFormat = null;
    }

    public Format getColumnDisplayFormat(int columnIndex) {
        this.addNeededColumns(columnIndex);
        if (this.iColumnData[columnIndex].displayFormat == null) {
            Class<?> cls = this.iColumnData[columnIndex].cls;
            if (this.iColumnData[columnIndex].displayFormatPattern == null) {
                if (cls == Timestamp.class) {
                    this.iColumnData[columnIndex].displayFormat = DateFormat.getDateTimeInstance(3, 2);
                } else if (cls == Time.class) {
                    this.iColumnData[columnIndex].displayFormat = DateFormat.getTimeInstance(2);
                } else if (cls == Date.class) {
                    this.iColumnData[columnIndex].displayFormat = DateFormat.getDateInstance(3);
                } else if (cls == java.util.Date.class) {
                    this.iColumnData[columnIndex].displayFormat = DateFormat.getDateInstance(3);
                } else if (cls == Number.class) {
                    this.iColumnData[columnIndex].displayFormat = NumberFormat.getNumberInstance();
                } else if (cls == Boolean.class) {
                    this.iColumnData[columnIndex].displayFormat = NumberFormat.getIntegerInstance();
                }
            } else if (cls == Timestamp.class) {
                this.iColumnData[columnIndex].displayFormat = new SimpleDateFormat(this.iColumnData[columnIndex].displayFormatPattern);
            } else if (cls == Time.class) {
                this.iColumnData[columnIndex].displayFormat = new SimpleDateFormat(this.iColumnData[columnIndex].displayFormatPattern);
            } else if (cls == Date.class) {
                this.iColumnData[columnIndex].displayFormat = new SimpleDateFormat(this.iColumnData[columnIndex].displayFormatPattern);
            } else if (cls == java.util.Date.class) {
                this.iColumnData[columnIndex].displayFormat = new SimpleDateFormat(this.iColumnData[columnIndex].displayFormatPattern);
            } else if (cls == Number.class) {
                this.iColumnData[columnIndex].displayFormat = new DecimalFormat(this.iColumnData[columnIndex].displayFormatPattern);
            } else if (cls == Boolean.class) {
                this.iColumnData[columnIndex].displayFormat = new DecimalFormat(this.iColumnData[columnIndex].displayFormatPattern);
            }
        }
        return this.iColumnData[columnIndex].displayFormat;
    }

    public void setHorizontalAlignment(int columnIndex, int alignment) {
        this.addNeededColumns(columnIndex);
        this.iColumnData[columnIndex].horizontalAlignment = alignment;
    }

    public int getHorizontalAlignment(int columnIndex) {
        this.addNeededColumns(columnIndex);
        return this.iColumnData[columnIndex].horizontalAlignment;
    }

    public long getFlags() {
        return this.iFlags;
    }

    public void setFlags(long flags) {
        this.iFlags = flags;
    }

    public void fireTableFilterChanged(SDefaultTableModelFilterEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == SDefaultTableModelListener.class) {
                ((SDefaultTableModelListener)listeners[i + 1]).tableFilterChanged(e);
            }
            i -= 2;
        }
    }

    public void fireTableFilterChanged(int column, boolean isFrom) {
        this.fireTableFilterChanged(new SDefaultTableModelFilterEvent(this, column));
    }

    public void addTableModelFilterListener(SDefaultTableModelListener l) {
        this.listenerList.add(SDefaultTableModelListener.class, l);
    }

    public void removeTableModelFilterListener(SDefaultTableModelListener l) {
        this.listenerList.remove(SDefaultTableModelListener.class, l);
    }
}

