/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Date;
import javax.swing.RowFilter;
import lang.SString;
import swiext.table.SDefaultTableModel;

public class SDefaultTableRowFilter
extends RowFilter<Object, Integer> {
    private Collator iCollator = null;

    private int compare(String s1, String s2) {
        if (this.iCollator == null) {
            this.iCollator = Collator.getInstance();
        }
        return this.iCollator.compare(s1, s2);
    }

    @Override
    public boolean include(RowFilter.Entry<? extends Object, ? extends Integer> entry) {
        boolean rc = true;
        if (entry.getModel() instanceof SDefaultTableModel) {
            int row = entry.getIdentifier();
            SDefaultTableModel tm = (SDefaultTableModel)entry.getModel();
            int c = 0;
            while (c < tm.getColumnCount()) {
                if (tm.hasColumnFilter(c)) {
                    Object o = tm.getValueAt(row, c);
                    String s = o == null ? null : o.toString();
                    if (s != null && s.length() > 0) {
                        boolean hff = tm.hasColumnFilter(c, true);
                        boolean hft = tm.hasColumnFilter(c, false);
                        Class<?> cls = tm.getColumnClass(c);
                        if (cls == Boolean.class) {
                            rc = false;
                            if (hff != hft) {
                                rc = SString.convertToBoolean(s) == (Boolean)tm.getColumnCompiledFilter(c, hff);
                            } else {
                                String ft;
                                String ff = tm.getColumnFilter(c, true);
                                if (ff.equals(ft = tm.getColumnFilter(c, false))) {
                                    rc = SString.convertToBoolean(s) == SString.convertToBoolean(ff);
                                }
                            }
                        } else if (cls == Time.class || cls == Timestamp.class || cls == Date.class || cls == java.sql.Date.class || cls == Time.class) {
                            if (hff != hft) {
                                rc = SString.isLike(s, tm.getColumnFilter(c, hff));
                            } else {
                                Date v = null;
                                Date off = (Date)tm.getColumnCompiledFilter(c, true);
                                Date oft = (Date)tm.getColumnCompiledFilter(c, false);
                                if (cls == Time.class) {
                                    v = SString.convertToTime(new Time(((Time)o).getTime()).toString());
                                } else if (cls == java.sql.Date.class) {
                                    v = SString.convertToSqlDate(new java.sql.Date(((java.sql.Date)o).getTime()).toString());
                                } else if (cls == Date.class) {
                                    v = SString.convertToDate(new Date(((Date)o).getTime()).toString());
                                } else if (cls == Timestamp.class) {
                                    v = SString.convertToTimestamp(new Timestamp(((Timestamp)o).getTime()).toString());
                                }
                                if (v != null && off != null && oft != null) {
                                    if (v.before(off) || v.after(oft)) {
                                        rc = false;
                                    }
                                } else if (this.compare(s, tm.getColumnFilter(c, true)) < 0 || this.compare(s, tm.getColumnFilter(c, false)) > 0) {
                                    rc = false;
                                }
                            }
                        } else if (hff != hft) {
                            rc = SString.isLike(s, tm.getColumnFilter(c, hff));
                        } else if (this.compare(s, tm.getColumnFilter(c, true)) < 0 || this.compare(s, tm.getColumnFilter(c, false)) > 0) {
                            rc = false;
                        }
                        if (!rc) {
                            break;
                        }
                    } else {
                        rc = false;
                    }
                }
                ++c;
            }
        }
        return rc;
    }
}

