/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import prefs.SPreferences;
import swiext.SWindowPreferences;
import swiext.table.SDefaultTableModel;
import swiext.table.STable;

public class SFilteredTable
extends STable {
    private static final long serialVersionUID = 1L;

    private void initialize() {
        this.getRowFilter();
    }

    public SFilteredTable() {
        this.initialize();
    }

    public SFilteredTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public SFilteredTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public SFilteredTable(SDefaultTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    public SFilteredTable(SDefaultTableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public SFilteredTable(SDefaultTableModel dm) {
        super(dm);
        this.initialize();
    }

    public SFilteredTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public void setColumnFilters(int columnIndex, String filterFrom, String filterTo) {
        this.getModel().setColumnFilters(this.convertColumnIndexToModel(columnIndex), filterFrom, filterTo);
    }

    public void setColumnFilter(int columnIndex, String filter, boolean isFrom) {
        this.getModel().setColumnFilter(this.convertColumnIndexToModel(columnIndex), filter, isFrom);
    }

    public String getColumnFilter(int columnIndex, boolean isFrom) {
        return this.getModel().getColumnFilter(this.convertColumnIndexToModel(columnIndex), isFrom);
    }

    private void parseFilter(String filter, boolean isFrom) {
        if (filter.length() > 0) {
            filter = String.valueOf(filter) + ";";
            while (filter.indexOf(");") > 0) {
                int columnIndex = Integer.parseInt(filter.substring(1, filter.indexOf("=")));
                String f = filter.substring(filter.indexOf("=") + 1, filter.indexOf(");"));
                f = f.replace("\\(", "(").replace("\\)", ")").replace("\\;", ";").replace("\\=", "=");
                filter = filter.substring(filter.indexOf(");") + 2);
                this.setColumnFilter(columnIndex, f, isFrom);
            }
        }
    }

    @Override
    public void readState(SPreferences prefs, String section) {
        super.readState(prefs, section);
        String key = SWindowPreferences.suggestSectionNameForComponent(this);
        String filterFrom = prefs.tryGet(String.valueOf(key) + ".filterFrom", "", section);
        String filterTo = prefs.tryGet(String.valueOf(key) + ".filterTo", "", section);
        if (filterFrom.length() > 0) {
            this.parseFilter(filterFrom, true);
        }
        if (filterTo.length() > 0) {
            this.parseFilter(filterTo, false);
        }
    }

    @Override
    public void writeState(SPreferences prefs, String section) {
        super.writeState(prefs, section);
        String filterFrom = "";
        String filterTo = "";
        String cmnkey = SWindowPreferences.suggestSectionNameForComponent(this);
        int c = 0;
        while (c < this.getColumnCount()) {
            String ff = this.getColumnFilter(c, true);
            String ft = this.getColumnFilter(c, false);
            ff = ff.replace("(", "\\(").replace(")", "\\)").replace(";", "\\;").replace("=", "\\=");
            ft = ft.replace("(", "\\(").replace(")", "\\)").replace(";", "\\;").replace("=", "\\=");
            if (ff.length() > 0) {
                filterFrom = String.valueOf(filterFrom) + "(" + c + "=" + ff + ");";
            }
            if (ft.length() > 0) {
                filterTo = String.valueOf(filterTo) + "(" + c + "=" + ft + ");";
            }
            ++c;
        }
        String key = String.valueOf(cmnkey) + ".filterFrom";
        if (filterFrom.length() > 0) {
            filterFrom = filterFrom.substring(0, filterFrom.length() - 1);
            prefs.tryPut(key, filterFrom, section);
        } else {
            prefs.tryDelKey(key, section);
        }
        key = String.valueOf(cmnkey) + ".filterTo";
        if (filterTo.length() > 0) {
            filterTo = filterTo.substring(0, filterTo.length() - 1);
            prefs.tryPut(key, filterTo, section);
        } else {
            prefs.tryDelKey(key, section);
        }
    }
}

