/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import awtext.SRefreshEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import swiext.table.SDefaultTableModel;
import swiext.table.SFilteredTable;
import swiext.table.STableFilterPanel;
import swiext.table.__SRowHeaderRenderer;
import swiext.table.__SScrollPaneTableListModel;

public class SScrollPaneTable
extends SFilteredTable {
    private static final long serialVersionUID = 1L;
    private JScrollPane iScrollPane;
    private JPanel iPanel;
    private STableFilterPanel iFilterPanel = null;
    JList iRowHeader = null;

    private void initialize() {
        if (this.iPanel == null) {
            this.iPanel = new JPanel();
        }
        if (this.iScrollPane == null) {
            this.iScrollPane = new JScrollPane();
        }
        this.iScrollPane.setViewportView(this);
        this.setFillsViewportHeight(true);
        this.iPanel = new JPanel();
        this.iPanel.setLayout(new BorderLayout());
        this.iPanel.setOpaque(true);
        this.iPanel.add((Component)this.iScrollPane, "Center");
    }

    public void addFilterControl() {
        if (this.iFilterPanel == null) {
            this.iFilterPanel = new STableFilterPanel(this);
            this.iPanel.add((Component)this.iFilterPanel, "North");
            JScrollBar bar = this.getScrollPane().getHorizontalScrollBar();
            bar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    SScrollPaneTable.this.iFilterPanel.reBuildFilterCells();
                }
            });
        }
    }

    public void removeFilterControl() {
        if (this.iFilterPanel != null) {
            this.iPanel.remove(this.iFilterPanel);
            this.iFilterPanel.setVisible(false);
            this.iFilterPanel = null;
        }
    }

    public SScrollPaneTable() {
        this.initialize();
    }

    public SScrollPaneTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public SScrollPaneTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public SScrollPaneTable(SDefaultTableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    public SScrollPaneTable(SDefaultTableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public SScrollPaneTable(SDefaultTableModel dm) {
        super(dm);
        this.initialize();
    }

    public SScrollPaneTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public JComponent getTopControl() {
        return this.iPanel;
    }

    public JScrollPane getScrollPane() {
        return this.iScrollPane;
    }

    public void addRowHeaders(boolean numberedRows) {
        if (this.iRowHeader == null) {
            this.iRowHeader = new JList(new __SScrollPaneTableListModel(this, numberedRows));
            this.iRowHeader.setFixedCellWidth(50);
            this.iRowHeader.setFixedCellHeight(this.getRowHeight());
            this.iRowHeader.setCellRenderer(new __SRowHeaderRenderer(this));
            this.getScrollPane().setRowHeaderView(this.iRowHeader);
        }
    }

    public void addRowHeaders() {
        this.addRowHeaders(false);
    }

    public void removeRowHeaders() {
        if (this.iRowHeader != null) {
            this.iRowHeader = null;
            this.getScrollPane().setRowHeaderView(this.iRowHeader);
        }
    }

    public JList getRowHeader() {
        return this.iRowHeader;
    }

    public int getRowHeaderWidth() {
        if (this.iRowHeader != null) {
            return this.iRowHeader.getWidth();
        }
        return 0;
    }

    @Override
    public void dispatchRefreshEvent(SRefreshEvent evt) {
        if (evt.getMode() == 3 && evt.getCommand() == SRefreshEvent.EventCmd.INVALIDATE_ROW_HEADER) {
            this.getRowHeader().invalidate();
            this.getRowHeader().repaint();
        }
        super.dispatchRefreshEvent(evt);
    }
}

