/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import awtext.SPair;
import awtext.SRefreshBroadcaster;
import awtext.SRefreshEvent;
import awtext.SRefreshListener;
import awtext.SRefreshManager;
import awtext.SRefreshable;
import awtext.SWindowStateRWInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import prefs.SPreferences;
import swiext.SConstants;
import swiext.SFormattedTextField;
import swiext.SWindowPreferences;
import swiext.table.SColumnVisibilityListener;
import swiext.table.SDefaultTableModel;
import swiext.table.SDefaultTableRowFilter;
import swiext.table.__STableColumnData;
import swiext.table.__STableColumnDataStorage;
import swiext.table.__STable_DefaultEditor;
import swiext.table.__STable_DefaultTableCellRenderer;

public class STable
extends JTable
implements SRefreshable,
SRefreshBroadcaster,
SWindowStateRWInterface,
SRefreshListener {
    __STableColumnDataStorage iColumnDataStorage = new __STableColumnDataStorage();
    private TableRowSorter<SDefaultTableModel> iBulkSavedSorter = null;
    private static final long serialVersionUID = 1L;
    private boolean iEditable = true;
    protected static TableCellRenderer iRenderer = new __STable_DefaultTableCellRenderer();
    private SRefreshManager iRefreshManager = null;
    static boolean bTableEnabled = true;

    public synchronized void setSortingEnabled(boolean enabled) {
        if (!enabled) {
            if (this.iBulkSavedSorter == null) {
                this.iBulkSavedSorter = this.getRowSorter();
            }
            this.setRowSorter(null);
        } else {
            if (this.iBulkSavedSorter != null) {
                TableRowSorter<SDefaultTableModel> aSorter = new TableRowSorter<SDefaultTableModel>(this.getModel());
                aSorter.setSortKeys(this.iBulkSavedSorter.getSortKeys());
                aSorter.setRowFilter(this.iBulkSavedSorter.getRowFilter());
                this.setRowSorter(aSorter);
                aSorter.sort();
            }
            this.iBulkSavedSorter = null;
        }
    }

    public boolean isSortingEnabled() {
        return this.iBulkSavedSorter == null && this.getRowSorter() != null;
    }

    private void recalcColumnArray(int[] columns) {
        int i = 0;
        while (i < this.getColumnCount() && i < columns.length) {
            columns[i] = this.convertColumnIndexToModel(i);
            ++i;
        }
    }

    public void setColumnVisible(TableColumn column, boolean visible) {
        __STableColumnData d = this.iColumnDataStorage.getColumnData(column);
        if (d != null) {
            d.setVisible(visible);
        } else if (!visible) {
            d = this.iColumnDataStorage.addColumnData(column);
            d.setVisible(visible);
        }
        if (visible) {
            this.iColumnDataStorage.removeColumnData(column);
        }
        this.fireColumnVisibilityChanged(this, column, visible);
    }

    public void fireColumnVisibilityChanged(STable table, TableColumn column, boolean visible) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == SColumnVisibilityListener.class) {
                ((SColumnVisibilityListener)listeners[i + 1]).columnVisibilityChanged(table, column, visible);
            }
            i -= 2;
        }
    }

    public void addColumnVisibilityListener(SColumnVisibilityListener l) {
        this.listenerList.add(SColumnVisibilityListener.class, l);
    }

    public void removeColumnVisibilityListener(SColumnVisibilityListener l) {
        this.listenerList.remove(SColumnVisibilityListener.class, l);
    }

    public boolean isColumnVisible(TableColumn column) {
        __STableColumnData d = this.iColumnDataStorage.getColumnData(column);
        if (d != null) {
            return d.isVisible();
        }
        return true;
    }

    @Override
    public void readState(SPreferences prefs, String section) {
        int i;
        int columnIndex;
        String cmnkey = SWindowPreferences.suggestSectionNameForComponent(this);
        String key = String.valueOf(cmnkey) + ".columnOrder";
        String val1 = prefs.tryGet(key, "", section);
        int[] columns = new int[this.getColumnCount()];
        int[] ncolumns = new int[this.getColumnCount()];
        if (val1.length() > 0) {
            while (val1.indexOf(")") > 0) {
                columnIndex = Integer.parseInt(val1.substring(1, val1.indexOf("=")));
                int newIndex = Integer.parseInt(val1.substring(val1.indexOf("=") + 1, val1.indexOf(")")));
                val1 = val1.indexOf(")") < val1.length() - 1 ? val1.substring(val1.indexOf(")") + 2) : "";
                if (columnIndex >= columns.length) continue;
                columns[columnIndex] = newIndex;
            }
            this.recalcColumnArray(ncolumns);
            int c = 0;
            while (c < this.getColumnCount()) {
                if (columns[c] != c) {
                    this.getColumnModel().moveColumn(columns[c], c);
                    this.recalcColumnArray(ncolumns);
                    i = c + 1;
                    while (i < this.getColumnCount()) {
                        if (columns[i] <= columns[c]) {
                            int n = i;
                            columns[n] = columns[n] + 1;
                        }
                        ++i;
                    }
                    columns[c] = c;
                }
                ++c;
            }
        }
        if ((val1 = prefs.tryGet(key = String.valueOf(cmnkey) + ".columnWidth", "", section)).length() > 0) {
            while (val1.indexOf(")") > 0) {
                columnIndex = Integer.parseInt(val1.substring(1, val1.indexOf("=")));
                int width = Integer.parseInt(val1.substring(val1.indexOf("=") + 1, val1.indexOf(")")));
                val1 = val1.indexOf(")") < val1.length() - 1 ? val1.substring(val1.indexOf(")") + 2) : "";
                if (columnIndex >= this.getColumnModel().getColumnCount()) continue;
                TableColumn col = this.getColumnModel().getColumn(columnIndex);
                if (width <= 0) {
                    col.setWidth(width * -1);
                    __STableColumnData data = this.iColumnDataStorage.addColumnData(col);
                    data.setVisible(false);
                    continue;
                }
                col.setPreferredWidth(width);
                col.setWidth(width);
            }
        }
        if ((val1 = prefs.tryGet(key = String.valueOf(cmnkey) + ".sortOrder", "", section)).length() > 0) {
            ArrayList<RowSorter.SortKey> l = new ArrayList<RowSorter.SortKey>();
            while (val1.indexOf(")") > 0) {
                RowSorter.SortKey ky = null;
                String subval = val1.substring(1, val1.indexOf(")"));
                val1 = val1.length() > subval.length() + 3 ? val1.substring(subval.length() + 3) : "";
                i = Integer.parseInt(subval.substring(0, subval.indexOf("=")));
                subval = subval.substring(subval.indexOf("=") + 1);
                ky = new RowSorter.SortKey(i, SortOrder.valueOf(subval));
                l.add(ky);
            }
            if (!l.isEmpty()) {
                i = this.getColumnCount();
                if (this.getRowSorter() != null) {
                    try {
                        ((DefaultRowSorter)this.getRowSorter()).setSortKeys(l);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public TableRowSorter<SDefaultTableModel> getRowSorter() {
        if (this.iBulkSavedSorter != null) {
            return null;
        }
        if (super.getRowSorter() != null && super.getRowSorter() instanceof TableRowSorter && super.getRowSorter().getModel() instanceof SDefaultTableModel) {
            return (TableRowSorter)super.getRowSorter();
        }
        TableRowSorter srtr = null;
        srtr = (TableRowSorter)super.getRowSorter();
        if (srtr == null && this.getModel() instanceof SDefaultTableModel) {
            TableRowSorter<SDefaultTableModel> iSorter = new TableRowSorter<SDefaultTableModel>(this.getModel());
            this.setRowSorter(iSorter);
        }
        return srtr;
    }

    public TableRowSorter<SDefaultTableModel> getRowSorter(boolean bulkSorterIfSet) {
        TableRowSorter<SDefaultTableModel> srtr = this.getRowSorter();
        if (srtr == null) {
            srtr = this.iBulkSavedSorter;
        }
        return srtr;
    }

    public SDefaultTableRowFilter getRowFilter() {
        RowSorter srtr = this.getRowSorter();
        SDefaultTableRowFilter fltr = null;
        if (srtr != null) {
            if (((DefaultRowSorter)srtr).getRowFilter() != null && ((DefaultRowSorter)srtr).getRowFilter() instanceof SDefaultTableRowFilter) {
                fltr = (SDefaultTableRowFilter)((DefaultRowSorter)srtr).getRowFilter();
            }
            if (fltr == null) {
                fltr = new SDefaultTableRowFilter();
                ((DefaultRowSorter)srtr).setRowFilter(fltr);
            }
        }
        return fltr;
    }

    @Override
    public void writeState(SPreferences prefs, String section) {
        String cmnkey = SWindowPreferences.suggestSectionNameForComponent(this);
        String val1 = "";
        String val2 = "";
        boolean doColumnOrder = false;
        int i = 0;
        while (i < this.getColumnCount()) {
            if (i != this.convertColumnIndexToModel(i)) {
                doColumnOrder = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.getColumnCount()) {
            TableColumn col;
            __STableColumnData cdata;
            if (doColumnOrder) {
                val1 = String.valueOf(val1) + "(" + i + "=" + this.convertColumnIndexToModel(i) + ");";
            }
            int w = (cdata = this.iColumnDataStorage.getColumnData(col = this.getColumnModel().getColumn(i))) != null && !cdata.isVisible() ? -1 * cdata.getSavedWidth() : col.getWidth();
            val2 = String.valueOf(val2) + "(" + i + "=" + w + ");";
            ++i;
        }
        String key = String.valueOf(cmnkey) + ".columnOrder";
        if (val1.length() > 0) {
            val1 = val1.substring(0, val1.length() - 1);
            prefs.tryPut(key, val1, section);
        } else {
            prefs.tryDelKey(key, section);
        }
        key = String.valueOf(cmnkey) + ".columnWidth";
        if (val2.length() > 0) {
            val2 = val2.substring(0, val2.length() - 1);
            prefs.tryPut(key, val2, section);
        } else {
            prefs.tryDelKey(key, section);
        }
        val1 = "";
        if (this.getRowSorter() != null && ((DefaultRowSorter)this.getRowSorter()).getSortKeys() != null) {
            ListIterator<RowSorter.SortKey> i2 = ((DefaultRowSorter)this.getRowSorter()).getSortKeys().listIterator();
            while (i2.hasNext()) {
                RowSorter.SortKey ky = (RowSorter.SortKey)i2.next();
                String v = "(" + ky.getColumn() + "=" + ky.getSortOrder().toString() + ")";
                val1 = String.valueOf(val1) + v + ";";
            }
            key = String.valueOf(cmnkey) + ".sortOrder";
            if (val1.length() > 0) {
                val1 = val1.substring(0, val1.length() - 1);
                prefs.tryPut(key, val1, section);
            } else {
                prefs.tryDelKey(key, section);
            }
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        SDefaultTableModel tm = this.getModel();
        TableColumnModel cm = this.getColumnModel();
        if (tm != null && tm instanceof SDefaultTableModel && cm != null) {
            while (cm.getColumnCount() > tm.getColumnCount()) {
                cm.removeColumn(cm.getColumn(cm.getColumnCount() - 1));
            }
            while (cm.getColumnCount() < tm.getColumnCount()) {
                this.addColumn(new TableColumn(cm.getColumnCount()));
            }
        } else {
            super.createDefaultColumnsFromModel();
        }
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new SDefaultTableModel();
    }

    public static void packColumn(JTable table, int colIndex, int margin) {
        TableColumnModel colModel = table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        int r = 0;
        while (r < table.getRowCount()) {
            renderer = table.getCellRenderer(r, colIndex);
            if (renderer != null) {
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, colIndex), false, false, r, colIndex);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            ++r;
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    public static void packColumns(JTable table, int margin) {
        int c = 0;
        while (c < table.getColumnCount()) {
            STable.packColumn(table, c, margin);
            ++c;
        }
    }

    public void packColumn(int colIndex, int margin) {
        STable.packColumn(this, colIndex, margin);
    }

    public void packColumns(int margin) {
        STable.packColumns(this, margin);
    }

    private void initialize() {
        this.getRefreshManager().addRefreshListener(this);
        this.setModel(new SDefaultTableModel());
        this.setColumnModel(new DefaultTableColumnModel());
        this.setPreferredScrollableViewportSize(new Dimension(5, 5));
    }

    public STable() {
        this.initialize();
    }

    public STable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public STable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public STable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    public STable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public STable(TableModel dm) {
        super(dm);
        this.initialize();
    }

    public STable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (dataModel instanceof SDefaultTableModel) {
            super.setModel(dataModel);
        } else {
            this.setModel(new SDefaultTableModel());
        }
    }

    public void setColumnDisplayFormat(int colIndex, String format) {
        int coli = this.convertColumnIndexToModel(colIndex);
        this.getModel().setColumnDisplayFormat(coli, format);
    }

    @Override
    public SDefaultTableModel getModel() {
        return (SDefaultTableModel)super.getModel();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        int coli = this.convertColumnIndexToModel(column);
        TableCellEditor editor = this.getColumnModel().getColumn(coli).getCellEditor();
        if (editor == null) {
            Class<?> cls = this.getColumnClass(coli);
            if (cls == Boolean.class) {
                editor = this.getDefaultEditor(cls);
            } else {
                int classtype = SConstants.classTypeToTypeNumber(cls);
                SFormattedTextField tf = new SFormattedTextField(classtype);
                editor = new __STable_DefaultEditor(tf);
            }
        }
        return editor;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int coli = this.convertColumnIndexToModel(column);
        TableCellRenderer renderer = this.getColumnModel().getColumn(coli).getCellRenderer();
        if (renderer == null) {
            Class<?> cls = this.getColumnClass(coli);
            renderer = cls == Boolean.class ? this.getDefaultRenderer(cls) : iRenderer;
        }
        return renderer;
    }

    @Override
    public int convertColumnIndexToModel(int viewColumnIndex) {
        this.getModel().addNeededColumns(viewColumnIndex);
        return super.convertColumnIndexToModel(viewColumnIndex);
    }

    @Override
    public int convertColumnIndexToView(int modelColumnIndex) {
        this.getModel().addNeededColumns(modelColumnIndex);
        return super.convertColumnIndexToView(modelColumnIndex);
    }

    @Override
    public int convertRowIndexToModel(int viewRowIndex) {
        this.getModel().addNeededRows(viewRowIndex);
        return super.convertRowIndexToModel(viewRowIndex);
    }

    @Override
    public int convertRowIndexToView(int modelRowIndex) {
        this.getModel().addNeededRows(modelRowIndex);
        return super.convertRowIndexToView(modelRowIndex);
    }

    public boolean isEditable() {
        return this.iEditable;
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isEditable()) {
            return super.isCellEditable(row, column);
        }
        return false;
    }

    @Override
    public boolean isCurrent() {
        return true;
    }

    @Override
    public void refresh() {
    }

    @Override
    public void addRefreshListener(SRefreshListener l) {
        this.getRefreshManager().addRefreshListener(l);
    }

    @Override
    public void fireRefreshEvent(SRefreshEvent evt) {
        this.getRefreshManager().fireRefreshEvent(evt);
    }

    @Override
    public void removeRefreshListener(SRefreshListener l) {
        this.getRefreshManager().removeRefreshListener(l);
    }

    public SRefreshManager getRefreshManager() {
        if (this.iRefreshManager == null) {
            this.iRefreshManager = new SRefreshManager(this, SRefreshManager.Method.SWINGWORKER, 1000, 10000);
        }
        return this.iRefreshManager;
    }

    @Override
    public void dispatchRefreshEvent(SRefreshEvent evt) {
        block16: {
            block15: {
                if (evt.getMode() != 3) break block15;
                switch (evt.getCommand()) {
                    case SET_VALUE_AT: {
                        SPair aPair = (SPair)evt.getData1();
                        this.getModel().setValueAt(evt.getData2(), aPair.getValue1(), aPair.getValue2());
                        break;
                    }
                    case SET_ROW_VALUES: {
                        int r = (Integer)evt.getData1();
                        List lst = (List)evt.getData2();
                        int c = 0;
                        while (c < lst.size()) {
                            this.getModel().setValueAt(lst.get(c), r, c);
                            ++c;
                        }
                        break block16;
                    }
                    case CLEAR_TABLE_MODEL: {
                        SDefaultTableModel tm = this.getModel();
                        try {
                            this.clearSelection();
                            TableCellEditor ce = this.getCellEditor();
                            if (ce != null) {
                                ce.cancelCellEditing();
                            }
                            this.getModel().setRowCount(0);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.out.println("Exception while setting row count: Rows in Table Model:" + tm.getRowCount() + ", Rows in Table:" + this.getRowCount());
                        }
                        break block16;
                    }
                    case SET_SORTING_ENABLED: {
                        this.setSortingEnabled((Boolean)evt.getData1());
                        break;
                    }
                    case REVALIDATE: {
                        this.revalidate();
                        break;
                    }
                    case REPAINT: {
                        this.repaint();
                        break;
                    }
                }
                break block16;
            }
            if (evt.getMode() == 0) {
                bTableEnabled = this.isEnabled();
                this.setCursor(new Cursor(3));
                this.setEnabled(false);
            } else if (evt.getMode() == 1) {
                this.setEnabled(bTableEnabled);
                this.setCursor(new Cursor(0));
            }
        }
    }
}

