/*
 * Decompiled with CFR 0.152.
 */
package swiext.table;

import awtext.SActiveColorManager;
import awtext.SRefreshEvent;
import awtext.SRefreshListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultRowSorter;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import swiext.SAnimatedComponent;
import swiext.table.SDefaultTableModel;
import swiext.table.SDefaultTableModelFilterEvent;
import swiext.table.SDefaultTableModelListener;
import swiext.table.SDefaultTableRowFilter;
import swiext.table.SFilterControl;
import swiext.table.SScrollPaneTable;

public class STableFilterPanel
extends JPanel
implements SDefaultTableModelListener,
TableColumnModelListener,
SRefreshListener {
    private static final long serialVersionUID = 1L;
    private SScrollPaneTable iTable = null;
    private List<SFilterControl> iControls = new CopyOnWriteArrayList<SFilterControl>();
    private Timer iTimer = null;
    private SAnimatedComponent iAnimatedPanel = null;
    int iRebuildPendingCount = 0;

    @Override
    public void tableFilterChanged(SDefaultTableModelFilterEvent e) {
        SFilterControl cntrl = this.getControlForColumn(e.getColumn(), e.isFrom());
        String fltr = e.getFilterString();
        if (!cntrl.getText().equals(fltr)) {
            cntrl.setText(fltr);
        }
    }

    public SScrollPaneTable getTable() {
        return this.iTable;
    }

    public void setTable(SScrollPaneTable table) {
        if (this.iTable != null) {
            this.iTable.getRefreshManager().removeRefreshListener(this);
            this.iTable.getModel().removeTableModelFilterListener(this);
            this.iTable.getColumnModel().removeColumnModelListener(this);
        }
        this.iTable = table;
        if (this.iTable != null) {
            this.iTable.getRefreshManager().addRefreshListener(this);
            this.iTable.getModel().addTableModelFilterListener(this);
            this.iTable.getColumnModel().addColumnModelListener(this);
        }
    }

    private void initialize() {
        this.setLayout(null);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                STableFilterPanel.this.delayedFilterChanged();
            }
        };
        this.iTimer = new Timer(500, al);
        this.iTimer.setCoalesce(true);
        this.iTimer.setRepeats(false);
        this.iTimer.start();
        this.addAnimatedPanel();
    }

    protected STableFilterPanel() {
    }

    public STableFilterPanel(SScrollPaneTable table) {
        this.setTable(table);
        this.initialize();
    }

    public String getFilterForColumn(int colIndex, boolean isFrom) {
        SFilterControl fcnt = this.getControlForColumn(colIndex, isFrom);
        return fcnt.getText();
    }

    public String getFilterForColumn(TableColumn tc, boolean isFrom) {
        return this.getFilterForColumn(tc.getModelIndex(), isFrom);
    }

    public void setFilterForColumn(int colIndex, boolean isFrom, String filter) {
        SFilterControl fcnt = this.getControlForColumn(colIndex, isFrom);
        fcnt.setText(filter);
    }

    public void setFilterForColumn(TableColumn tc, boolean isFrom, String filter) {
        this.setFilterForColumn(tc.getModelIndex(), isFrom, filter);
    }

    private void updateFocusTraversalPolicy() {
        FocusTraversalPolicy pol = this.getFocusTraversalPolicy();
        if (pol == null) {
            pol = new DefaultFocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container container, Component component) {
                    Component c = null;
                    if (container instanceof STableFilterPanel) {
                        c = ((STableFilterPanel)container).getNextFilterControl(component);
                    }
                    if (c != null) {
                        return c;
                    }
                    return super.getComponentAfter(container, component);
                }

                @Override
                public Component getComponentBefore(Container container, Component component) {
                    Component c = null;
                    if (container instanceof STableFilterPanel) {
                        c = ((STableFilterPanel)container).getPrevFilterControl(component);
                    }
                    if (c != null) {
                        return c;
                    }
                    return super.getComponentBefore(container, component);
                }
            };
            this.setFocusTraversalPolicy(pol);
            this.setFocusCycleRoot(true);
        }
    }

    private SFilterControl getControlForColumnNoCreate(int colIndex, boolean isFrom) {
        SFilterControl fcnt2 = null;
        for (SFilterControl fcnt2 : this.iControls) {
            if (fcnt2.getColumnIndex() == colIndex && fcnt2.isFrom() == isFrom) break;
            fcnt2 = null;
        }
        return fcnt2;
    }

    private SFilterControl getControlForColumn(int colIndex, boolean isFrom) {
        SFilterControl fcnt = this.getControlForColumnNoCreate(colIndex, isFrom);
        if (fcnt == null) {
            fcnt = new SFilterControl(this, colIndex, isFrom);
            SActiveColorManager.handleActiveColorFor(fcnt);
            this.iControls.add(fcnt);
            this.add(fcnt);
            this.updateFocusTraversalPolicy();
        }
        return fcnt;
    }

    protected Component getNextFilterControl(Component c) {
        JComponent nc = null;
        if (c instanceof SFilterControl) {
            SFilterControl fcnt = (SFilterControl)c;
            int colIndex = fcnt.getColumnIndex();
            if (fcnt.isFrom()) {
                nc = this.getControlForColumnNoCreate(colIndex, false);
            } else {
                int ccidx = this.iTable.convertColumnIndexToView(colIndex);
                nc = this.iTable.getColumnModel().getColumnCount() > ccidx + 1 ? this.getControlForColumnNoCreate(this.iTable.convertColumnIndexToModel(ccidx + 1), true) : this.iTable;
            }
        } else if (c == this.iTable) {
            nc = this.getControlForColumnNoCreate(0, true);
        }
        return nc;
    }

    protected Component getPrevFilterControl(Component c) {
        JComponent nc = null;
        if (c instanceof SFilterControl) {
            int ccidx;
            SFilterControl fcnt = (SFilterControl)c;
            int colIndex = fcnt.getColumnIndex();
            nc = !fcnt.isFrom() ? this.getControlForColumnNoCreate(colIndex, true) : ((ccidx = this.iTable.convertColumnIndexToView(colIndex)) > 0 ? this.getControlForColumnNoCreate(this.iTable.convertColumnIndexToModel(ccidx - 1), false) : this.iTable);
        } else if (c == this.iTable) {
            nc = this.getControlForColumnNoCreate(0, false);
        }
        return nc;
    }

    private synchronized void delayedFilterChanged() {
        if (this.iTable.getRefreshManager().isRefreshing()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    STableFilterPanel.this.filterChanged();
                }
            });
            return;
        }
        TableColumnModel tcm = this.iTable.getColumnModel();
        if (tcm != null) {
            int i = 0;
            while (i < tcm.getColumnCount()) {
                TableColumn tc = tcm.getColumn(this.iTable.convertColumnIndexToView(i));
                int c = tc.getModelIndex();
                String f = this.getControlForColumn(c, true).getText();
                String t = this.getControlForColumn(c, false).getText();
                this.iTable.setColumnFilters(this.iTable.convertColumnIndexToView(i), f, t);
                ++i;
            }
        }
        this.iTable.revalidate();
        this.iTable.repaint();
        if (this.iTable.getModel().getRowCount() > 0 && this.iTable.getRowSorter(true) != null && this.iTable.getRowSorter(true) instanceof DefaultRowSorter) {
            TableRowSorter<SDefaultTableModel> srtr = this.iTable.getRowSorter(true);
            if (srtr.getRowFilter() == null) {
                srtr.setRowFilter(new SDefaultTableRowFilter());
            }
            srtr.sort();
        }
    }

    protected void filterChanged() {
        this.iTimer.restart();
    }

    private void addToPanel(SFilterControl cntrl, int colIndex, boolean isFrom, TableColumn tc) {
        int vidx = this.iTable.convertColumnIndexToView(colIndex);
        cntrl.setSize(tc.getWidth(), this.iTable.getRowHeight());
        int y = isFrom ? 0 : this.iTable.getRowHeight();
        int x = this.iTable.getCellRect((int)0, (int)vidx, (boolean)false).x + this.iTable.getRowHeaderWidth() - this.iTable.getVisibleRect().x;
        cntrl.setLocation(x, y);
        cntrl.setVisible(x >= this.iTable.getRowHeaderWidth());
    }

    private void addAnimatedPanel() {
        if (this.iAnimatedPanel == null) {
            this.iAnimatedPanel = new SAnimatedComponent();
            this.add(this.iAnimatedPanel);
            this.getTable().addRefreshListener(this.iAnimatedPanel);
        }
        this.iAnimatedPanel.setLocation(0, 0);
        this.iAnimatedPanel.setSize(this.iTable.getRowHeaderWidth(), this.iTable.getRowHeight() * 2);
        this.iAnimatedPanel.setVisible(true);
    }

    public void doReBuildFilterCells() {
        int h = 0;
        int w = 0;
        this.addAnimatedPanel();
        Rectangle r = this.getBounds();
        TableColumnModel tcm = this.iTable.getColumnModel();
        h = this.iTable.getRowHeight();
        if (tcm != null) {
            Enumeration<TableColumn> en = tcm.getColumns();
            while (en.hasMoreElements()) {
                TableColumn tc = en.nextElement();
                int c = tc.getModelIndex();
                SFilterControl fcntFrom = this.getControlForColumn(c, true);
                SFilterControl fcntTo = this.getControlForColumn(c, false);
                this.addToPanel(fcntFrom, c, true, tc);
                this.addToPanel(fcntTo, c, false, tc);
            }
        }
        r = this.iTable.getVisibleRect();
        w = r.width;
        h = this.iTable.getRowHeight() * 2;
        this.setPreferredSize(new Dimension(w, h));
        this.repaint();
        this.iRebuildPendingCount = 0;
    }

    public void reBuildFilterCells() {
        if (this.iRebuildPendingCount == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    STableFilterPanel.this.doReBuildFilterCells();
                }
            });
        }
        ++this.iRebuildPendingCount;
    }

    protected void checkRebuildFilterCells() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.reBuildFilterCells();
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.checkRebuildFilterCells();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        this.checkRebuildFilterCells();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.checkRebuildFilterCells();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        int c = e.getFromIndex();
        SFilterControl fcntFrom = this.getControlForColumn(c, true);
        SFilterControl fcntTo = this.getControlForColumn(c, false);
        if (fcntFrom != null) {
            this.remove(fcntFrom);
            this.iControls.remove(fcntFrom);
        }
        if (fcntTo != null) {
            this.remove(fcntTo);
            this.iControls.remove(fcntTo);
        }
        this.checkRebuildFilterCells();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        this.checkRebuildFilterCells();
    }

    @Override
    public void dispatchRefreshEvent(SRefreshEvent e) {
        if (e.getMode() == 1) {
            this.delayedFilterChanged();
        }
    }
}

