/*
 * Decompiled with CFR 0.152.
 */
package swiext.text;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SFormat {
    public static final int DEFAULT = 1;
    public static final int DISPLAY = 2;
    public static final int EDIT = 3;
    public static final int NULL = 4;
    static JFormattedTextField.AbstractFormatter iDefaultFormatter = new DefaultFormatter();

    private SFormat() {
    }

    public static JFormattedTextField.AbstractFormatter getFormatInstanceForValue(int dataType, int type, Locale locale) {
        if (type != 4) {
            switch (dataType) {
                case 21: 
                case 24: {
                    return new DateFormatter(DateFormat.getDateInstance(3, locale));
                }
                case 22: {
                    return new DateFormatter(DateFormat.getTimeInstance(2, locale));
                }
                case 23: {
                    return new DateFormatter(DateFormat.getDateTimeInstance(3, 2, locale));
                }
                case 11: {
                    return new NumberFormatter(NumberFormat.getIntegerInstance(locale));
                }
                case 12: {
                    if (type == 2 || type == 1) {
                        return new NumberFormatter(NumberFormat.getNumberInstance(locale));
                    }
                    return new NumberFormatter(NumberFormat.getIntegerInstance(locale));
                }
                case 13: {
                    if (type == 2 || type == 1) {
                        return new NumberFormatter(NumberFormat.getCurrencyInstance(locale));
                    }
                    return new NumberFormatter(NumberFormat.getIntegerInstance(locale));
                }
                case 14: {
                    if (type == 2 || type == 1) {
                        return new NumberFormatter(NumberFormat.getPercentInstance(locale));
                    }
                    return new NumberFormatter(NumberFormat.getIntegerInstance(locale));
                }
            }
            return iDefaultFormatter;
        }
        return null;
    }

    public static JFormattedTextField.AbstractFormatter getFormatInstanceForValue(int dataType, int type) {
        return SFormat.getFormatInstanceForValue(dataType, type, Locale.getDefault());
    }

    public static JFormattedTextField.AbstractFormatterFactory getFormatterFactoryForValue(int dataType, Locale locale) {
        JFormattedTextField.AbstractFormatter defaultFormatter = SFormat.getFormatInstanceForValue(dataType, 1, locale);
        JFormattedTextField.AbstractFormatter displayFormatter = SFormat.getFormatInstanceForValue(dataType, 2, locale);
        JFormattedTextField.AbstractFormatter editFormatter = SFormat.getFormatInstanceForValue(dataType, 3, locale);
        JFormattedTextField.AbstractFormatter nullFormatter = SFormat.getFormatInstanceForValue(dataType, 4, locale);
        if (defaultFormatter != null) {
            return new DefaultFormatterFactory(defaultFormatter, displayFormatter, editFormatter, nullFormatter);
        }
        return null;
    }
}

