/*
 * Decompiled with CFR 0.152.
 */
package swiext.windows;

import application.SApplication;
import awtext.SActiveColorManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import prefs.SPreferences;
import prefs.SPreferencesException;
import swiext.SDialog;

public class SEditConnectionsWindow
extends SDialog {
    private static final long serialVersionUID = 1L;
    private JScrollPane scpneMain = null;
    private JPanel pnlSelected;
    private JButton btnCancel;
    private JList lstAvailable;
    private JScrollPane scpneAvailable;
    private JPanel pnlContent = null;
    private JPanel pnlClientArea = null;
    private JToolBar tbStandard = null;
    private JButton btnOk = null;
    private JLabel lblName = null;
    private JLabel lblDriver = null;
    private JLabel lblUrl = null;
    private JTextField efName = null;
    private JComboBox cmbDriver = null;
    private JComboBox cmbUrl = null;
    private JLabel lblDatabase = null;
    private JTextField efDatabase = null;
    private boolean iChanged = false;
    private int iLastSelection = -1;
    private boolean iIgnoreListSelectionEvent = false;
    private JButton btnApply = null;
    private JButton btnRemove = null;
    private JButton btnCleanIni = null;

    public SEditConnectionsWindow(Window owner) {
        super(owner);
        this.initialize();
    }

    public boolean isChanged() {
        return this.iChanged;
    }

    public void setChanged(boolean changed) {
        this.iChanged = changed;
        if (this.getEfName().getText().length() > 0 && this.getEfDatabase().getText().length() > 0 && ((String)this.getCmbDriver().getSelectedItem()).length() > 0 && ((String)this.getCmbUrl().getSelectedItem()).length() > 0) {
            this.getBtnApply().setEnabled(this.isChanged());
        } else {
            this.getBtnApply().setEnabled(false);
        }
        this.getBtnCancel().setEnabled(this.isChanged());
        this.getBtnRemove().setEnabled(!this.isChanged());
    }

    public int showConfirmationDialogIfChanged(String message) {
        if (this.isChanged()) {
            return JOptionPane.showConfirmDialog(this, message, "Question", 1, 2);
        }
        return -1;
    }

    private String findPrefsKeyFor(SPreferences p, String val, String section) {
        String keyStem = section.substring(section.lastIndexOf(".") + 1);
        if (keyStem.length() > 2) {
            keyStem = keyStem.substring(0, keyStem.length() - 1);
        }
        int keyn = 1;
        String nkey = String.valueOf(keyStem) + keyn;
        try {
            List<String> keys = p.keyList(section);
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                String key = it.next();
                if (nkey.equals(key)) {
                    nkey = String.valueOf(keyStem) + ++keyn;
                    it = keys.iterator();
                    continue;
                }
                String v = p.get(key, section);
                if (!val.equals(v)) continue;
                return key;
            }
        }
        catch (SPreferencesException sPreferencesException) {
            // empty catch block
        }
        return nkey;
    }

    private void applyChanges() throws SPreferencesException {
        String name = this.getEfName().getText();
        String database = this.getEfDatabase().getText();
        String driver = (String)this.getCmbDriver().getSelectedItem();
        String url = (String)this.getCmbUrl().getSelectedItem();
        SPreferences p = SApplication.getSystemPrefs();
        String dkey = this.findPrefsKeyFor(p, driver, "jdbc.drivers");
        String ukey = this.findPrefsKeyFor(p, url, "jdbc.urls");
        p.put(ukey, url, "jdbc.urls");
        p.put(dkey, driver, "jdbc.drivers");
        p.put(name, String.valueOf(dkey) + ":" + ukey + ":" + database, "jdbc.databases");
        this.setChanged(false);
        this.fillAvailableList();
    }

    private void removeSelected() throws SPreferencesException {
        String sel = (String)this.getLstAvailable().getSelectedValue();
        if (sel != null && sel.length() > 0) {
            SApplication.getSystemPrefs().delKey(sel, "jdbc.databases");
        }
        this.fillAvailableList();
        if (this.getLstAvailable().getModel().getSize() > 0) {
            this.getLstAvailable().setSelectedIndex(0);
        }
    }

    private void cleanIni() throws SPreferencesException {
        String v;
        Iterator<String> id;
        boolean doDel;
        String s;
        SPreferences p = SApplication.getSystemPrefs();
        List<String> dblist = p.keyList("jdbc.databases");
        Iterator<String> it = p.keyList("jdbc.urls").iterator();
        while (it.hasNext()) {
            s = it.next();
            doDel = true;
            id = dblist.iterator();
            while (id.hasNext()) {
                v = p.get(id.next(), "jdbc.databases");
                if (!v.contains(":" + s + ":")) continue;
                doDel = false;
                break;
            }
            if (!doDel) continue;
            p.delKey(s, "jdbc.urls");
            it = p.keyList("jdbc.urls").iterator();
        }
        it = p.keyList("jdbc.drivers").iterator();
        while (it.hasNext()) {
            s = it.next();
            doDel = true;
            id = dblist.iterator();
            while (id.hasNext()) {
                v = p.get(id.next(), "jdbc.databases");
                if (!v.contains(String.valueOf(s) + ":")) continue;
                doDel = false;
                break;
            }
            if (!doDel) continue;
            p.delKey(s, "jdbc.drivers");
            it = p.keyList("jdbc.drivers").iterator();
        }
    }

    private void listItemSelected() {
        String val;
        if (this.iIgnoreListSelectionEvent) {
            this.getBtnRemove().setEnabled(true);
            return;
        }
        int o = this.showConfirmationDialogIfChanged("Some data are changed. Do you want to save all changes?");
        if (o >= 0) {
            if (o == 0 || o == 1) {
                if (o == 0) {
                    try {
                        this.applyChanges();
                    }
                    catch (SPreferencesException e) {
                        if (this.iLastSelection >= 0) {
                            this.iIgnoreListSelectionEvent = true;
                            this.getLstAvailable().setSelectedIndex(this.iLastSelection);
                            this.iIgnoreListSelectionEvent = false;
                            this.setChanged(true);
                        }
                    }
                }
            } else {
                if (this.iLastSelection >= 0) {
                    this.iIgnoreListSelectionEvent = true;
                    this.getLstAvailable().setSelectedIndex(this.iLastSelection);
                    this.iIgnoreListSelectionEvent = false;
                    this.setChanged(true);
                }
                return;
            }
        }
        SPreferences p = SApplication.getSystemPrefs();
        String sel = (String)this.getLstAvailable().getSelectedValue();
        if (sel != null && sel.length() > 0 && (val = p.tryGet(sel, "", "jdbc.databases")).length() > 0) {
            try {
                String drv = val.substring(0, val.indexOf(":"));
                String url = val.substring(val.indexOf(":") + 1, val.lastIndexOf(":"));
                String nme = val.substring(val.lastIndexOf(":") + 1);
                this.getEfName().setText(sel);
                this.getEfDatabase().setText(nme);
                this.getCmbDriver().setSelectedItem(p.tryGet(drv, "", "jdbc.drivers"));
                this.getCmbUrl().setSelectedItem(p.tryGet(url, "", "jdbc.urls"));
                this.setChanged(false);
                this.iLastSelection = this.getLstAvailable().getSelectedIndex();
                this.getBtnRemove().setEnabled(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void fillAvailableList() {
        SPreferences p = SApplication.getSystemPrefs();
        DefaultListModel lm = (DefaultListModel)this.getLstAvailable().getModel();
        if (this.getLstAvailable().getSelectedIndex() >= 0) {
            this.getLstAvailable().clearSelection();
        }
        try {
            lm.removeAllElements();
            List<String> keys = p.keyList("jdbc.databases");
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                lm.addElement(it.next());
            }
        }
        catch (SPreferencesException e) {
            lm.addElement(e.getMessage());
        }
    }

    private void fillCmb(JComboBox cmb, String section) {
        SPreferences p = SApplication.getSystemPrefs();
        cmb.removeAllItems();
        try {
            List<String> keys = p.keyList(section);
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                cmb.addItem(p.get(it.next(), section));
            }
        }
        catch (SPreferencesException e) {
            cmb.addItem(e.getMessage());
        }
    }

    private void fillCmbDriver() {
        this.fillCmb(this.getCmbDriver(), "jdbc.drivers");
    }

    private void fillCmbUrl() {
        this.fillCmb(this.getCmbUrl(), "jdbc.urls");
    }

    private void okPressed() {
        try {
            this.applyChanges();
            this.dispose();
        }
        catch (SPreferencesException e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        this.setName("Connections");
        this.setContentPane(this.getScpneMain());
        this.setTitle("Edit connections");
        this.pack();
        this.setSize(370, 250);
        this.getEfName().requestFocus();
        this.fillAvailableList();
        this.fillCmbDriver();
        this.fillCmbUrl();
        this.setChanged(false);
        if (this.getLstAvailable().getModel().getSize() > 0) {
            this.getLstAvailable().setSelectedIndex(0);
        }
        this.setChanged(false);
    }

    private JScrollPane getScpneMain() {
        if (this.scpneMain == null) {
            this.scpneMain = new JScrollPane();
            this.scpneMain.setViewportView(this.getPnlContent());
        }
        return this.scpneMain;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new BorderLayout());
            this.pnlContent.add((Component)this.getPnlClientArea(), "Center");
            this.pnlContent.add((Component)this.getTbStandard(), "South");
        }
        return this.pnlContent;
    }

    private JPanel getPnlClientArea() {
        if (this.pnlClientArea == null) {
            this.pnlClientArea = new JPanel();
            BorderLayout pnlClientAreaLayout = new BorderLayout();
            this.pnlClientArea.setLayout(pnlClientAreaLayout);
            this.pnlClientArea.add((Component)this.getScpneAvailable(), "West");
            this.pnlClientArea.add((Component)this.getPnlSelected(), "Center");
        }
        return this.pnlClientArea;
    }

    private JToolBar getTbStandard() {
        if (this.tbStandard == null) {
            this.tbStandard = new JToolBar();
            this.tbStandard.add(this.getBtnOk());
            this.tbStandard.add(this.getBtnCancel());
            this.tbStandard.add(this.getBtnApply());
            this.tbStandard.add(this.getBtnRemove());
            this.tbStandard.add(this.getBtnCleanIni());
        }
        return this.tbStandard;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText("OK");
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SEditConnectionsWindow.this.okPressed();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SEditConnectionsWindow.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JScrollPane getScpneAvailable() {
        if (this.scpneAvailable == null) {
            this.scpneAvailable = new JScrollPane();
            this.scpneAvailable.setViewportView(this.getLstAvailable());
        }
        return this.scpneAvailable;
    }

    private JList getLstAvailable() {
        if (this.lstAvailable == null) {
            this.lstAvailable = new JList();
            this.lstAvailable.setModel(new DefaultListModel());
            this.lstAvailable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SEditConnectionsWindow.this.listItemSelected();
                }
            });
        }
        return this.lstAvailable;
    }

    private JPanel getPnlSelected() {
        if (this.pnlSelected == null) {
            GridBagConstraints gbcLblName = new GridBagConstraints();
            gbcLblName.gridx = 0;
            gbcLblName.gridy = 0;
            GridBagConstraints gbcEfName = new GridBagConstraints();
            gbcEfName.fill = 1;
            gbcEfName.gridy = 0;
            gbcEfName.weightx = 1.0;
            gbcEfName.gridx = 1;
            GridBagConstraints gbcLblDatabase = new GridBagConstraints();
            gbcLblDatabase.gridx = 0;
            gbcLblDatabase.gridy = 1;
            GridBagConstraints gbcEfDatabase = new GridBagConstraints();
            gbcEfDatabase.fill = 1;
            gbcEfDatabase.gridy = 1;
            gbcEfDatabase.weightx = 1.0;
            gbcEfDatabase.gridx = 1;
            GridBagConstraints gbcLblDriver = new GridBagConstraints();
            gbcLblDriver.gridx = 0;
            gbcLblDriver.gridy = 2;
            GridBagConstraints gbcCmbDriver = new GridBagConstraints();
            gbcCmbDriver.fill = 1;
            gbcCmbDriver.gridy = 2;
            gbcCmbDriver.weightx = 1.0;
            gbcCmbDriver.gridx = 1;
            GridBagConstraints gbcLblUrl = new GridBagConstraints();
            gbcLblUrl.gridx = 0;
            gbcLblUrl.gridy = 3;
            GridBagConstraints gbcCmbUrl = new GridBagConstraints();
            gbcCmbUrl.fill = 1;
            gbcCmbUrl.gridy = 3;
            gbcCmbUrl.weightx = 1.0;
            gbcCmbUrl.gridx = 1;
            this.lblDatabase = new JLabel();
            this.lblDatabase.setText("Database");
            this.lblName = new JLabel();
            this.lblName.setText("Name");
            this.lblDriver = new JLabel();
            this.lblDriver.setText("Driver");
            this.lblUrl = new JLabel();
            this.lblUrl.setText("URL");
            this.pnlSelected = new JPanel();
            this.pnlSelected.setLayout(new GridBagLayout());
            this.pnlSelected.add((Component)this.lblName, gbcLblName);
            this.pnlSelected.add((Component)this.lblDatabase, gbcLblDatabase);
            this.pnlSelected.add((Component)this.lblDriver, gbcLblDriver);
            this.pnlSelected.add((Component)this.lblUrl, gbcLblUrl);
            this.pnlSelected.add((Component)this.getEfName(), gbcEfName);
            this.pnlSelected.add((Component)this.getEfDatabase(), gbcEfDatabase);
            this.pnlSelected.add((Component)this.getCmbDriver(), gbcCmbDriver);
            this.pnlSelected.add((Component)this.getCmbUrl(), gbcCmbUrl);
        }
        return this.pnlSelected;
    }

    private JTextField getEfName() {
        if (this.efName == null) {
            this.efName = new JTextField();
            this.efName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SEditConnectionsWindow.this.setChanged(true);
                }
            });
            SActiveColorManager.handleActiveColorFor(this.efName);
        }
        return this.efName;
    }

    private JComboBox getCmbDriver() {
        if (this.cmbDriver == null) {
            this.cmbDriver = new JComboBox();
            this.cmbDriver.setPreferredSize(new Dimension(20, 20));
            this.cmbDriver.setEditable(true);
            this.cmbDriver.setFont(new Font("Dialog", 0, 12));
            this.cmbDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SEditConnectionsWindow.this.setChanged(true);
                }
            });
            this.cmbDriver.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SEditConnectionsWindow.this.setChanged(true);
                }
            });
            SActiveColorManager.handleActiveColorFor(this.cmbDriver);
        }
        return this.cmbDriver;
    }

    private JComboBox getCmbUrl() {
        if (this.cmbUrl == null) {
            this.cmbUrl = new JComboBox();
            this.cmbUrl.setPreferredSize(new Dimension(20, 20));
            this.cmbUrl.setEditable(true);
            this.cmbUrl.setFont(new Font("Dialog", 0, 12));
            this.cmbUrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SEditConnectionsWindow.this.setChanged(true);
                }
            });
            this.cmbUrl.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SEditConnectionsWindow.this.setChanged(true);
                }
            });
            SActiveColorManager.handleActiveColorFor(this.cmbUrl);
        }
        return this.cmbUrl;
    }

    private JTextField getEfDatabase() {
        if (this.efDatabase == null) {
            this.efDatabase = new JTextField();
            this.efDatabase.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SEditConnectionsWindow.this.setChanged(true);
                }
            });
            SActiveColorManager.handleActiveColorFor(this.efDatabase);
        }
        return this.efDatabase;
    }

    private JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton();
            this.btnApply.setText("Apply");
            this.btnApply.setMnemonic(0);
            this.btnApply.setEnabled(false);
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SEditConnectionsWindow.this.applyChanges();
                    }
                    catch (SPreferencesException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.btnApply;
    }

    private JButton getBtnRemove() {
        if (this.btnRemove == null) {
            this.btnRemove = new JButton();
            this.btnRemove.setText("Remove");
            this.btnRemove.setEnabled(false);
            this.btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SEditConnectionsWindow.this.removeSelected();
                    }
                    catch (SPreferencesException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.btnRemove;
    }

    private JButton getBtnCleanIni() {
        if (this.btnCleanIni == null) {
            this.btnCleanIni = new JButton();
            this.btnCleanIni.setText("Clean INI");
            this.btnCleanIni.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        SEditConnectionsWindow.this.cleanIni();
                    }
                    catch (SPreferencesException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.btnCleanIni;
    }
}

