/*
 * Decompiled with CFR 0.152.
 */
package swiext.windows;

import application.SApplication;
import awtext.SActiveColorManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import prefs.SAbstractPreferences;
import prefs.SPreferences;
import prefs.SPreferencesEvent;
import prefs.SPreferencesException;
import prefs.SPreferencesListener;
import prefs.SPrefs;
import sql.SConnection;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import swiext.SDialog;
import swiext.windows.SEditConnectionsWindow;

public class SLoginWindow
extends SDialog
implements SPreferencesListener {
    private static final String EF_PASSWORD = "efPassword";
    private static final String EF_USERNAME = "efUsername";
    private static final String CMB_DATABASE = "cmbDatabase";
    private static final String JDBC_DATABASES = "jdbc.databases";
    private static final long serialVersionUID = 1L;
    private JScrollPane iScrollPane = null;
    private JPanel iContentPane = null;
    private JPanel iClientArea = null;
    private JPanel iButtonArea = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private JComboBox cmbDatabase = null;
    private JLabel lblDatabase = null;
    private JLabel lblUsername = null;
    private JTextField efUsername = null;
    private JLabel lblPassword = null;
    private JPasswordField efPassword = null;
    private JLabel lblStatus = null;
    private String iDatabase = null;
    private String iUsername = null;
    private String iPassword = null;
    private boolean iOkPressed = false;
    private JButton btnEditConnections = null;
    private boolean iEditConnectionsEnabled = true;

    public SLoginWindow(Frame frame) {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(382, 141));
        this.setContentPane(this.getIScrollPane());
        this.setTitle("Login");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.getBtnOk().setEnabled(false);
        this.setStatusText("", false);
        this.checkButtons();
        SAbstractPreferences p = (SAbstractPreferences)SApplication.getSystemPrefs();
        if (p != null) {
            p.addListener(this);
        }
    }

    private JScrollPane getIScrollPane() {
        if (this.iScrollPane == null) {
            this.iScrollPane = new JScrollPane();
            this.iScrollPane.setViewportView(this.getIContentPane());
        }
        return this.iScrollPane;
    }

    private JPanel getIContentPane() {
        if (this.iContentPane == null) {
            this.iContentPane = new JPanel();
            this.iContentPane.setLayout(new BorderLayout());
            this.iContentPane.add((Component)this.getIClientArea(), "North");
            this.iContentPane.add((Component)this.getIButtonArea(), "South");
        }
        return this.iContentPane;
    }

    private JPanel getIClientArea() {
        if (this.iClientArea == null) {
            GridBagConstraints gbcLblDatabase = new GridBagConstraints();
            gbcLblDatabase.fill = 2;
            gbcLblDatabase.gridx = 0;
            gbcLblDatabase.gridy = 0;
            GridBagConstraints gbcCmbDatabase = new GridBagConstraints();
            gbcCmbDatabase.fill = 2;
            gbcCmbDatabase.gridy = 0;
            gbcCmbDatabase.weightx = 1.0;
            gbcCmbDatabase.gridx = 1;
            GridBagConstraints gbcLblUsername = new GridBagConstraints();
            gbcLblUsername.fill = 2;
            gbcLblUsername.gridx = 0;
            gbcLblUsername.gridy = 1;
            GridBagConstraints gbcEfUsername = new GridBagConstraints();
            gbcEfUsername.fill = 2;
            gbcEfUsername.gridy = 1;
            gbcEfUsername.weightx = 1.0;
            gbcEfUsername.gridx = 1;
            GridBagConstraints gbcLblPassword = new GridBagConstraints();
            gbcLblPassword.fill = 2;
            gbcLblPassword.gridx = 0;
            gbcLblPassword.gridy = 2;
            GridBagConstraints gbcEfPassword = new GridBagConstraints();
            gbcEfPassword.fill = 2;
            gbcEfPassword.gridy = 2;
            gbcEfPassword.weightx = 1.0;
            gbcEfPassword.gridx = 1;
            GridBagConstraints gbcLblStatus = new GridBagConstraints();
            gbcLblStatus.gridx = 0;
            gbcLblStatus.gridy = 3;
            gbcLblStatus.anchor = 17;
            gbcLblStatus.fill = 2;
            gbcLblStatus.gridwidth = 2;
            this.lblDatabase = new JLabel();
            this.lblDatabase.setText("Database:");
            this.lblUsername = new JLabel();
            this.lblUsername.setText("Username:");
            this.lblPassword = new JLabel();
            this.lblPassword.setText("Password:");
            this.lblStatus = new JLabel();
            this.lblStatus.setText("Status:");
            this.iClientArea = new JPanel();
            this.iClientArea.setLayout(new GridBagLayout());
            this.iClientArea.add((Component)this.lblDatabase, gbcLblDatabase);
            this.iClientArea.add((Component)this.getCmbDatabase(), gbcCmbDatabase);
            this.iClientArea.add((Component)this.lblUsername, gbcLblUsername);
            this.iClientArea.add((Component)this.getEfUsername(), gbcEfUsername);
            this.iClientArea.add((Component)this.lblPassword, gbcLblPassword);
            this.iClientArea.add((Component)this.getEfPassword(), gbcEfPassword);
            this.iClientArea.add((Component)this.lblStatus, gbcLblStatus);
        }
        return this.iClientArea;
    }

    private JPanel getIButtonArea() {
        if (this.iButtonArea == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.iButtonArea = new JPanel();
            this.iButtonArea.setLayout(new GridBagLayout());
            this.iButtonArea.add((Component)this.getBtnOk(), gridBagConstraints);
            this.iButtonArea.add((Component)this.getBtnCancel(), gridBagConstraints1);
            this.iButtonArea.add((Component)this.getBtnEditConnections(), gridBagConstraints11);
        }
        return this.iButtonArea;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText("OK");
            this.btnOk.setSelected(true);
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SLoginWindow.this.okPressed();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SLoginWindow.this.cancelPressed();
                }
            });
        }
        return this.btnCancel;
    }

    private JComboBox getCmbDatabase() {
        if (this.cmbDatabase == null) {
            this.cmbDatabase = new JComboBox();
            this.cmbDatabase.setPreferredSize(new Dimension(20, 20));
            this.cmbDatabase.setFont(new Font("Dialog", 0, 12));
            this.cmbDatabase.setToolTipText("Type name of database here or choose one from the list");
            this.cmbDatabase.setName(CMB_DATABASE);
            this.cmbDatabase.setEditable(true);
            this.cmbDatabase.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SLoginWindow.this.checkButtons();
                }
            });
            this.cmbDatabase.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SLoginWindow.this.checkButtons();
                }
            });
            SActiveColorManager.handleActiveColorFor(this.cmbDatabase);
        }
        return this.cmbDatabase;
    }

    private JTextField getEfUsername() {
        if (this.efUsername == null) {
            this.efUsername = new JTextField();
            this.efUsername.setToolTipText("Type your username here");
            this.efUsername.setName(EF_USERNAME);
            this.efUsername.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    SLoginWindow.this.checkButtons();
                }
            });
            SActiveColorManager.handleActiveColorFor(this.efUsername);
        }
        return this.efUsername;
    }

    private JPasswordField getEfPassword() {
        if (this.efPassword == null) {
            this.efPassword = new JPasswordField();
            this.efPassword.setToolTipText("Type your password here");
            this.efPassword.setName(EF_PASSWORD);
            SActiveColorManager.handleActiveColorFor(this.efPassword);
        }
        return this.efPassword;
    }

    public String getDatabase() {
        return this.iDatabase;
    }

    public void setDatabase(String database) {
        this.iDatabase = database;
    }

    public String getUsername() {
        return this.iUsername;
    }

    public void setUsername(String username) {
        this.iUsername = username;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public boolean isOkPressed() {
        return this.iOkPressed;
    }

    public void setOkPressed(boolean okPressed) {
        this.iOkPressed = okPressed;
    }

    private void fillComboBoxes() {
        try {
            this.getCmbDatabase().removeAllItems();
            SPreferences sp = SPrefs.getPreferencesInstance(null, 17);
            List<String> databases = sp.keyList(JDBC_DATABASES);
            if (databases != null) {
                for (String db : databases) {
                    this.getCmbDatabase().addItem(db);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readState(SPreferences p, String section) {
        this.fillComboBoxes();
        try {
            this.getCmbDatabase().getEditor().setItem(p.tryGet(CMB_DATABASE, "DEMO", section));
            this.getEfUsername().setText(p.tryGet(EF_USERNAME, "SYSADM", section));
            String pw = p.tryGet(EF_PASSWORD, "", section);
            if (pw.length() <= 0) {
                pw = "PASSWORD";
            } else {
                int c = 3;
                while (c > 0) {
                    pw = new String(new BASE64Decoder().decodeBuffer(pw));
                    --c;
                }
            }
            this.getEfPassword().setText(pw);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void writeState(SPreferences p, String section) {
        try {
            p.tryPut(CMB_DATABASE, this.getCmbText(this.getCmbDatabase()), section);
            p.tryPut(EF_USERNAME, this.getEfUsername().getText(), section);
            String pw = new String(this.getEfPassword().getPassword());
            int c = 3;
            while (c > 0) {
                pw = new BASE64Encoder().encode(pw.getBytes());
                --c;
            }
            p.tryPut(EF_PASSWORD, pw, section);
        }
        catch (Exception e) {
            this.getBtnCancel();
        }
        ((SAbstractPreferences)SApplication.getSystemPrefs()).removeListener(this);
    }

    private String getCmbText(JComboBox cmb) {
        return (String)cmb.getEditor().getItem();
    }

    private void delayedCheckButtons() {
        if (this.getCmbText(this.getCmbDatabase()).length() > 0 && this.getEfUsername().getText().length() > 0) {
            this.getBtnOk().setEnabled(true);
            this.getRootPane().setDefaultButton(this.getBtnOk());
        } else {
            this.getBtnOk().setEnabled(false);
            this.getRootPane().setDefaultButton(null);
        }
    }

    private void checkButtons() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SLoginWindow.this.delayedCheckButtons();
            }
        });
    }

    private void setAllFieldsEnabled(boolean enabled) {
        this.getCmbDatabase().setEnabled(enabled);
        this.getEfUsername().setEnabled(enabled);
        this.getEfPassword().setEnabled(enabled);
        this.getBtnOk().setEnabled(enabled);
        this.getBtnCancel().setEnabled(enabled);
    }

    private void connectStep2() {
        this.setAllFieldsEnabled(true);
        this.setOkPressed(true);
        this.dispose();
    }

    private void connectStep1() {
        try {
            String driver = "";
            String url = "";
            String dbsettings = "";
            String dbentry = "";
            SConnection c = null;
            this.setUsername(this.getEfUsername().getText());
            this.setPassword(new String(this.getEfPassword().getPassword()));
            dbentry = this.getCmbText(this.getCmbDatabase());
            SPreferences p = SPrefs.getPreferencesInstance(null, 17);
            dbsettings = p.get(dbentry, JDBC_DATABASES);
            int fi = dbsettings.indexOf(":");
            int li = dbsettings.lastIndexOf(":");
            if (fi > 0 && li > 0 && fi != li) {
                driver = dbsettings.substring(0, fi);
                url = dbsettings.substring(fi + 1, li);
                this.setDatabase(dbsettings.substring(li + 1));
                driver = p.get(driver, "jdbc.drivers");
                url = p.get(url, "jdbc.urls");
                c = new SConnection(driver, this.getDatabase(), url, this.getUsername(), this.getPassword());
                SConnection.setApplicationDefault(c);
                this.setStatusText("Checking database...", true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SLoginWindow.this.connectStep2();
                    }
                });
            } else {
                this.setStatusText("Invalid description file " + p.getName(), true);
                this.setAllFieldsEnabled(true);
            }
        }
        catch (Exception e) {
            this.setStatusText("Unable to connect:" + e.getMessage(), true);
            this.setAllFieldsEnabled(true);
        }
    }

    private void okPressed() {
        this.setStatusText("Connecting ...", true);
        this.setAllFieldsEnabled(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SLoginWindow.this.connectStep1();
            }
        });
    }

    private void cancelPressed() {
        this.setStatusText("Window closing", true);
        this.setOkPressed(false);
        this.dispose();
    }

    private void setStatusText(String text, boolean alert) {
        if (text == null) {
            text = new String("");
        }
        this.lblStatus.setText(text);
        if (alert) {
            this.lblStatus.setForeground(Color.RED);
        } else {
            this.lblStatus.setForeground(SystemColor.controlText);
        }
    }

    private JButton getBtnEditConnections() {
        if (this.btnEditConnections == null) {
            this.btnEditConnections = new JButton();
            this.btnEditConnections.setText("Connections..");
            this.btnEditConnections.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SLoginWindow.this.editConnections();
                }
            });
            this.btnEditConnections.setEnabled(this.iEditConnectionsEnabled);
        }
        return this.btnEditConnections;
    }

    public boolean isEditConnectionsEnabled() {
        return this.iEditConnectionsEnabled;
    }

    public void setEditConnectionsEnabled(boolean editConnectionsEnabled) {
        this.iEditConnectionsEnabled = editConnectionsEnabled;
        this.getBtnEditConnections().setEnabled(this.iEditConnectionsEnabled);
    }

    private void editConnections() {
        SEditConnectionsWindow d = new SEditConnectionsWindow((Window)this);
        d.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        ((Dialog)d).setVisible(true);
    }

    @Override
    public void dispatchEvent(SPreferencesEvent evt) throws SPreferencesException {
        if (evt.getMode() == 2 && (evt.getAction() == 4 || evt.getAction() == 7 || evt.getAction() == 8)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SLoginWindow.this.fillComboBoxes();
                }
            });
        }
    }
}

