/*
 * Decompiled with CFR 0.152.
 */
package swiext.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import swiext.SDialog;
import swiext.table.SColumnVisibilityListener;
import swiext.table.STable;

public class STableColumnDialog
extends SDialog
implements TableColumnModelListener,
RowSorterListener,
SColumnVisibilityListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrlContent = null;
    private JPanel pnlContent = null;
    private JPanel pnlButtonArea = null;
    private JButton btnOk = null;
    private JButton btnCancel = null;
    private JButton btnApply = null;
    private JTabbedPane tpContent = null;
    private JPanel pnlClientAreaColumns = null;
    private JPanel pnlCOAvailableColumns = null;
    private JList lstCOAvailable = null;
    private JPanel pnlCOARButtons = null;
    private JButton btnCOAdd = null;
    private JButton btnCORemove = null;
    private JPanel pnlCOCurrent = null;
    private JList lstCOCurrent = null;
    private JPanel pnlCOORButtons = null;
    private JButton btnCOUp = null;
    private JButton btnCODown = null;
    private JPanel pnlClientAreaSortOrder = null;
    private JPanel pnlSOAvailableColumns = null;
    private JList lstSOAvailable = null;
    private JPanel pnlSOARButtons = null;
    private JButton btnSOAdd = null;
    private JButton btnSORemove = null;
    private JPanel pnlSOCurrent = null;
    private JList lstSOCurrent = null;
    private JPanel pnlSOORButtons = null;
    private JButton btnSOAsc = null;
    private JButton btnSODesc = null;
    private JButton btnSOUp = null;
    private JButton btnSODown = null;
    private STable iTable = null;
    private JScrollPane spneCOAvialable = null;
    private JScrollPane spneCOCurrent = null;
    private JScrollPane spneSOAvailable = null;
    private JScrollPane spneSOCurrent = null;
    private List<RowSorter.SortKey> iSavedSort = null;
    private List<String> iSavedVisibleColumns = new ArrayList<String>();
    private boolean iSettingsChanged = false;
    private JButton btnRestore = null;

    public void saveInitialValues(STable table) {
        this.setSettingsChanged(false);
        this.iSavedSort = this.getClonedSortkeyList();
        this.iSavedVisibleColumns.clear();
        if (table == null) {
            return;
        }
        TableColumnModel cm = table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            String txt = c.getHeaderValue().toString();
            if (table.isColumnVisible(c)) {
                this.iSavedVisibleColumns.add(txt);
            }
            ++i;
        }
    }

    public void restoreInitialValues(STable table) {
        int i;
        TableColumn tc;
        String txt;
        this.setSettingsChanged(false);
        this.getTable().getRowSorter(true).setSortKeys(this.iSavedSort);
        if (table == null) {
            return;
        }
        TableColumnModel cm = table.getColumnModel();
        int c = 0;
        while (c < this.iSavedVisibleColumns.size()) {
            txt = this.iSavedVisibleColumns.get(c);
            tc = cm.getColumn(c);
            if (!tc.getHeaderValue().equals(txt)) {
                i = c + 1;
                while (i < cm.getColumnCount()) {
                    if (cm.getColumn(i).getHeaderValue().equals(txt)) {
                        table.moveColumn(i, c);
                        break;
                    }
                    ++i;
                }
            }
            ++c;
        }
        i = 0;
        while (i < cm.getColumnCount()) {
            tc = cm.getColumn(i);
            txt = tc.getHeaderValue().toString();
            table.setColumnVisible(tc, this.iSavedVisibleColumns.contains(txt));
            ++i;
        }
    }

    private static void fillCOLists(STable table, JList alst, JList clst) {
        DefaultListModel alm = (DefaultListModel)alst.getModel();
        DefaultListModel clm = (DefaultListModel)clst.getModel();
        alm.removeAllElements();
        clm.removeAllElements();
        if (table == null) {
            return;
        }
        TableColumnModel cm = table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            String txt = c.getHeaderValue().toString();
            if (table.isColumnVisible(c)) {
                clm.addElement(txt);
            } else {
                alm.addElement(txt);
            }
            ++i;
        }
    }

    private static void fillSOLists(STable table, JList alst, JList clst) {
        DefaultListModel alm = (DefaultListModel)alst.getModel();
        DefaultListModel clm = (DefaultListModel)clst.getModel();
        alm.removeAllElements();
        clm.removeAllElements();
        if (table == null) {
            return;
        }
        TableColumnModel cm = table.getColumnModel();
        ListIterator<RowSorter.SortKey> it = table.getRowSorter(true).getSortKeys().listIterator();
        Vector<String> sortKeys = new Vector<String>();
        while (it.hasNext()) {
            RowSorter.SortKey ky = (RowSorter.SortKey)it.next();
            try {
                TableColumn c = cm.getColumn(table.convertColumnIndexToModel(ky.getColumn()));
                clm.addElement(String.valueOf(c.getHeaderValue().toString()) + " = " + ky.getSortOrder().toString());
                sortKeys.add(c.getHeaderValue().toString());
            }
            catch (ArrayIndexOutOfBoundsException c) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            String txt = c.getHeaderValue().toString();
            if (!sortKeys.contains(txt)) {
                alm.addElement(txt);
            }
            ++i;
        }
    }

    private void refillLists() {
        STableColumnDialog.fillCOLists(this.getTable(), this.getLstCOAvailable(), this.getLstCOCurrent());
        STableColumnDialog.fillSOLists(this.getTable(), this.getLstSOAvailable(), this.getLstSOCurrent());
        this.checkButtonsCO();
        this.checkButtonsSO();
    }

    private void checkCommonButtons() {
        this.getBtnApply().setEnabled(this.isSettingsChanged());
        this.getBtnRestore().setEnabled(this.isSettingsChanged());
        this.getBtnOk().setEnabled(this.isSettingsChanged());
    }

    private void checkButtonsCO() {
        this.getBtnCOAdd().setEnabled(this.getLstCOAvailable().getSelectedIndex() >= 0);
        this.getBtnCORemove().setEnabled(this.getLstCOCurrent().getSelectedIndex() >= 0);
        if (this.getLstCOCurrent().getSelectedIndex() >= 0) {
            this.getBtnCOUp().setEnabled(this.getLstCOCurrent().getSelectedIndex() > 0);
            this.getBtnCODown().setEnabled(this.getLstCOCurrent().getSelectedIndex() < this.getLstCOCurrent().getModel().getSize() - 1);
        } else {
            this.getBtnCOUp().setEnabled(false);
            this.getBtnCODown().setEnabled(false);
        }
        this.checkCommonButtons();
    }

    private void checkButtonsSO() {
        this.getBtnSOAdd().setEnabled(this.getLstSOAvailable().getSelectedIndex() >= 0);
        this.getBtnSORemove().setEnabled(this.getLstSOCurrent().getSelectedIndex() >= 0);
        if (this.getLstSOCurrent().getSelectedIndex() >= 0) {
            this.getBtnSOUp().setEnabled(this.getLstSOCurrent().getSelectedIndex() > 0);
            this.getBtnSODown().setEnabled(this.getLstSOCurrent().getSelectedIndex() < this.getLstSOCurrent().getModel().getSize() - 1);
            String st = this.getLstSOCurrent().getModel().getElementAt(this.getLstSOCurrent().getSelectedIndex()).toString();
            this.getBtnSOAsc().setEnabled(st.indexOf(" = ASCENDING") < 0);
            this.getBtnSODesc().setEnabled(st.indexOf(" = ASCENDING") >= 0);
        } else {
            this.getBtnSOUp().setEnabled(false);
            this.getBtnSODown().setEnabled(false);
            this.getBtnSOAsc().setEnabled(false);
            this.getBtnSODesc().setEnabled(false);
        }
        this.checkCommonButtons();
    }

    private static TableColumn getTableColumnWithHeaderValue(STable table, String headerValue) throws NoSuchElementException {
        TableColumnModel cm = table.getColumnModel();
        int i = 0;
        while (i < cm.getColumnCount()) {
            TableColumn c = cm.getColumn(i);
            if (c.getHeaderValue().toString().equals(headerValue)) {
                return c;
            }
            ++i;
        }
        throw new NoSuchElementException(headerValue);
    }

    private void addCO() {
        String txt = this.getLstCOAvailable().getSelectedValue().toString();
        try {
            TableColumn c = STableColumnDialog.getTableColumnWithHeaderValue(this.getTable(), txt);
            this.getTable().setColumnVisible(c, true);
            this.getLstCOCurrent().setSelectedValue(txt, true);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.setSettingsChanged(true);
    }

    private void removeCO() {
        String txt = this.getLstCOCurrent().getSelectedValue().toString();
        try {
            TableColumn c = STableColumnDialog.getTableColumnWithHeaderValue(this.getTable(), txt);
            this.getTable().setColumnVisible(c, false);
            this.getLstCOAvailable().setSelectedValue(txt, true);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.setSettingsChanged(true);
    }

    private void upCO() {
        try {
            int idx = this.getLstCOCurrent().getSelectedIndex();
            this.getTable().moveColumn(idx, idx - 1);
            this.getLstCOCurrent().setSelectedIndex(idx - 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.setSettingsChanged(true);
    }

    private void downCO() {
        try {
            int idx = this.getLstCOCurrent().getSelectedIndex();
            this.getTable().moveColumn(idx, idx + 1);
            this.getLstCOCurrent().setSelectedIndex(idx + 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.setSettingsChanged(true);
    }

    private List<RowSorter.SortKey> getClonedSortkeyList() {
        ArrayList<RowSorter.SortKey> l = new ArrayList<RowSorter.SortKey>();
        ListIterator<RowSorter.SortKey> it = this.iTable.getRowSorter(true).getSortKeys().listIterator();
        while (it.hasNext()) {
            l.add((RowSorter.SortKey)it.next());
        }
        return l;
    }

    private String getCurrentSOTxt(JList jl) {
        String txt = jl.getSelectedValue().toString();
        if (txt.indexOf(" = ") > 0) {
            txt = txt.substring(0, txt.indexOf(" = "));
        }
        return txt;
    }

    private void addSO() {
        int ci;
        String txt = this.getCurrentSOTxt(this.getLstSOAvailable());
        try {
            ci = this.iTable.getColumnModel().getColumnIndex(txt);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        try {
            List<RowSorter.SortKey> l = this.getClonedSortkeyList();
            RowSorter.SortKey ky = new RowSorter.SortKey(ci, SortOrder.ASCENDING);
            l.add(ky);
            this.iTable.getRowSorter(true).setSortKeys(l);
            txt = String.valueOf(txt) + " = ASCENDING";
            this.getLstCOCurrent().setSelectedValue(txt, true);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.setSettingsChanged(true);
    }

    private void removeSO() {
        int ci;
        String txt = this.getCurrentSOTxt(this.getLstSOCurrent());
        try {
            ci = this.iTable.getColumnModel().getColumnIndex(txt);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        try {
            List<RowSorter.SortKey> l = this.getClonedSortkeyList();
            for (RowSorter.SortKey ky : l) {
                if (ky.getColumn() != ci) continue;
                l.remove(ky);
                break;
            }
            if (!l.isEmpty()) {
                this.iTable.getRowSorter(true).setSortKeys(l);
            } else {
                this.iTable.getRowSorter(true).setSortKeys(null);
            }
            this.getLstSOAvailable().setSelectedValue(txt, true);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.setSettingsChanged(true);
    }

    private void changeToSortOrder(SortOrder order) {
        int ci;
        int cseli = this.getLstSOCurrent().getSelectedIndex();
        String txt = this.getCurrentSOTxt(this.getLstSOCurrent());
        try {
            ci = this.iTable.getColumnModel().getColumnIndex(txt);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        try {
            List<RowSorter.SortKey> l = this.getClonedSortkeyList();
            int i = 0;
            while (i < l.size()) {
                RowSorter.SortKey ky = l.get(i);
                if (ky.getColumn() == ci) {
                    RowSorter.SortKey nky = new RowSorter.SortKey(ci, order);
                    l.remove(i);
                    l.add(i, nky);
                    this.iTable.getRowSorter(true).setSortKeys(l);
                    break;
                }
                ++i;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.getLstSOCurrent().setSelectedIndex(cseli);
        this.setSettingsChanged(true);
    }

    private void changeToAscending() {
        this.changeToSortOrder(SortOrder.ASCENDING);
    }

    private void changeToDescending() {
        this.changeToSortOrder(SortOrder.DESCENDING);
    }

    private void upSO() {
        int ci;
        String txt = this.getCurrentSOTxt(this.getLstSOCurrent());
        try {
            ci = this.iTable.getColumnModel().getColumnIndex(txt);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        List<RowSorter.SortKey> l = this.getClonedSortkeyList();
        int i = 0;
        while (i < l.size()) {
            if (l.get(i).getColumn() == ci) {
                RowSorter.SortKey k1 = l.get(i);
                RowSorter.SortKey k2 = l.get(i - 1);
                l.remove(i);
                l.remove(i - 1);
                l.add(i - 1, k1);
                l.add(i, k2);
                this.iTable.getRowSorter(true).setSortKeys(l);
                txt = String.valueOf(txt) + " = " + (Object)((Object)k1.getSortOrder());
                this.getLstSOCurrent().setSelectedValue(txt, true);
                break;
            }
            ++i;
        }
        this.setSettingsChanged(true);
    }

    private void downSO() {
        int ci;
        String txt = this.getCurrentSOTxt(this.getLstSOCurrent());
        try {
            ci = this.iTable.getColumnModel().getColumnIndex(txt);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        List<RowSorter.SortKey> l = this.getClonedSortkeyList();
        int i = 0;
        while (i < l.size()) {
            if (l.get(i).getColumn() == ci) {
                RowSorter.SortKey k1 = l.get(i);
                RowSorter.SortKey k2 = l.get(i + 1);
                l.remove(i + 1);
                l.remove(i);
                l.add(i, k2);
                l.add(i + 1, k1);
                this.iTable.getRowSorter(true).setSortKeys(l);
                txt = String.valueOf(txt) + " = " + (Object)((Object)k1.getSortOrder());
                this.getLstSOCurrent().setSelectedValue(txt, true);
                break;
            }
            ++i;
        }
        this.setSettingsChanged(true);
    }

    public boolean isSettingsChanged() {
        return this.iSettingsChanged;
    }

    public void setSettingsChanged(boolean settingsChanged) {
        if (this.iSettingsChanged != settingsChanged) {
            this.iSettingsChanged = settingsChanged;
            this.checkCommonButtons();
        }
    }

    public STable getTable() {
        return this.iTable;
    }

    public void setTable(STable table) {
        if (this.iTable != null) {
            this.iTable.getRowSorter().removeRowSorterListener(this);
            this.iTable.getColumnModel().removeColumnModelListener(this);
            this.iTable.removeColumnVisibilityListener(this);
        }
        this.iTable = table;
        this.refillLists();
        this.saveInitialValues(this.iTable);
        if (this.iTable != null) {
            this.iTable.getRowSorter().addRowSorterListener(this);
            this.iTable.getColumnModel().addColumnModelListener(this);
            this.iTable.addColumnVisibilityListener(this);
        }
    }

    public STableColumnDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(440, 386);
        this.setTitle("Table column settings");
        this.setContentPane(this.getScrlContent());
    }

    private JScrollPane getScrlContent() {
        if (this.scrlContent == null) {
            this.scrlContent = new JScrollPane();
            this.scrlContent.setViewportView(this.getPnlContent());
        }
        return this.scrlContent;
    }

    private JPanel getPnlContent() {
        if (this.pnlContent == null) {
            GridBagConstraints gbcContent = new GridBagConstraints();
            gbcContent.fill = 1;
            gbcContent.weighty = 1.0;
            gbcContent.weightx = 1.0;
            GridBagConstraints gbcButtons = new GridBagConstraints();
            gbcButtons.fill = 0;
            gbcButtons.gridy = 1;
            gbcButtons.gridx = 0;
            this.pnlContent = new JPanel();
            this.pnlContent.setLayout(new GridBagLayout());
            this.pnlContent.add((Component)this.getTpContent(), gbcContent);
            this.pnlContent.add((Component)this.getPnlButtonArea(), gbcButtons);
        }
        return this.pnlContent;
    }

    private JPanel getPnlButtonArea() {
        if (this.pnlButtonArea == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 3;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.pnlButtonArea = new JPanel();
            this.pnlButtonArea.setLayout(new GridBagLayout());
            this.pnlButtonArea.add((Component)this.getBtnOk(), new GridBagConstraints());
            this.pnlButtonArea.add((Component)this.getBtnCancel(), gridBagConstraints);
            this.pnlButtonArea.add((Component)this.getBtnApply(), gridBagConstraints1);
            this.pnlButtonArea.add((Component)this.getBtnRestore(), gridBagConstraints11);
        }
        return this.pnlButtonArea;
    }

    private JButton getBtnOk() {
        if (this.btnOk == null) {
            this.btnOk = new JButton();
            this.btnOk.setText("OK");
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.dispose();
                }
            });
        }
        return this.btnOk;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.restoreInitialValues(STableColumnDialog.this.getTable());
                    STableColumnDialog.this.dispose();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnApply() {
        if (this.btnApply == null) {
            this.btnApply = new JButton();
            this.btnApply.setText("Apply");
            this.btnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.saveInitialValues(STableColumnDialog.this.getTable());
                }
            });
        }
        return this.btnApply;
    }

    private JButton getBtnRestore() {
        if (this.btnRestore == null) {
            this.btnRestore = new JButton();
            this.btnRestore.setText("Restore");
            this.btnRestore.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.restoreInitialValues(STableColumnDialog.this.getTable());
                }
            });
        }
        return this.btnRestore;
    }

    private JTabbedPane getTpContent() {
        if (this.tpContent == null) {
            this.tpContent = new JTabbedPane();
            this.tpContent.addTab("Columns", null, this.getPnlClientAreaColumns(), null);
            this.tpContent.addTab("Sort Oder", null, this.getPnlClientAreaSortOrder(), null);
        }
        return this.tpContent;
    }

    private JPanel getPnlClientAreaColumns() {
        if (this.pnlClientAreaColumns == null) {
            GridBagConstraints gbcAvailable = new GridBagConstraints();
            gbcAvailable.fill = 1;
            gbcAvailable.gridy = 0;
            gbcAvailable.weightx = 1.0;
            gbcAvailable.weighty = 1.0;
            gbcAvailable.gridx = 0;
            GridBagConstraints gbcAR = new GridBagConstraints();
            gbcAR.gridx = 1;
            gbcAR.gridy = 0;
            GridBagConstraints gbcCurrent = new GridBagConstraints();
            gbcCurrent.fill = 1;
            gbcCurrent.gridy = 0;
            gbcCurrent.weightx = 1.0;
            gbcCurrent.weighty = 1.0;
            gbcCurrent.gridx = 2;
            this.pnlClientAreaColumns = new JPanel();
            this.pnlClientAreaColumns.setLayout(new GridBagLayout());
            this.pnlClientAreaColumns.setPreferredSize(new Dimension(250, 100));
            this.pnlClientAreaColumns.add((Component)this.getPnlCOAvailableColumns(), gbcAvailable);
            this.pnlClientAreaColumns.add((Component)this.getPnlCOARButtons(), gbcAR);
            this.pnlClientAreaColumns.add((Component)this.getPnlCOCurrent(), gbcCurrent);
            this.pnlClientAreaColumns.add((Component)this.getPnlCOORButtons(), new GridBagConstraints());
        }
        return this.pnlClientAreaColumns;
    }

    private JPanel getPnlCOAvailableColumns() {
        if (this.pnlCOAvailableColumns == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridx = 0;
            this.pnlCOAvailableColumns = new JPanel();
            this.pnlCOAvailableColumns.setLayout(new GridBagLayout());
            this.pnlCOAvailableColumns.setBorder(BorderFactory.createTitledBorder(null, "Available Columns", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlCOAvailableColumns.setPreferredSize(new Dimension(125, 100));
            this.pnlCOAvailableColumns.add((Component)this.getSpneCOAvialable(), gridBagConstraints3);
        }
        return this.pnlCOAvailableColumns;
    }

    private JList getLstCOAvailable() {
        if (this.lstCOAvailable == null) {
            this.lstCOAvailable = new JList();
            this.lstCOAvailable.setSelectionMode(0);
            this.lstCOAvailable.setModel(new DefaultListModel());
            this.lstCOAvailable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    STableColumnDialog.this.checkButtonsCO();
                }
            });
        }
        return this.lstCOAvailable;
    }

    private JPanel getPnlCOARButtons() {
        if (this.pnlCOARButtons == null) {
            GridBagConstraints gbcRemove = new GridBagConstraints();
            gbcRemove.gridx = 0;
            gbcRemove.gridy = 1;
            GridBagConstraints gbcAdd = new GridBagConstraints();
            gbcAdd.gridx = 0;
            gbcAdd.gridy = 0;
            this.pnlCOARButtons = new JPanel();
            this.pnlCOARButtons.setLayout(new GridBagLayout());
            this.pnlCOARButtons.add((Component)this.getBtnCOAdd(), gbcAdd);
            this.pnlCOARButtons.add((Component)this.getBtnCORemove(), gbcRemove);
        }
        return this.pnlCOARButtons;
    }

    private JButton getBtnCOAdd() {
        if (this.btnCOAdd == null) {
            this.btnCOAdd = new JButton();
            this.btnCOAdd.setEnabled(false);
            this.btnCOAdd.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/list-add.png")));
            this.btnCOAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.addCO();
                }
            });
        }
        return this.btnCOAdd;
    }

    private JButton getBtnCORemove() {
        if (this.btnCORemove == null) {
            this.btnCORemove = new JButton();
            this.btnCORemove.setEnabled(false);
            this.btnCORemove.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/list-remove.png")));
            this.btnCORemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.removeCO();
                }
            });
        }
        return this.btnCORemove;
    }

    private JPanel getPnlCOCurrent() {
        if (this.pnlCOCurrent == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.gridx = 0;
            this.pnlCOCurrent = new JPanel();
            this.pnlCOCurrent.setLayout(new GridBagLayout());
            this.pnlCOCurrent.setBorder(BorderFactory.createTitledBorder(null, "Current Columns", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlCOCurrent.setPreferredSize(new Dimension(125, 100));
            this.pnlCOCurrent.add((Component)this.getSpneCOCurrent(), gridBagConstraints4);
        }
        return this.pnlCOCurrent;
    }

    private JList getLstCOCurrent() {
        if (this.lstCOCurrent == null) {
            this.lstCOCurrent = new JList();
            this.lstCOCurrent.setSelectionMode(0);
            this.lstCOCurrent.setModel(new DefaultListModel());
            this.lstCOCurrent.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    STableColumnDialog.this.checkButtonsCO();
                }
            });
        }
        return this.lstCOCurrent;
    }

    private JPanel getPnlCOORButtons() {
        if (this.pnlCOORButtons == null) {
            GridBagConstraints gbcDown = new GridBagConstraints();
            gbcDown.fill = 2;
            gbcDown.gridy = 4;
            gbcDown.gridx = 0;
            GridBagConstraints gbcUp = new GridBagConstraints();
            gbcUp.fill = 2;
            gbcUp.gridy = 3;
            gbcUp.gridx = 0;
            this.pnlCOORButtons = new JPanel();
            this.pnlCOORButtons.setLayout(new GridBagLayout());
            this.pnlCOORButtons.add((Component)this.getBtnCOUp(), gbcUp);
            this.pnlCOORButtons.add((Component)this.getBtnCODown(), gbcDown);
        }
        return this.pnlCOORButtons;
    }

    private JButton getBtnCOUp() {
        if (this.btnCOUp == null) {
            this.btnCOUp = new JButton();
            this.btnCOUp.setEnabled(false);
            this.btnCOUp.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/go-up.png")));
            this.btnCOUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.upCO();
                }
            });
        }
        return this.btnCOUp;
    }

    private JButton getBtnCODown() {
        if (this.btnCODown == null) {
            this.btnCODown = new JButton();
            this.btnCODown.setEnabled(false);
            this.btnCODown.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/go-down.png")));
            this.btnCODown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.downCO();
                }
            });
        }
        return this.btnCODown;
    }

    private JPanel getPnlClientAreaSortOrder() {
        if (this.pnlClientAreaSortOrder == null) {
            GridBagConstraints gbcCurrent1 = new GridBagConstraints();
            gbcCurrent1.fill = 1;
            gbcCurrent1.gridy = 0;
            gbcCurrent1.weightx = 1.0;
            gbcCurrent1.weighty = 1.0;
            gbcCurrent1.gridx = 2;
            GridBagConstraints gbcAR1 = new GridBagConstraints();
            gbcAR1.gridx = 1;
            gbcAR1.gridy = 0;
            GridBagConstraints gbcAvailable1 = new GridBagConstraints();
            gbcAvailable1.fill = 1;
            gbcAvailable1.gridy = 0;
            gbcAvailable1.weightx = 1.0;
            gbcAvailable1.weighty = 1.0;
            gbcAvailable1.gridx = 0;
            this.pnlClientAreaSortOrder = new JPanel();
            this.pnlClientAreaSortOrder.setLayout(new GridBagLayout());
            this.pnlClientAreaSortOrder.setPreferredSize(new Dimension(250, 100));
            this.pnlClientAreaSortOrder.add((Component)this.getPnlSOAvailableColumns(), gbcAvailable1);
            this.pnlClientAreaSortOrder.add((Component)this.getPnlSOARButtons(), gbcAR1);
            this.pnlClientAreaSortOrder.add((Component)this.getPnlSOCurrent(), gbcCurrent1);
            this.pnlClientAreaSortOrder.add((Component)this.getPnlSOORButtons(), new GridBagConstraints());
        }
        return this.pnlClientAreaSortOrder;
    }

    private JPanel getPnlSOAvailableColumns() {
        if (this.pnlSOAvailableColumns == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.gridx = 0;
            this.pnlSOAvailableColumns = new JPanel();
            this.pnlSOAvailableColumns.setLayout(new GridBagLayout());
            this.pnlSOAvailableColumns.setBorder(BorderFactory.createTitledBorder(null, "Available Columns", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlSOAvailableColumns.setPreferredSize(new Dimension(125, 100));
            this.pnlSOAvailableColumns.add((Component)this.getSpneSOAvailable(), gridBagConstraints5);
        }
        return this.pnlSOAvailableColumns;
    }

    private JList getLstSOAvailable() {
        if (this.lstSOAvailable == null) {
            this.lstSOAvailable = new JList();
            this.lstSOAvailable.setModel(new DefaultListModel());
            this.lstSOAvailable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    STableColumnDialog.this.checkButtonsSO();
                }
            });
        }
        return this.lstSOAvailable;
    }

    private JPanel getPnlSOARButtons() {
        if (this.pnlSOARButtons == null) {
            GridBagConstraints gbcRemove1 = new GridBagConstraints();
            gbcRemove1.gridx = 0;
            gbcRemove1.gridy = 1;
            GridBagConstraints gbcAdd1 = new GridBagConstraints();
            gbcAdd1.gridx = 0;
            gbcAdd1.gridy = 0;
            this.pnlSOARButtons = new JPanel();
            this.pnlSOARButtons.setLayout(new GridBagLayout());
            this.pnlSOARButtons.add((Component)this.getBtnSOAdd(), gbcAdd1);
            this.pnlSOARButtons.add((Component)this.getBtnSORemove(), gbcRemove1);
        }
        return this.pnlSOARButtons;
    }

    private JButton getBtnSOAdd() {
        if (this.btnSOAdd == null) {
            this.btnSOAdd = new JButton();
            this.btnSOAdd.setEnabled(false);
            this.btnSOAdd.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/list-add.png")));
            this.btnSOAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.addSO();
                }
            });
        }
        return this.btnSOAdd;
    }

    private JButton getBtnSORemove() {
        if (this.btnSORemove == null) {
            this.btnSORemove = new JButton();
            this.btnSORemove.setEnabled(false);
            this.btnSORemove.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/list-remove.png")));
            this.btnSORemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.removeSO();
                }
            });
        }
        return this.btnSORemove;
    }

    private JPanel getPnlSOCurrent() {
        if (this.pnlSOCurrent == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridx = 0;
            this.pnlSOCurrent = new JPanel();
            this.pnlSOCurrent.setLayout(new GridBagLayout());
            this.pnlSOCurrent.setBorder(BorderFactory.createTitledBorder(null, "Current Columns", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlSOCurrent.setPreferredSize(new Dimension(125, 100));
            this.pnlSOCurrent.add((Component)this.getSpneSOCurrent(), gridBagConstraints6);
        }
        return this.pnlSOCurrent;
    }

    private JList getLstSOCurrent() {
        if (this.lstSOCurrent == null) {
            this.lstSOCurrent = new JList();
            this.lstSOCurrent.setModel(new DefaultListModel());
            this.lstSOCurrent.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    STableColumnDialog.this.checkButtonsSO();
                }
            });
        }
        return this.lstSOCurrent;
    }

    private JPanel getPnlSOORButtons() {
        if (this.pnlSOORButtons == null) {
            GridBagConstraints gbcDown1 = new GridBagConstraints();
            gbcDown1.fill = 2;
            gbcDown1.gridy = 3;
            gbcDown1.gridx = 0;
            GridBagConstraints gbcUp1 = new GridBagConstraints();
            gbcUp1.fill = 2;
            gbcUp1.gridy = 2;
            gbcUp1.gridx = 0;
            GridBagConstraints gbcDes = new GridBagConstraints();
            gbcDes.fill = 2;
            gbcDes.gridy = 1;
            gbcDes.gridx = 0;
            GridBagConstraints gbcAsc = new GridBagConstraints();
            gbcAsc.fill = 2;
            gbcAsc.gridy = 0;
            gbcAsc.gridx = 0;
            this.pnlSOORButtons = new JPanel();
            this.pnlSOORButtons.setLayout(new GridBagLayout());
            this.pnlSOORButtons.add((Component)this.getBtnSOAsc(), gbcAsc);
            this.pnlSOORButtons.add((Component)this.getBtnSODesc(), gbcDes);
            this.pnlSOORButtons.add((Component)this.getBtnSOUp(), gbcUp1);
            this.pnlSOORButtons.add((Component)this.getBtnSODown(), gbcDown1);
        }
        return this.pnlSOORButtons;
    }

    private JButton getBtnSOAsc() {
        if (this.btnSOAsc == null) {
            this.btnSOAsc = new JButton();
            this.btnSOAsc.setEnabled(false);
            this.btnSOAsc.setIcon(new ImageIcon(this.getClass().getResource("/images/sort-asc.png")));
            this.btnSOAsc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.changeToAscending();
                }
            });
        }
        return this.btnSOAsc;
    }

    private JButton getBtnSODesc() {
        if (this.btnSODesc == null) {
            this.btnSODesc = new JButton();
            this.btnSODesc.setEnabled(false);
            this.btnSODesc.setIcon(new ImageIcon(this.getClass().getResource("/images/sort-desc.png")));
            this.btnSODesc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.changeToDescending();
                }
            });
        }
        return this.btnSODesc;
    }

    private JButton getBtnSOUp() {
        if (this.btnSOUp == null) {
            this.btnSOUp = new JButton();
            this.btnSOUp.setEnabled(false);
            this.btnSOUp.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/go-up.png")));
            this.btnSOUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.upSO();
                }
            });
        }
        return this.btnSOUp;
    }

    private JButton getBtnSODown() {
        if (this.btnSODown == null) {
            this.btnSODown = new JButton();
            this.btnSODown.setEnabled(false);
            this.btnSODown.setIcon(new ImageIcon(this.getClass().getResource("/images/tango/16x16/actions/go-down.png")));
            this.btnSODown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    STableColumnDialog.this.downSO();
                }
            });
        }
        return this.btnSODown;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.refillLists();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        this.refillLists();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.refillLists();
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        this.refillLists();
    }

    @Override
    public void columnVisibilityChanged(STable table, TableColumn col, boolean visible) {
        this.refillLists();
    }

    private JScrollPane getSpneCOAvialable() {
        if (this.spneCOAvialable == null) {
            this.spneCOAvialable = new JScrollPane();
            this.spneCOAvialable.setViewportView(this.getLstCOAvailable());
        }
        return this.spneCOAvialable;
    }

    private JScrollPane getSpneCOCurrent() {
        if (this.spneCOCurrent == null) {
            this.spneCOCurrent = new JScrollPane();
            this.spneCOCurrent.setViewportView(this.getLstCOCurrent());
        }
        return this.spneCOCurrent;
    }

    private JScrollPane getSpneSOAvailable() {
        if (this.spneSOAvailable == null) {
            this.spneSOAvailable = new JScrollPane();
            this.spneSOAvailable.setViewportView(this.getLstSOAvailable());
        }
        return this.spneSOAvailable;
    }

    private JScrollPane getSpneSOCurrent() {
        if (this.spneSOCurrent == null) {
            this.spneSOCurrent = new JScrollPane();
            this.spneSOCurrent.setViewportView(this.getLstSOCurrent());
        }
        return this.spneSOCurrent;
    }
}

