DROP TABLE IF EXISTS `lck_login`;
DROP TABLE IF EXISTS `lck_resource`;
DROP TABLE IF EXISTS `lck_settings`;
DROP TABLE IF EXISTS `lck_msg`;

CREATE TABLE `lck_msg` (
       `ID` INT NOT NULL
     , `ID_UserFrom` INT NOT NULL
     , `ID_UserTo` INT NOT NULL
     , `MsgType` INT NOT NULL
     , `ParamInt` INT
     , `ParamTxt` CHAR(200)
     , `TS` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00'
     , `ATS` DATETIME
     , PRIMARY KEY (`ID`)
);
ALTER TABLE `lck_msg` COMMENT='V0.0.1';

CREATE TABLE `lck_settings` (
       `SECTION` CHAR(250) NOT NULL
     , `ENTRY` CHAR(250) NOT NULL
     , `VAL` CHAR(250) NOT NULL
     , PRIMARY KEY (`SECTION`, `ENTRY`)
);
ALTER TABLE `lck_settings` COMMENT='V0.0.1';

CREATE TABLE `lck_resource` (
       `ID` INT NOT NULL AUTO_INCREMENT
     , `UserID` INT
     , `DB` CHAR(50)
     , `TB` CHAR(50)
     , `KY` CHAR(50)
     , `PRG` CHAR(150)
     , `TS` DATETIME NOT NULL
     , `LockType` INT
     , UNIQUE `UQ_lck_resource_1` (`DB`, `TB`, `KY`, `PRG`)
     , PRIMARY KEY (`ID`)
);
ALTER TABLE `lck_resource` COMMENT='V0.0.1';

CREATE TABLE `lck_login` (
       `UserID` INT NOT NULL
     , `UserName` CHAR(200) NOT NULL
     , `NodeName` CHAR(200) NOT NULL
     , `TS` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00'
     , `VTS` DATETIME
     , PRIMARY KEY (`UserID`)
);
ALTER TABLE `lck_login` COMMENT='V0.0.1';

