/*
 * SAProf.HPP
 * Autor:               Stefan Milcke
 * Erstellt am:         14.03.2000
 * Letzte Aenderung am: 11.04.2000
 *
*/

#ifndef SAPROF_HPP_INCLUDED
#define SAPROF_HPP_INCLUDED

/* defines for OS/2 include */

/* Standard headers */

/* UI Class Library headers */
#include <iseq.h>
#include <istring.hpp>
#include <itmstamp.hpp>

/* Application headers */

/* OS/2 Headers */

class SAProfileEntry;
class SAProfileSection;

typedef ISequence <SAProfileEntry*> SAProfileEntryList;
typedef ISequence <SAProfileSection*> SAProfileSectionList;
typedef ISequence <IString *> SAProfileHeadingList;

/******************************************************************************/
/* Class SAProfile                                                            */
/******************************************************************************/
class SAProfile
{
 public:
  class Cursor;
  friend class SAProfile::Cursor;
  SAProfile(const SAProfile &aProfile);
  SAProfile(const char *profileName,bool resolveVariableSubstitutions=false);
  virtual ~SAProfile();

//  SAProfile &operator=(const SAProfile &aProfile);

  virtual IString defaultApplicationName() const
  { return iDefaultApplicationName; }
  virtual SAProfile &setDefaultApplicationName(const char *applName)
  { iDefaultApplicationName=applName; return *this; }
  virtual IString applicationOrKeyAt(const Cursor &cursor) const;
/*
  virtual SAProfileHandle handle() const;
*/
  virtual IString name() const
  { return iName; }
  virtual unsigned long numberOfApplications() const
  { return iSectionList.numberOfElements(); }
  virtual unsigned long numberOfKeys(const char *applName=0) const;
  virtual SAProfile &addOrReplaceElementWithKey(const char *key
                                                ,const IString &data
                                                ,const char *applName=0);
  virtual SAProfile &addOrReplaceElementWithKey(const char *key
                                                ,long data
                                                ,const char *applName=0)
  { return addOrReplaceElementWithKey(key,IString(data),applName); }
  virtual bool containsKeyName(const char *key,const char *applName=0) const;
  virtual bool containsApplication(const char *applName) const;
  virtual SAProfile &deleteElementWithApplication(const char *applName=0);
  virtual SAProfile &deleteElementWithKey(const char *key,const char *applName=0);
/*
  static void deleteProfile(const char *profileName);
*/
  virtual IString elementWithKey(const char *key,const char *applName=0);
  virtual long integerWithKey(const char *key,const char *applName=0);
  class Cursor
  {
   public:
    friend class SAProfile;
    Cursor(SAProfile &profile);
    Cursor(SAProfile &profile,const char *applName);
    virtual ~Cursor();
    virtual bool setToFirst();
    virtual bool setToNext();
    virtual bool setToPrevious();
    virtual bool setToLast();
    virtual bool isValid() const;
    virtual void invalidate();
   protected:
   private:
    IString iApplName;
    long iSectionPos;
    long iEntryPos;
    SAProfile *iProfile;
    mutable double iTS;
  }; // SAProfile::Cursor

  // Additional functions
  virtual bool isResolveVariableReferencesEnabled() const
  { return iResolveVariableReferences; }
  virtual SAProfile &enableResolveVariableReferences(bool enable=true);
  static bool isTimeCheckingEnabled();
  static void enableTimeChecking(bool enable=true);
  static void disableTimeChecking()
  { enableTimeChecking(false); }
 protected:
  virtual void reReadProfile() const;
  virtual void writeProfile();
  virtual long findApplication(const char *applName=0,bool reRead=true) const;
  virtual IString appNameFromArg(const char *applName=0) const
  { if(applName) return IString(applName); else return defaultApplicationName(); }
  virtual void purge() const;
 private:
  IString iName;
  IString iDefaultApplicationName;
  mutable SAProfileHeadingList iHeadingList;
  mutable SAProfileSectionList iSectionList;
  bool iChanged;
  bool iResolveVariableReferences;
  mutable double iTS;
};

#endif //SAPROF_HPP_INCLUDED
